/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.story.core.validation;

import edu.mit.story.core.StoryMessages;
import edu.mit.story.core.util.StringUtils;
import edu.mit.story.core.validation.BaseValidator;
import org.eclipse.jface.dialogs.IMessageProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IPAddressValidator
extends BaseValidator<String> {
    @Override
    public IMessageProvider validate(String ipaddress) {
        if (StringUtils.isNullorZero(ipaddress)) {
            return this.bind(StoryMessages.MSG_IPAddressNotValid, ipaddress, StoryMessages.MSG_IPAddressCannotBeEmpty);
        }
        String[] blocks = ipaddress.split("\\x2E");
        if (blocks.length != 4) {
            return this.bind(StoryMessages.MSG_IPAddressNotValid, ipaddress, StoryMessages.MSG_IPAddressMustHave4Blocks);
        }
        String[] stringArray = blocks;
        int n = blocks.length;
        int n2 = 0;
        while (n2 < n) {
            int byteBlock;
            String block = stringArray[n2];
            try {
                byteBlock = Integer.parseInt(block);
            }
            catch (NumberFormatException numberFormatException) {
                return this.bind(StoryMessages.MSG_IPAddressNotValid, ipaddress, StoryMessages.MSG_IPAddressBlocksMustHave8Bits);
            }
            if (byteBlock < 0 || 255 < byteBlock) {
                return this.bind(StoryMessages.MSG_IPAddressNotValid, ipaddress, StoryMessages.MSG_IPAddressBlocksMustHave8Bits);
            }
            ++n2;
        }
        return null;
    }
}

