/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.story.core.model.change;

import edu.mit.story.core.StoryMessages;
import edu.mit.story.core.desc.DescSet;
import edu.mit.story.core.desc.IDescSet;
import edu.mit.story.core.desc.factory.IDescFactory;
import edu.mit.story.core.descriptor.Descriptor;
import edu.mit.story.core.model.IMutableStoryModel;
import edu.mit.story.core.model.IStoryData;
import edu.mit.story.core.model.IStoryModel;
import edu.mit.story.core.model.change.AbstractModelChange;
import edu.mit.story.core.model.change.AddRepsWithConfigChange;
import edu.mit.story.core.model.change.Change;
import edu.mit.story.core.model.change.Flag;
import edu.mit.story.core.model.change.IModelChange;
import edu.mit.story.core.model.change.StoryChangeEvent;
import edu.mit.story.core.position.IHasPosition;
import edu.mit.story.core.property.IConfiguration;
import edu.mit.story.core.property.IRepConfiguration;
import edu.mit.story.core.property.RepConfiguration;
import edu.mit.story.core.rep.IRep;
import edu.mit.story.core.rep.RepComparator;
import edu.mit.story.core.rep.RepSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoveRepresentationsChange
extends AbstractModelChange {
    public final List<IRep> removeReps;

    public RemoveRepresentationsChange(IRep rep) {
        super(StoryMessages.CHANGE_NAME_RemoveRepresentations);
        if (rep == null) {
            this.removeReps = Collections.emptyList();
        } else {
            ArrayList<IRep> hidden = new ArrayList<IRep>();
            hidden.add(rep);
            this.removeReps = Collections.unmodifiableList(hidden);
        }
    }

    public RemoveRepresentationsChange(Collection<? extends IRep> reps) {
        super(StoryMessages.CHANGE_NAME_RemoveRepresentations);
        if (reps == null || reps.isEmpty()) {
            this.removeReps = Collections.emptyList();
        } else {
            TreeSet<IRep> orderedUnchecked = new TreeSet<IRep>(RepComparator.getReverseInstance());
            orderedUnchecked.addAll(reps);
            this.removeReps = Collections.unmodifiableList(new ArrayList<IRep>(orderedUnchecked));
        }
    }

    @Override
    protected StoryChangeEvent doApply(Object source, IMutableStoryModel provider) {
        ArrayList<IRep> removed = null;
        IStoryData data = provider.getData();
        ArrayList<IConfiguration> repConfigs = new ArrayList<IConfiguration>();
        for (IRep rep : this.removeReps) {
            IConfiguration config = data.getConfiguration(rep);
            if (config == null) continue;
            repConfigs.add(config);
        }
        RepConfiguration factConfigs = new RepConfiguration(new Descriptor("factories", "Factory Configurations", null));
        factConfigs.addAllSupport(this.removeReps);
        for (IRep rep : this.removeReps) {
            IDescFactory desc = provider.getFactory(rep);
            IConfiguration config = desc.getConfiguration();
            String nameFactory = desc.getID();
            factConfigs.put(rep.getID(), nameFactory);
            if (config == null) continue;
            factConfigs.putConfiguration(rep.getID(), config);
        }
        for (IRep rep : this.removeReps) {
            if (!data.supports(rep)) continue;
            boolean canRemove = true;
            Iterator i = data.repIterator();
            while (i.hasNext()) {
                IRep iRep = (IRep)i.next();
                if (!iRep.dependsOn(rep)) continue;
                canRemove = false;
                break;
            }
            if (!canRemove) continue;
            IDescSet descSet = data.getDescriptions(rep);
            if (descSet != null) {
                descSet = new DescSet(descSet);
            }
            if (!data.removeSupport(rep)) {
                throw new IllegalStateException("Something's wrong: Removal should have succeeded");
            }
            if (removed == null) {
                removed = new ArrayList<IRep>();
            }
            removed.add((IRep)(descSet == null ? rep : descSet));
        }
        if (removed == null) {
            return null;
        }
        StoryChangeEvent changeEv = new StoryChangeEvent(source, provider, new RepSet(this.removeReps), new Change(Flag.REP_REMOVED, (IHasPosition[])new IStoryModel[]{provider}), (IModelChange)this, (IModelChange)new AddRepsWithConfigChange(this.removeReps, repConfigs, (IRepConfiguration)factConfigs));
        return changeEv;
    }
}

