/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.story.core.model;

import edu.mit.story.core.StoryMessages;
import edu.mit.story.core.StoryPlugin;
import edu.mit.story.core.desc.Desc;
import edu.mit.story.core.desc.IData;
import edu.mit.story.core.desc.IDesc;
import edu.mit.story.core.desc.IStructuredData;
import edu.mit.story.core.desc.factory.FactoryUtils;
import edu.mit.story.core.desc.factory.IDescFactory;
import edu.mit.story.core.desc.factory.IFactoryDescriptor;
import edu.mit.story.core.mappers.BlockMapper;
import edu.mit.story.core.measure.IResult;
import edu.mit.story.core.measure.Result;
import edu.mit.story.core.meta.IMetaDesc;
import edu.mit.story.core.meta.IMetaRep;
import edu.mit.story.core.meta.MetaDesc;
import edu.mit.story.core.meta.check.Check;
import edu.mit.story.core.meta.check.CheckMetaRep;
import edu.mit.story.core.meta.origin.Origin;
import edu.mit.story.core.meta.origin.OriginMetaRep;
import edu.mit.story.core.meta.timing.ITiming;
import edu.mit.story.core.meta.timing.TimingMetaRep;
import edu.mit.story.core.model.IMutableStoryModel;
import edu.mit.story.core.model.IStoryData;
import edu.mit.story.core.model.IStoryModel;
import edu.mit.story.core.model.StoryModel;
import edu.mit.story.core.position.IHasPosition;
import edu.mit.story.core.position.SimplePosition;
import edu.mit.story.core.rep.IHasRep;
import edu.mit.story.core.rep.IRep;
import edu.mit.story.core.util.IHasVersion;
import edu.mit.story.core.util.XMLUtils;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.osgi.framework.Version;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StoryModelImporter {
    private String resourceName = "";

    public void setResourceName(String name) {
        if (name == null) {
            name = "";
        }
        this.resourceName = name;
    }

    public String getResourceName() {
        return this.resourceName;
    }

    public IMutableStoryModel importFromXML(String content, String corpusName) {
        return this.importFromXML(new StringReader(content), corpusName);
    }

    public IMutableStoryModel importFromXML(Reader reader, String corpusName) {
        Document doc = XMLUtils.fromString(reader);
        return doc == null ? null : this.importFromXML(doc, corpusName);
    }

    /*
     * Unable to fully structure code
     */
    public IMutableStoryModel importFromXML(Document doc, String corpusName) {
        result = null;
        data = null;
        fm = StoryPlugin.getDefault().getFactoryManager();
        nodeList = doc.getElementsByTagName("rep");
        repNodes = new TreeMap<RepVersion, Element>();
        i = 0;
        while (i < nodeList.getLength()) {
            element = (Element)nodeList.item(i);
            repVer = this.importRep(element);
            if (repVer.getRep() == null) {
                sb = new StringBuilder();
                sb.append("Could not find representation: ");
                sb.append(element.getAttribute("id"));
                this.logError(sb.toString(), null);
            } else if (repNodes.containsKey(repVer)) {
                message = String.valueOf(StoryMessages.MSG_ERR_XML_RepMultiplyDefined) + " : " + repVer.getRep().getID();
                this.logError(message, null);
            } else {
                repNodes.put(repVer, (Element)nodeList.item(i));
            }
            ++i;
        }
        for (Map.Entry<K, V> entry : repNodes.entrySet()) {
            repVer = (RepVersion)entry.getKey();
            element = (Element)entry.getValue();
            configDesc = repVer.getRep().getConfigurationDescriptor();
            v0 = config = configDesc == null ? null : configDesc.create(XMLUtils.extractConfiguration(element));
            if (result == null) {
                result = new StoryModel(repVer.getRep(), corpusName);
                data = result.getData();
            } else {
                if (repVer.getRep().getID().equals("edu.mit.parsing.pos") && !result.supports(collocRep = StoryPlugin.getDefault().getRepManager().getRep("edu.mit.parsing.colloc"))) {
                    data.addSupport(collocRep);
                }
                data.addSupport(repVer.getRep());
            }
            if (config != null) {
                data.setConfiguration(config);
            }
            if ((children = element.getElementsByTagName("factory")).getLength() == 1) {
                factory = FactoryUtils.fromXML((Element)children.item(0));
            } else {
                factoryDesc = (IFactoryDescriptor)fm.getPlatformDefault(repVer.getRep());
                v1 = factory = factoryDesc == null ? null : (IDescFactory)factoryDesc.create();
                if (children.getLength() > 1) {
                    message = String.valueOf(StoryMessages.MSG_ERR_XML_RepMultiplyDefined) + " : " + repVer.getRep().getID();
                    this.logError(message, null);
                }
            }
            if (factory != null) {
                result.setFactory(factory);
            }
            descSet = data.getDescriptions(repVer.getRep());
            children = element.getElementsByTagName("desc");
            j = 0;
            while (j < children.getLength()) {
                element = (Element)children.item(j);
                desc = this.importDesc(element, repVer.getRep(), repVer.getVersion(), result);
                if (desc != null) {
                    result.incrementPastID(desc.getID());
                    descSet.add(desc);
                }
                ++j;
            }
        }
        nodeList = doc.getElementsByTagName("metaRep");
        i = 0;
        while (i < nodeList.getLength()) {
            element = (Element)nodeList.item(i);
            metaRep = this.importMetaRep(element);
            children = element.getElementsByTagName("metaDesc");
            j = 0;
            while (j < children.getLength()) {
                block21: {
                    element = (Element)children.item(j);
                    metaDesc = this.importMetaDesc(element, metaRep);
                    if (metaDesc == null) break block21;
                    id = metaDesc.getDescriptionID();
                    if (id < 0L) ** GOTO lbl-1000
                    desc = null;
                    if (result.getData().supports(metaDesc.getRep())) {
                        desc = result.getData().getDescriptions(metaDesc.getRep()).getDescription(id);
                    }
                    if (desc != null) {
                        desc.getMetaData().addDesc(metaDesc);
                    } else lbl-1000:
                    // 2 sources

                    {
                        result.getData().getMetadata().addDesc(metaDesc);
                    }
                }
                ++j;
            }
            ++i;
        }
        this.processLegacyChecks(doc, data);
        this.processLegacyTimings(doc, data);
        return result;
    }

    protected RepVersion importRep(Node node) {
        String id = XMLUtils.extractID(node);
        IRep rep = StoryPlugin.getDefault().getRepManager().getRep(id);
        Version ver = IHasVersion.v1;
        Node verNode = node.getAttributes().getNamedItem("ver");
        if (verNode != null) {
            ver = new Version(verNode.getNodeValue());
        }
        return new RepVersion(rep, ver);
    }

    protected IDesc importDesc(Element node, IRep rep, Version version, IStoryModel provider) {
        String dataStr;
        Node offsetNode;
        if (node == null || rep == null) {
            return null;
        }
        if (!node.getNodeName().equals("desc")) {
            return null;
        }
        NamedNodeMap attrs = node.getAttributes();
        long id = -1L;
        Node idNode = attrs.getNamedItem("id");
        if (idNode != null) {
            try {
                id = Long.parseLong(idNode.getNodeValue());
            }
            catch (NumberFormatException numberFormatException) {}
        }
        if ((offsetNode = attrs.getNamedItem("off")) == null) {
            throw new RuntimeException(StoryMessages.MSG_ERR_XML_DescNodeNoOffsetAttr);
        }
        String offsetValue = offsetNode.getNodeValue();
        if (offsetValue == null) {
            throw new RuntimeException(StoryMessages.MSG_ERR_XML_DescNodeNullOffsetAttr);
        }
        if (offsetValue.equals("")) {
            throw new RuntimeException(StoryMessages.MSG_ERR_XML_DescNodeEmptyOffsetAttr);
        }
        int offset = Integer.parseInt(offsetValue);
        Node lengthNode = attrs.getNamedItem("len");
        if (lengthNode == null) {
            throw new RuntimeException(StoryMessages.MSG_ERR_XML_DescNodeNoLengthAttr);
        }
        String lengthValue = lengthNode.getNodeValue();
        if (lengthValue == null) {
            throw new RuntimeException(StoryMessages.MSG_ERR_XML_DescNodeNullLengthAttr);
        }
        if (lengthValue.equals("")) {
            throw new RuntimeException(StoryMessages.MSG_ERR_XML_DescNodeEmptyLengthAttr);
        }
        int length = Integer.parseInt(lengthValue);
        boolean isUser = false;
        Node userNode = attrs.getNamedItem("user");
        if (userNode != null) {
            isUser = Boolean.parseBoolean(userNode.getNodeValue());
        }
        if ((dataStr = node.getTextContent()) == null) {
            dataStr = "";
        }
        IHasPosition p = new SimplePosition(offset, length);
        IData data = null;
        try {
            data = rep.reconstitute(p, dataStr, provider, version);
        }
        catch (Exception e) {
            StringBuilder sb = new StringBuilder();
            sb.append("Exception reconsituting description <desc id=\"");
            sb.append(Long.toString(id));
            sb.append("\" len=\"");
            sb.append(Integer.toString(length));
            sb.append("\" off=\"");
            sb.append(Integer.toString(offset));
            sb.append("\">");
            sb.append(dataStr);
            sb.append("</desc>");
            this.logWarning(sb.toString(), e);
        }
        if (data instanceof IStructuredData) {
            IStructuredData sdata = (IStructuredData)data;
            p = sdata.calculatePosition();
        }
        Desc newDesc = data == null ? new Desc(dataStr, rep, id, p, null) : new Desc(id, rep, p, data, null);
        if (isUser) {
            newDesc.getMetaData().addDesc(new MetaDesc<Origin>(OriginMetaRep.getInstance(), newDesc, Origin.USER_SPECIFIED));
        }
        return newDesc;
    }

    protected IMetaRep<?> importMetaRep(Element element) {
        String id = element.getAttribute("id");
        return StoryPlugin.getDefault().getMetaRepManager().getMetaRep(id);
    }

    protected IMetaDesc<?> importMetaDesc(Element element, IMetaRep<?> metaRep) {
        String repID = element.getAttribute("repID");
        IRep rep = StoryPlugin.getDefault().getRepManager().getRep(repID);
        if (rep == null) {
            return null;
        }
        String descIDStr = element.getAttribute("descID");
        long descID = -1L;
        if (descIDStr != null) {
            try {
                descID = Long.parseLong(descIDStr);
            }
            catch (Exception exception) {}
        }
        String dataStr = element.getTextContent();
        Object data = metaRep.reconstitute(dataStr);
        return new MetaDesc(metaRep, rep, descID, data, dataStr);
    }

    protected void processLegacyChecks(Document doc, IStoryData data) {
        NodeList nodeList = doc.getElementsByTagName("check");
        if (nodeList.getLength() == 0) {
            return;
        }
        int i = 0;
        while (i < nodeList.getLength()) {
            IDesc desc;
            Element element = (Element)nodeList.item(i);
            String target = element.getAttribute("obj");
            String check = element.getAttribute("data");
            if ((check = check.trim()).length() == 0) {
                // empty if block
            }
            long id = -1L;
            try {
                id = Long.parseLong(target);
            }
            catch (Exception exception) {}
            if (id != -1L && (desc = data.getDescription(id)) != null) {
                MetaDesc<Check> metaDesc = new MetaDesc<Check>(CheckMetaRep.getInstance(), desc, new Check(check));
                desc.getMetaData().addDesc(metaDesc);
            }
            ++i;
        }
    }

    protected void processLegacyTimings(Document doc, IStoryData data) {
        NodeList nodeList = doc.getElementsByTagName("timing");
        if (nodeList.getLength() == 0) {
            return;
        }
        ArrayList<String> fields = new ArrayList<String>(3);
        int i = 0;
        while (i < nodeList.getLength()) {
            MetaDesc<ITiming> metaDesc;
            IDesc desc;
            Element element = (Element)nodeList.item(i);
            String target = element.getAttribute("obj");
            String repID = element.getAttribute("rep");
            fields.clear();
            String start = element.getAttribute("start");
            fields.add(start == null ? "" : start);
            String stop = element.getAttribute("stop");
            fields.add(stop == null ? "" : stop);
            String tag = element.getAttribute("tag");
            fields.add(tag == null ? "" : tag);
            String dataStr = BlockMapper.PIPE.serialize(fields);
            ITiming timing = TimingMetaRep.getInstance().reconstitute(dataStr);
            long id = -1L;
            try {
                id = Long.parseLong(target);
            }
            catch (Exception exception) {
                repID = target;
            }
            if (id >= 0L && (desc = data.getDescription(id)) != null) {
                metaDesc = new MetaDesc<ITiming>(TimingMetaRep.getInstance(), desc, timing);
                desc.getMetaData().addDesc(metaDesc);
            } else {
                IDesc d;
                IRep rep = StoryPlugin.getDefault().getRepManager().getRep(repID);
                if (rep == null && id >= 0L && (d = data.getDescription(id)) != null) {
                    rep = d.getRep();
                }
                if (rep != null) {
                    metaDesc = id >= 0L ? new MetaDesc<ITiming>(TimingMetaRep.getInstance(), rep, id, timing) : new MetaDesc<ITiming>(TimingMetaRep.getInstance(), rep, timing);
                    data.getMetadata().addDesc(metaDesc);
                }
            }
            ++i;
        }
    }

    protected void logError(String message, Throwable e) {
        this.log(4, message, e);
    }

    protected void logWarning(String message, Throwable e) {
        this.log(2, message, e);
    }

    protected void log(int severity, String message, Throwable e) {
        StringBuilder sb = new StringBuilder();
        sb.append(message);
        if (this.resourceName != null && this.resourceName.length() > 0) {
            sb.append(": in file ");
            sb.append(this.resourceName);
        }
        StoryPlugin.getDefault().getLog().log((IStatus)new Status(severity, "edu.mit.story.core", sb.toString(), e));
    }

    public static IMutableStoryModel extractModel(IFile file, List<IResult> results) {
        IMutableStoryModel model;
        InputStream contents;
        if (file == null) {
            throw new NullPointerException();
        }
        if (results == null) {
            results = new ArrayList<IResult>(1);
        }
        StringBuilder sb = new StringBuilder();
        sb.append(File.separatorChar);
        sb.append(file.getProject().getName());
        sb.append(File.separatorChar);
        sb.append(file.getProjectRelativePath().toOSString());
        String resourceName = sb.toString();
        try {
            contents = file.getContents();
        }
        catch (CoreException e) {
            results.add(new Result((IResource)file, "Unable to get contents of file " + resourceName, e));
            return null;
        }
        StoryModelImporter importer = new StoryModelImporter();
        importer.setResourceName(resourceName);
        try {
            model = importer.importFromXML(new InputStreamReader(contents), file.getProject().getName());
        }
        catch (Exception e) {
            results.add(new Result((IResource)file, "Unable parse story file " + resourceName, e));
            return null;
        }
        return model;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class RepVersion
    implements IHasVersion,
    IHasRep,
    Comparable<RepVersion> {
        private final IRep rep;
        private final Version ver;

        public RepVersion(IRep rep, Version ver) {
            if (ver == null) {
                ver = IHasVersion.v1;
            }
            this.rep = rep;
            this.ver = ver;
        }

        @Override
        public Version getVersion() {
            return this.ver;
        }

        @Override
        public IRep getRep() {
            return this.rep;
        }

        @Override
        public int compareTo(RepVersion rv) {
            return this.rep.compareTo(rv.getRep());
        }
    }
}

