/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.story.core.mappers;

import edu.mit.story.core.mappers.IValueMapper;
import edu.mit.story.core.util.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HostnameValueMapper
implements IValueMapper<String> {
    public static final String semicolon = ";";

    @Override
    public List<String> reconstitute(String value) {
        String[] hostnames;
        ArrayList<String> result = new ArrayList<String>();
        String[] stringArray = hostnames = value.split(semicolon);
        int n = hostnames.length;
        int n2 = 0;
        while (n2 < n) {
            String hostname = stringArray[n2];
            if (!StringUtils.isEmpty(hostname)) {
                result.add(hostname);
            }
            ++n2;
        }
        return result;
    }

    @Override
    public String serialize(Collection<? extends String> objects) {
        TreeSet<? extends String> hostnames = new TreeSet<String>();
        hostnames.addAll(objects);
        StringBuffer sb = new StringBuffer();
        Iterator i = hostnames.iterator();
        while (i.hasNext()) {
            String hostname = (String)i.next();
            if (hostname.equals("")) continue;
            sb.append(hostname);
            if (!i.hasNext()) continue;
            sb.append(semicolon);
        }
        return sb.toString();
    }
}

