/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.wordnet.core.rep.sense.rules;

import edu.mit.parsing.core.rep.stem.IStem;
import edu.mit.parsing.core.rep.stem.StemRep;
import edu.mit.story.core.build.AbstractBuildRule;
import edu.mit.story.core.build.IStoryProblem;
import edu.mit.story.core.desc.IDesc;
import edu.mit.story.core.desc.IDescSet;
import edu.mit.story.core.meta.merge.MergeMetaRep;
import edu.mit.story.core.model.IStoryModel;
import edu.mit.story.core.position.HasPositionSet;
import edu.mit.story.core.position.IHasPositionSet;
import edu.mit.wordnet.core.rep.sense.ISense;
import edu.mit.wordnet.core.rep.sense.SenseRep;
import edu.mit.wordnet.core.rep.sense.problems.MissingStemProblem;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.SortedSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CheckSenseStemRule
extends AbstractBuildRule {
    public CheckSenseStemRule() {
        super(SenseRep.getInstance());
    }

    public IHasPositionSet<IStoryProblem> build(IStoryModel model) {
        Set stems;
        HashSet<IDesc> missing = new HashSet<IDesc>();
        IDescSet stemDescs = model.getData().getDescriptions(StemRep.getInstance());
        HashMap<IDesc, HashSet<IDesc>> wordToStems = new HashMap<IDesc, HashSet<IDesc>>(stemDescs.size());
        for (IDesc stemDesc : stemDescs) {
            IStem stem = (IStem)stemDesc.getData();
            stems = (HashSet<IDesc>)wordToStems.get(stem.getWord());
            if (stems == null) {
                stems = new HashSet<IDesc>(1);
                wordToStems.put(stem.getWord(), (HashSet<IDesc>)stems);
            }
            stems.add(stemDesc);
        }
        IDescSet senseDescs = model.getData().getDescriptions(SenseRep.getInstance());
        HashSet<IDesc> matches = new HashSet<IDesc>(4);
        for (IDesc senseDesc : senseDescs) {
            IDesc stemDesc;
            ISense sense = (ISense)senseDesc.getData();
            stems = (Set)wordToStems.get(sense.getWord());
            if (stems == null) continue;
            SortedSet profile = MergeMetaRep.extractMergeProfile((IDesc)senseDesc);
            matches.clear();
            for (IDesc d : stems) {
                if (!MergeMetaRep.matches((IDesc)d, (Collection)profile)) continue;
                matches.add(d);
            }
            if (matches.isEmpty() || (stemDesc = sense.getStemDesc()) != null) continue;
            missing.add(senseDesc);
        }
        if (missing.isEmpty()) {
            return null;
        }
        HasPositionSet result = new HasPositionSet();
        for (IDesc d : missing) {
            result.add((Object)new MissingStemProblem(d, this.getID()));
        }
        return result;
    }
}

