/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.story.ui.wizards;

import edu.mit.story.core.StoryPlugin;
import edu.mit.story.core.datamodel.IMergeTargetsModel;
import edu.mit.story.core.datamodel.IRepSetsModel;
import edu.mit.story.core.datamodel.ITagModel;
import edu.mit.story.core.datamodel.MergeModel;
import edu.mit.story.core.datamodel.MergeTargetsModel;
import edu.mit.story.core.merge.IMergeModel;
import edu.mit.story.ui.actions.SelectionUtils;
import edu.mit.story.ui.controllers.IResourcePairController;
import edu.mit.story.ui.controllers.ResourcePairController;
import edu.mit.story.ui.ops.MergeOperation;
import edu.mit.story.ui.wizards.page.TransferRepsPage;
import edu.mit.story.ui.wizards.page.TransferTargetsPage;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;

public class MergeWizard
extends Wizard {
    protected final IResourcePairController<IMergeTargetsModel> controller;
    protected TransferTargetsPage pageOne;
    protected TransferRepsPage pageTwo;

    public MergeWizard(ISelection selection) {
        IFile source = null;
        IFile target = null;
        IStructuredSelection struct = SelectionUtils.castAsStructuredSelection(selection);
        if (struct != null) {
            for (Object obj : struct.toList()) {
                IFile file;
                if (!(obj instanceof IFile) || !(file = (IFile)obj).getFileExtension().equals("sty")) continue;
                if (source == null) {
                    source = file;
                    continue;
                }
                target = file;
                break;
            }
        }
        MergeTargetsModel model = new MergeTargetsModel();
        model.setSource(source == null ? null : source.getRawLocation().toFile());
        model.setTarget(target == null ? null : target.getRawLocation().toFile());
        this.controller = new ResourcePairController<MergeTargetsModel>(model);
        this.setWindowTitle("Merge Story Files");
    }

    public void addPages() {
        this.pageOne = new TransferTargetsPage(this.controller);
        this.addPage((IWizardPage)this.pageOne);
        this.pageTwo = new TransferRepsPage((IMergeModel)new MergeModel((IRepSetsModel)this.controller.getModel(), (ITagModel)this.controller.getModel()));
        this.addPage((IWizardPage)this.pageTwo);
    }

    public boolean performFinish() {
        MergeOperation op = new MergeOperation(this.pageTwo.getModel(), this.controller.getModel());
        try {
            this.getContainer().run(true, true, (IRunnableWithProgress)op);
        }
        catch (Exception e) {
            Status status = new Status(4, "edu.mit.story.core", "Transfer failed", (Throwable)e);
            StoryPlugin.getDefault().getLog().log((IStatus)status);
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public boolean canFinish() {
        return this.pageTwo.getModel().getMessageType() != 3;
    }
}

