/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.story.ui.preferences.editor;

import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class RadioGroupIntFieldEditor
extends FieldEditor {
    private String[] labels;
    private int[] values;
    private int numColumns;
    private int indent = 8;
    private int value = 0;
    private Composite radioBox;
    private Button[] radioButtons;
    private boolean useGroup;

    protected RadioGroupIntFieldEditor() {
    }

    public RadioGroupIntFieldEditor(String name, String labelText, int numColumns, String[] labels, int[] values, Composite parent) {
        this(name, labelText, numColumns, labels, values, parent, false);
    }

    public RadioGroupIntFieldEditor(String name, String labelText, int numColumns, String[] labels, int[] values, Composite parent, boolean useGroup) {
        this.init(name, labelText);
        if (labels.length != values.length) {
            throw new IllegalArgumentException();
        }
        this.labels = labels;
        this.values = values;
        this.numColumns = numColumns;
        this.useGroup = useGroup;
        this.createControl(parent);
    }

    protected void adjustForNumColumns(int numColumns) {
        Label control = this.getLabelControl();
        if (control != null) {
            ((GridData)control.getLayoutData()).horizontalSpan = numColumns;
        }
        ((GridData)this.radioBox.getLayoutData()).horizontalSpan = numColumns;
    }

    protected void doFillIntoGrid(Composite parent, int numColumns) {
        if (this.useGroup) {
            Composite control = this.getRadioBoxControl(parent);
            GridData gd = new GridData(768);
            control.setLayoutData((Object)gd);
        } else {
            Label control = this.getLabelControl(parent);
            GridData gd = new GridData();
            gd.horizontalSpan = numColumns;
            control.setLayoutData((Object)gd);
            control = this.getRadioBoxControl(parent);
            gd = new GridData();
            gd.horizontalSpan = numColumns;
            gd.horizontalIndent = this.indent;
            control.setLayoutData((Object)gd);
        }
    }

    protected void doLoad() {
        this.updateValue(this.getPreferenceStore().getInt(this.getPreferenceName()));
    }

    protected void doLoadDefault() {
        this.updateValue(this.getPreferenceStore().getDefaultInt(this.getPreferenceName()));
    }

    protected void doStore() {
        this.getPreferenceStore().setValue(this.getPreferenceName(), this.value);
    }

    public int getNumberOfControls() {
        return 1;
    }

    public Composite getRadioBoxControl(Composite parent) {
        if (this.radioBox == null) {
            Font font = parent.getFont();
            if (this.useGroup) {
                Group group = new Group(parent, 0);
                group.setFont(font);
                String text = this.getLabelText();
                if (text != null) {
                    group.setText(text);
                }
                this.radioBox = group;
                GridLayout layout = new GridLayout();
                layout.horizontalSpacing = 8;
                layout.numColumns = this.numColumns;
                this.radioBox.setLayout((Layout)layout);
            } else {
                this.radioBox = new Composite(parent, 0);
                GridLayout layout = new GridLayout();
                layout.marginWidth = 0;
                layout.marginHeight = 0;
                layout.horizontalSpacing = 8;
                layout.numColumns = this.numColumns;
                this.radioBox.setLayout((Layout)layout);
                this.radioBox.setFont(font);
            }
            this.radioButtons = new Button[this.labels.length];
            int i = 0;
            while (i < this.labels.length) {
                Button radio;
                this.radioButtons[i] = radio = new Button(this.radioBox, 16400);
                radio.setText(this.labels[i]);
                radio.setData((Object)this.values[i]);
                radio.setFont(font);
                radio.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent event) {
                        Integer oldValue = RadioGroupIntFieldEditor.this.value;
                        RadioGroupIntFieldEditor.this.value = (Integer)event.widget.getData();
                        RadioGroupIntFieldEditor.this.setPresentsDefaultValue(false);
                        RadioGroupIntFieldEditor.this.fireValueChanged("field_editor_value", oldValue, RadioGroupIntFieldEditor.this.value);
                    }
                });
                ++i;
            }
            this.radioBox.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent event) {
                    RadioGroupIntFieldEditor.this.radioBox = null;
                    RadioGroupIntFieldEditor.this.radioButtons = null;
                }
            });
        } else {
            this.checkParent((Control)this.radioBox, parent);
        }
        return this.radioBox;
    }

    public void setIndent(int indent) {
        this.indent = indent < 0 ? 0 : indent;
    }

    private void updateValue(int selectedValue) {
        this.value = selectedValue;
        if (this.radioButtons == null) {
            return;
        }
        boolean found = false;
        int i = 0;
        while (i < this.radioButtons.length) {
            Button radio = this.radioButtons[i];
            boolean selection = false;
            if (((Integer)radio.getData()).equals(this.value)) {
                selection = true;
                found = true;
            }
            radio.setSelection(selection);
            ++i;
        }
        if (found) {
            return;
        }
        if (this.radioButtons.length > 0) {
            this.radioButtons[0].setSelection(true);
            this.value = (Integer)this.radioButtons[0].getData();
        }
    }

    public void setEnabled(boolean enabled, Composite parent) {
        if (!this.useGroup) {
            super.setEnabled(enabled, parent);
        }
        int i = 0;
        while (i < this.radioButtons.length) {
            this.radioButtons[i].setEnabled(enabled);
            ++i;
        }
    }
}

