/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.story.ui.document;

import edu.mit.story.core.desc.IDesc;
import edu.mit.story.core.model.IStoryModel;
import edu.mit.story.core.model.IUndoableStoryModel;
import edu.mit.story.core.model.StoryModel;
import edu.mit.story.core.model.StoryModelExporter;
import edu.mit.story.core.model.change.Change;
import edu.mit.story.core.model.change.IModelChange;
import edu.mit.story.core.model.change.IModelListener;
import edu.mit.story.core.model.change.RemoveDescriptionsChange;
import edu.mit.story.core.model.change.StoryChangeEvent;
import edu.mit.story.core.rep.IRep;
import edu.mit.story.core.rep.RepUtils;
import edu.mit.story.core.rep.character.CharRep;
import edu.mit.story.core.rep.character.ICharStore;
import edu.mit.story.core.util.XMLUtils;
import edu.mit.story.ui.StoryUIPlugin;
import edu.mit.story.ui.document.IStoryDocument;
import edu.mit.story.ui.model.DocListeningStoryModel;
import java.util.Collection;
import java.util.LinkedList;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.IFileBuffer;
import org.eclipse.core.filebuffers.IFileBufferListener;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.ConfigurableLineTracker;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ILineTracker;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class StoryDocument
extends Document
implements IStoryDocument,
IModelListener {
    private static final String[] legalLineDelimiters = new String[]{"\n"};
    private boolean xmlVisible = false;
    private String corpusName;
    final IDocument xmlDoc = new Document();
    final XMLDocumentSynchronizer xmlUpdater = new XMLDocumentSynchronizer();
    final DocListeningStoryModel model = new DocListeningStoryModel(CharRep.getInstance());

    public StoryDocument() {
        this.setLineTracker((ILineTracker)new ConfigurableLineTracker(legalLineDelimiters));
        this.addDocumentListener(this.model);
        this.model.addModelListener(this.xmlUpdater);
        this.model.addModelListener(this);
        ITextFileBufferManager manager = FileBuffers.getTextFileBufferManager();
        if (manager != null) {
            manager.addFileBufferListener((IFileBufferListener)new BufferListener());
        }
    }

    public void set(String xmlText, long modificationStamp) {
        this.model.setCorpus(this.corpusName);
        this.model.setXML(xmlText);
        LinkedList<IDesc> toRemove = new LinkedList<IDesc>();
        StoryModel malformed = new StoryModel(this.model.getPrimary());
        for (IDesc next : this.model.getData()) {
            if (next.getData() != null) continue;
            toRemove.add(next);
            malformed.getData().addAllSupport((Collection)RepUtils.getAllAntecedents((IRep)next.getRep()));
            malformed.getData().addSupport(next.getRep());
            malformed.getData().add((Object)next);
        }
        if (!malformed.getData().isEmpty()) {
            org.w3c.dom.Document doc = StoryModelExporter.getInstance().exportToXML((IStoryModel)malformed);
            String data = XMLUtils.toString((org.w3c.dom.Document)doc);
            Status status = new Status(4, "edu.mit.story.ui", data);
            String message = "Null descriptions were found in the story file; these will be automatically deleted.  The story file will be marked as 'changed'.  To save these changes, save the file.";
            ErrorDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"Null Descriptions", (String)message, (IStatus)status);
            StoryUIPlugin.getDefault().getLog().log((IStatus)status);
        }
        this.model.init();
        ICharStore store = CharRep.extractCharStore((Collection)this.model.getData());
        if (store == null) {
            return;
        }
        this.model.setIgnoreChanges(true);
        super.set(store.get(0, store.getLength()), modificationStamp);
        this.model.setIgnoreChanges(false);
        if (!toRemove.isEmpty()) {
            this.model.applyChange(this, (IModelChange)new RemoveDescriptionsChange(toRemove), false);
        }
    }

    public void dispose() {
        this.model.removeModelListener(this.xmlUpdater);
        this.model.dispose();
    }

    public String get() {
        return this.model.getXML();
    }

    public void modelChanged(StoryChangeEvent e) {
        String newText;
        if (e.source == this) {
            return;
        }
        IRep charRep = CharRep.getInstance();
        Change change = e.getChange(charRep);
        if (change == null) {
            return;
        }
        ICharStore store = CharRep.extractCharStore((Collection)this.model.getData());
        if (store == null) {
            return;
        }
        String currText = this.getStore().get(0, this.getStore().getLength());
        if (currText.equals(newText = store.get(0, store.getLength()))) {
            return;
        }
        this.model.setIgnoreChanges(true);
        try {
            this.replace(0, this.getLength(), newText);
        }
        catch (BadLocationException ex) {
            ex.printStackTrace();
        }
        this.model.setIgnoreChanges(false);
    }

    public IDocument getXMLDocument() {
        return this.xmlDoc;
    }

    public void setXMLVisible(boolean value) {
        if (value ^ this.xmlVisible) {
            this.xmlVisible = value;
            if (this.xmlVisible & this.xmlUpdater != null) {
                this.xmlUpdater.update();
            }
        }
    }

    public boolean isXMLVisible() {
        return this.xmlVisible;
    }

    public IUndoableStoryModel getStoryModel() {
        return this.model;
    }

    public String getCorpus() {
        return this.corpusName;
    }

    public void setCorpus(String corpusName) {
        this.corpusName = corpusName;
    }

    protected class BufferListener
    implements IFileBufferListener {
        protected BufferListener() {
        }

        public void bufferCreated(IFileBuffer buffer) {
        }

        public void bufferDisposed(IFileBuffer buffer) {
            if (!(buffer instanceof ITextFileBuffer)) {
                return;
            }
            if (((ITextFileBuffer)buffer).getDocument() == StoryDocument.this) {
                StoryDocument.this.dispose();
            }
        }

        public void bufferContentAboutToBeReplaced(IFileBuffer buffer) {
        }

        public void bufferContentReplaced(IFileBuffer buffer) {
        }

        public void stateChanging(IFileBuffer buffer) {
        }

        public void dirtyStateChanged(IFileBuffer buffer, boolean isDirty) {
        }

        public void stateValidationChanged(IFileBuffer buffer, boolean isStateValidated) {
        }

        public void underlyingFileMoved(IFileBuffer buffer, IPath path) {
        }

        public void underlyingFileDeleted(IFileBuffer buffer) {
        }

        public void stateChangeFailed(IFileBuffer buffer) {
        }
    }

    protected class XMLDocumentSynchronizer
    implements IModelListener {
        protected XMLDocumentSynchronizer() {
        }

        public void update() {
            if (!StoryDocument.this.xmlVisible) {
                return;
            }
            StoryDocument.this.getXMLDocument().set(StoryDocument.this.get());
        }

        public void modelChanged(StoryChangeEvent e) {
            this.update();
        }
    }
}

