/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.wordnet.ui.dialogs;

import edu.mit.jwi.item.IWord;
import edu.mit.jwi.item.POS;
import edu.mit.story.ui.viewers.ITableItemConfigurer;
import edu.mit.wordnet.ui.WordnetUIMessages;
import edu.mit.wordnet.ui.WordnetUIPlugin;
import edu.mit.wordnet.ui.WordnetUIUtils;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WordConfigurer
implements ITableItemConfigurer<IWord> {
    private static final Object separatorObject = new Object();
    private Table fTable;
    private Map<POS, Image> fImageMap;
    private Image fSeparatorImage;
    private Color fSeparatorColor;
    private int fSeparatorWidth;
    private int fSeparatorMessageLength;
    private String fSeparatorMessage;

    public static Object getSeparatorObject() {
        return separatorObject;
    }

    public void initialize(Table table) {
        this.fTable = table;
        GC gc = new GC((Drawable)table);
        gc.setFont(table.getFont());
        this.fSeparatorWidth = gc.getAdvanceWidth('-');
        Color fg = this.fTable.getForeground();
        int fGray = (int)(0.3 * (double)fg.getRed() + 0.59 * (double)fg.getGreen() + 0.11 * (double)fg.getBlue());
        Color bg = this.fTable.getBackground();
        int bGray = (int)(0.3 * (double)bg.getRed() + 0.59 * (double)bg.getGreen() + 0.11 * (double)bg.getBlue());
        int gray = (int)((double)(fGray + bGray) * 0.66);
        this.fSeparatorColor = new Color((Device)table.getDisplay(), gray, gray, gray);
        this.fImageMap = new HashMap<POS, Image>();
        ImageRegistry registry = WordnetUIPlugin.getDefault().getImageRegistry();
        POS[] pOSArray = POS.values();
        int n = pOSArray.length;
        int n2 = 0;
        while (n2 < n) {
            POS pos = pOSArray[n2];
            Image image = registry.get(WordnetUIUtils.getIconGIFImageKey(pos));
            this.fImageMap.put(pos, image);
            ++n2;
        }
        this.fSeparatorImage = registry.get("ctool16/separator.gif");
        this.fSeparatorMessage = " " + WordnetUIMessages.DIALOG_MESSAGE_SeparatorText + " ";
        this.fSeparatorMessageLength = gc.textExtent((String)this.fSeparatorMessage).x;
    }

    public void configure(TableItem tableItem, IWord item) {
        tableItem.setData((Object)item);
        tableItem.setImage(this.fImageMap.get(item.getPOS()));
        tableItem.setForeground(this.fTable.getForeground());
        StringBuilder sb = new StringBuilder();
        sb.append(item.getLemma());
        for (IWord synonym : item.getSynset().getWords()) {
            if (item == synonym) continue;
            sb.append(", ");
            sb.append(synonym.getLemma());
        }
        sb.append(" (");
        sb.append(item.getSenseKey().toString());
        sb.append(") ");
        sb.append(": ");
        sb.append(item.getSynset().getGloss());
        tableItem.setText(sb.toString());
    }

    public void configureSeparator(TableItem tableItem) {
        tableItem.setData(separatorObject);
        tableItem.setImage(this.fSeparatorImage);
        tableItem.setForeground(this.fSeparatorColor);
        Rectangle bounds = tableItem.getImageBounds(0);
        Rectangle area = this.fTable.getBounds();
        int width = area.width - bounds.x - bounds.width;
        StringBuffer dashes = new StringBuffer();
        int chars = (width - this.fSeparatorMessageLength) / this.fSeparatorWidth / 2 - 2;
        int i = 0;
        while (i < chars) {
            dashes.append('-');
            ++i;
        }
        StringBuffer result = new StringBuffer();
        result.append(dashes);
        result.append(this.fSeparatorMessage);
        result.append(dashes);
        tableItem.setText(result.toString());
    }
}

