/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.tagger.maxent;

import edu.stanford.nlp.io.PrintFile;
import edu.stanford.nlp.ling.HasWord;
import edu.stanford.nlp.ling.Sentence;
import edu.stanford.nlp.ling.TaggedWord;
import edu.stanford.nlp.ling.WordTag;
import edu.stanford.nlp.maxent.iis.LambdaSolve;
import edu.stanford.nlp.sequences.ExactBestSequenceFinder;
import edu.stanford.nlp.sequences.SequenceModel;
import edu.stanford.nlp.tagger.maxent.CollectionTaggerOutputs;
import edu.stanford.nlp.tagger.maxent.Dictionary;
import edu.stanford.nlp.tagger.maxent.Extractor;
import edu.stanford.nlp.tagger.maxent.ExtractorFrames;
import edu.stanford.nlp.tagger.maxent.ExtractorFramesRare;
import edu.stanford.nlp.tagger.maxent.FeatureKey;
import edu.stanford.nlp.tagger.maxent.GlobalHolder;
import edu.stanford.nlp.tagger.maxent.History;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.StringTokenizer;

public class TestSentence
implements SequenceModel {
    public static LambdaSolve prob;
    public static int[] hPos;
    public static boolean[] isTag;
    private String sentence;
    private String[] sent = new String[1000];
    private static final int sentSize = 1000;
    static boolean VERBOSE;
    private int size;
    private int beamSize = 10;
    private String[][] nBest;
    private double[] pBest;
    private static String[] correctTags;
    private static String[] tags;
    public int numRight;
    public int numWrong;
    public int mikeKnown;
    int numUnknown;
    int numWrongUnknown;
    int numUnassigned;
    int numUnknownUnassigned;
    int numWrongUnknownT3;
    int numWrongT3;
    private int startSizePairs;
    private int endSizePairs = this.startSizePairs = GlobalHolder.pairs.getSize();
    static final String naTag;
    static final String eosWord = "EOS";
    private double[][][] probabilities;
    private static final double sigma = 1.1;
    private boolean taginference = true;
    static final boolean DBG = false;
    static int leftContext;
    static int rightContext;
    static boolean appendTags;

    public TestSentence() {
    }

    public TestSentence(LambdaSolve prob, String s, PrintFile pf) {
        TestSentence.prob = prob;
        this.sentence = s;
        this.init();
        this.test("outfile26");
        if (pf != null) {
            pf.print(this.getTaggedNice());
            pf.print("\n");
        }
        this.revert(this.startSizePairs, this.endSizePairs);
    }

    public TestSentence(LambdaSolve prob, String s) {
        TestSentence.prob = prob;
        this.sentence = s;
        this.init();
        this.test("outfile26");
        this.revert(this.startSizePairs, this.endSizePairs);
    }

    public TestSentence(LambdaSolve prob, String[] s, String[] correctTags, PrintFile pf, Dictionary wrongWords) {
        TestSentence.prob = prob;
        this.sent = s;
        TestSentence.correctTags = correctTags;
        tags = new String[correctTags.length];
        for (int i = 0; i < correctTags.length; ++i) {
            TestSentence.tags[i] = naTag;
        }
        this.init1();
        if (!this.taginference) {
            this.test1(pf, wrongWords);
            this.revert(this.startSizePairs, this.endSizePairs);
        } else {
            this.testTagInference(pf, wrongWords);
        }
    }

    public TestSentence(LambdaSolve prob, String[] s, String[] tags, String[] correctTags, PrintFile pf, Dictionary wrongWords) {
        TestSentence.prob = prob;
        this.sent = s;
        TestSentence.correctTags = correctTags;
        TestSentence.tags = tags;
        this.init1();
        this.test1(pf, wrongWords);
        this.revert(this.startSizePairs, this.endSizePairs);
    }

    public Sentence tagSentence(LambdaSolve prob, Sentence s) {
        int j;
        TestSentence.prob = prob;
        this.sent = new String[s.length() + 1];
        for (j = 0; j < s.length(); ++j) {
            this.sent[j] = ((HasWord)s.get(j)).word();
        }
        this.size = this.sent.length;
        this.sent[this.size - 1] = eosWord;
        if (VERBOSE) {
            System.out.println("Sentence is " + s.toString());
        }
        this.init1();
        tags = new String[this.size];
        for (j = 0; j < this.size; ++j) {
            TestSentence.tags[j] = naTag;
        }
        this.test("out");
        this.revert(this.startSizePairs, this.endSizePairs);
        ArrayList<TaggedWord> taggedWords = new ArrayList<TaggedWord>();
        for (int j2 = 0; j2 < this.sent.length - 1; ++j2) {
            String tag = this.nBest[0][j2];
            TaggedWord w = new TaggedWord(this.sent[j2], tag);
            taggedWords.add(w);
        }
        return new Sentence((Collection<? extends HasWord>)taggedWords);
    }

    public void revert(int prevSize, int afterSize) {
        GlobalHolder.pairs.remove(prevSize, afterSize);
        this.endSizePairs = prevSize;
        CollectionTaggerOutputs.baseToken += afterSize - prevSize;
    }

    public void init() {
        StringTokenizer sT = new StringTokenizer(this.sentence);
        this.size = 0;
        while (sT.hasMoreTokens()) {
            String word = sT.nextToken();
            this.sent[this.size] = TestSentence.toSt(word);
            ++this.size;
        }
        this.sent[this.size] = eosWord;
        ++this.size;
        this.nBest = new String[this.beamSize][this.size];
        this.pBest = new double[this.beamSize];
        tags = new String[this.size];
        for (int i = 0; i < this.size; ++i) {
            TestSentence.tags[i] = naTag;
        }
    }

    public String getTaggedNice() {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this.size - 1; ++i) {
            sb.append(TestSentence.toNice(this.sent[i])).append("/").append(TestSentence.toNice(this.nBest[0][i]));
            sb.append(" ");
        }
        return sb.toString();
    }

    public static String toNice(String s) {
        if (s == null) {
            return " NA ";
        }
        return s;
    }

    public static void tagSentenceTagScorer(String[] sent) {
        TestSentence ts = new TestSentence();
        ts.initializeScorer(GlobalHolder.prob, sent);
        ExactBestSequenceFinder ti = new ExactBestSequenceFinder();
        int[] bestTags = ti.bestSequence(ts);
        for (int j = 0; j < sent.length; ++j) {
            System.out.print(sent[j] + "/" + GlobalHolder.tags.getTag(bestTags[j + ts.leftWindow()]) + "\t");
        }
        ts.cleanUpScorer();
    }

    public void init1() {
        this.size = this.sent.length;
        this.nBest = new String[this.beamSize][this.size];
        this.pBest = new double[this.beamSize];
        for (int i = 0; i < this.size - 1; ++i) {
            if (GlobalHolder.dict.sum(this.sent[i]) != 0) continue;
            ++this.numUnknown;
        }
    }

    public void writeProbs() {
        int numTags = GlobalHolder.tags.getSize();
        this.probabilities = new double[this.size][this.beamSize][numTags];
        double[] probs = new double[numTags];
        for (int hyp = 0; hyp < this.beamSize; ++hyp) {
            for (int i = 0; i < this.size; ++i) {
                WordTag wT = new WordTag(this.sent[i], this.nBest[hyp][i]);
                GlobalHolder.pairs.add(wT);
            }
            int start = this.endSizePairs;
            int end = this.endSizePairs + this.size - 1;
            this.endSizePairs += this.size;
            for (int current = 0; current < this.size; ++current) {
                int k;
                History h = new History(start, end, current + start);
                probs = this.getHistories(h);
                double s = 0.0;
                for (k = 0; k < numTags; ++k) {
                    s += probs[k];
                }
                for (k = 0; k < numTags; ++k) {
                    this.probabilities[current][hyp][k] = probs[k] / s;
                }
            }
        }
    }

    public void dumpActivations(String s) {
        this.sentence = s;
        this.init();
        for (int i = 0; i < this.size; ++i) {
            WordTag wT = new WordTag(this.sent[i], "NA");
            GlobalHolder.pairs.add(wT);
        }
        int start = this.endSizePairs;
        int end = this.endSizePairs + this.size - 1;
        this.endSizePairs += this.size;
        for (int current = 0; current < this.size; ++current) {
            History h = new History(start, end, current + start);
            this.printActivations(h);
        }
        this.revert(this.startSizePairs, this.endSizePairs);
    }

    public static String toSt(String s) {
        return s;
    }

    public String[] test(String outFile) {
        int current = 0;
        for (int j = 0; j < this.beamSize; ++j) {
            for (int i = 0; i < this.size; ++i) {
                this.nBest[j][i] = naTag;
                this.pBest[j] = 1.0;
            }
        }
        while (current < this.size) {
            if (VERBOSE) {
                System.out.println("current is " + current + " word " + this.sent[current]);
            }
            String[][] hCurrent = new String[this.beamSize][this.size];
            double[] pCurrent = new double[this.beamSize];
            for (int j = 0; j < pCurrent.length; ++j) {
                pCurrent[j] = Double.NEGATIVE_INFINITY;
            }
            this.insertTags(current, hCurrent, pCurrent);
            if (VERBOSE) {
                System.out.println("current is " + current + " word " + this.sent[current]);
            }
            for (int i = 0; i < this.beamSize; ++i) {
                if (hCurrent[i][0] != null) continue;
                for (int s = i; s < this.beamSize; ++s) {
                    for (int p = 0; p < current + 1; ++p) {
                        hCurrent[s][p] = hCurrent[i - 1][p];
                    }
                    pCurrent[s] = pCurrent[i - 1];
                }
                break;
            }
            this.nBest = hCurrent;
            this.pBest = pCurrent;
            ++current;
        }
        return this.nBest[0];
    }

    public void test1(PrintFile pf, Dictionary wrongWords) {
        int current = 0;
        for (int j = 0; j < this.beamSize; ++j) {
            for (int i = 0; i < this.size; ++i) {
                this.nBest[j][i] = naTag;
                this.pBest[j] = 0.0;
            }
        }
        while (current < this.size) {
            String[][] hCurrent = new String[this.beamSize][this.size];
            double[] pCurrent = new double[this.beamSize];
            for (int j = 0; j < pCurrent.length; ++j) {
                pCurrent[j] = Double.NEGATIVE_INFINITY;
            }
            this.insertTags(current, hCurrent, pCurrent);
            for (int i = 0; i < this.beamSize; ++i) {
                if (hCurrent[i][0] != null) continue;
                for (int s = i; s < this.beamSize; ++s) {
                    for (int p = 0; p < current + 1; ++p) {
                        hCurrent[s][p] = hCurrent[i - 1][p];
                    }
                    pCurrent[s] = pCurrent[i - 1];
                }
                break;
            }
            this.nBest = hCurrent;
            this.pBest = pCurrent;
            ++current;
        }
        CollectionTaggerOutputs.baseToken += this.size;
        int finalHyp = 0;
        try {
            for (int i = 0; i < correctTags.length - 1; ++i) {
                if (pf != null) {
                    pf.print(TestSentence.toNice(this.sent[i]) + '_' + this.nBest[finalHyp][i]);
                }
                if (correctTags[i].equals(this.nBest[finalHyp][i])) {
                    ++this.numRight;
                } else {
                    ++this.numWrong;
                    if (pf != null) {
                        pf.print("|" + correctTags[i]);
                    }
                    wrongWords.add(this.sent[i] + correctTags[i], this.nBest[finalHyp][i]);
                    if (GlobalHolder.dict.sum(this.sent[i]) == 0) {
                        ++this.numWrongUnknown;
                        if (pf != null) {
                            pf.print("*");
                        }
                    }
                }
                if (pf == null) continue;
                pf.print(" ");
            }
            if (pf != null) {
                pf.println();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void testTagInference(PrintFile pf, Dictionary wrongWords) {
        this.initializeScorer(GlobalHolder.prob, this.sent);
        ExactBestSequenceFinder ti = new ExactBestSequenceFinder();
        int[] bestTags = ti.bestSequence(this);
        String[] finalTags = new String[bestTags.length];
        for (int j = 0; j < this.sent.length; ++j) {
            finalTags[j] = GlobalHolder.tags.getTag(bestTags[j + this.leftWindow()]);
        }
        this.cleanUpScorer();
        try {
            for (int i = 0; i < correctTags.length - 1; ++i) {
                boolean nReliable = false;
                nReliable = true;
                if (correctTags[i].equals(finalTags[i])) {
                    if (pf != null) {
                        pf.print(TestSentence.toNice(this.sent[i]) + "_" + finalTags[i] + " ");
                    }
                    ++this.numRight;
                    continue;
                }
                ++this.numWrong;
                if (nReliable) {
                    ++this.numUnassigned;
                }
                if (pf != null) {
                    pf.print(TestSentence.toNice(this.sent[i]) + "_" + finalTags[i] + "|" + correctTags[i]);
                }
                wrongWords.add(this.sent[i] + correctTags[i], finalTags[i]);
                if (GlobalHolder.dict.sum(this.sent[i]) == 0) {
                    ++this.numWrongUnknown;
                    if (pf != null) {
                        pf.print("*");
                    }
                    if (nReliable) {
                        ++this.numUnknownUnassigned;
                    }
                }
                if (pf == null) continue;
                pf.print(" ");
            }
            if (pf != null) {
                pf.println();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean known(String w) {
        return GlobalHolder.dict.sum(w) > 0;
    }

    public boolean reliable(int current) {
        String tag = this.nBest[0][current];
        int y = GlobalHolder.tags.getIndex(tag);
        double max = 0.0;
        int maxInd = -1;
        double p = this.probabilities[current][0][y];
        if (this.known(this.sent[current])) {
            System.out.println(" known " + this.sent[current]);
            String[] tags = GlobalHolder.dict.getTags(this.sent[current]);
            String[] tags1 = this.append(tags, this.sent[current]);
            for (int k = 0; k < tags1.length; ++k) {
                int i = GlobalHolder.tags.getIndex(tags1[k]);
                if (i == y || !(this.probabilities[current][0][i] >= max) || !(this.probabilities[current][0][i] <= p)) continue;
                max = this.probabilities[current][0][i];
                maxInd = i;
            }
        } else {
            System.out.println(" unknown " + this.sent[current]);
            for (int i = 0; i < GlobalHolder.ySize; ++i) {
                if (i == y || !(this.probabilities[current][0][i] >= max) || !(this.probabilities[current][0][i] <= p)) continue;
                max = this.probabilities[current][0][i];
                maxInd = i;
            }
        }
        if (maxInd == -1) {
            return true;
        }
        String tag1 = GlobalHolder.tags.getTag(maxInd);
        System.out.println(tag + " " + GlobalHolder.tags.getTag(maxInd) + " " + p / max);
        if (GlobalHolder.dict.sum(this.sent[current]) == 0 && GlobalHolder.tags.isClosed(tag1)) {
            return true;
        }
        return p / max > 1.1;
    }

    void setHistory(int current, History h, int[] tags) {
        int left = this.leftWindow();
        int right = this.rightWindow();
        for (int j = current - left; j <= current + right; ++j) {
            if (j < left) continue;
            if (j >= this.size + left) break;
            h.setTag(j - left, GlobalHolder.tags.getTag(tags[j]));
        }
    }

    void initializeScorer(LambdaSolve prob, String[] sentence) {
        this.sent = sentence;
        TestSentence.prob = prob;
        this.size = this.sent.length;
        for (int i = 0; i < this.size; ++i) {
            WordTag wT = new WordTag(this.sent[i], "NN");
            GlobalHolder.pairs.add(wT);
        }
        this.endSizePairs += this.size;
    }

    void cleanUpScorer() {
        this.revert(this.startSizePairs, this.endSizePairs);
    }

    void getHistory(int current, History h, int hyp) {
        WordTag wT;
        int i;
        for (i = 0; i < current; ++i) {
            wT = new WordTag(this.sent[i], this.nBest[hyp][i]);
            GlobalHolder.pairs.add(wT);
        }
        for (i = current; i < this.size; ++i) {
            wT = new WordTag(this.sent[i], tags[i]);
            GlobalHolder.pairs.add(wT);
        }
        h.set(this.endSizePairs, this.endSizePairs + this.size - 1, current + this.endSizePairs);
        this.endSizePairs += this.size;
    }

    void insertTags(int current, String[][] hCurrent, double[] pCurrent) {
        History h = new History();
        double sum = 0.0;
        boolean hasHistory = true;
        double[] histories = null;
        int allCount = GlobalHolder.dict.sum(this.sent[current]);
        if (allCount == 0) {
            // empty if block
        }
        for (int hyp = 0; hyp < this.beamSize; ++hyp) {
            try {
                this.getHistory(current, h, hyp);
            }
            catch (Exception e) {
                System.out.println(" num hyp " + hyp);
                System.out.println(this.sent[current]);
            }
            int x = 0;
            hasHistory = false;
            if (!hasHistory) {
                histories = this.getHistories(h);
                sum = 0.0;
                for (int tR = 0; tR < histories.length; ++tR) {
                    sum += histories[tR];
                }
            }
            if (allCount == 0) {
                for (int y = 0; y < GlobalHolder.ySize; ++y) {
                    String tag = GlobalHolder.tags.getTag(y);
                    if (GlobalHolder.tags.isClosed(tag)) continue;
                    this.insertArray(current, hyp, x, y, hCurrent, pCurrent, tag, hasHistory, histories, sum);
                }
            } else {
                String[] tags1 = GlobalHolder.dict.getTags(this.sent[current]);
                String[] tags = this.append(tags1, this.sent[current]);
                for (int g = 0; g < tags.length; ++g) {
                    String tag = new String(tags[g]);
                    int y = GlobalHolder.tags.getIndex(tag);
                    this.insertArray(current, hyp, x, y, hCurrent, pCurrent, tag, hasHistory, histories, sum);
                }
            }
            CollectionTaggerOutputs.baseToken -= this.size;
        }
    }

    public String[] append(String[] tags, String word) {
        if (appendTags) {
            return this.appendOld(tags, word);
        }
        return tags;
    }

    public String[] appendOld(String[] tags, String word) {
        HashSet<String> hS = new HashSet<String>();
        int yVBD = GlobalHolder.tags.getIndex("VBD");
        int yVBN = GlobalHolder.tags.getIndex("VBN");
        int yVBP = GlobalHolder.tags.getIndex("VBP");
        int yVB = GlobalHolder.tags.getIndex("VB");
        int yVBG = GlobalHolder.tags.getIndex("VBG");
        for (int i = 0; i < tags.length; ++i) {
            int y = GlobalHolder.tags.getIndex(tags[i]);
            if (y <= -1) continue;
            hS.add(tags[i]);
            if (y == yVBD) {
                hS.add("VBN");
                continue;
            }
            if (y == yVBN) {
                hS.add("VBD");
                continue;
            }
            if (y == yVB) {
                hS.add("VBP");
                continue;
            }
            if (y == yVBP) {
                hS.add("VB");
                continue;
            }
            if (y != yVBG) continue;
        }
        Object[] arr = hS.toArray();
        String[] res = new String[arr.length];
        for (int i = 0; i < arr.length; ++i) {
            res[i] = (String)arr[i];
        }
        return res;
    }

    void insertArray(int current, int hyp, int x, int y, String[][] hCurrent, double[] pCurrent, String tag, boolean hasHistory, double[] histories, double sum) {
        int i;
        double p = 0.0;
        p = hasHistory ? prob.pcond(y, x) * this.pBest[hyp] : Math.log(histories[y]) - Math.log(sum) + this.pBest[hyp];
        if (p != p) {
            System.out.println(" p ia NaN " + this.pBest[hyp] + " " + p + " current is" + current + " tag " + tag);
            return;
        }
        if (p == 0.0) {
            System.out.println(" P is 0 inside InsertArray");
            return;
        }
        for (i = 0; i < this.beamSize; ++i) {
            if (p != pCurrent[i]) continue;
            boolean isDifferent = false;
            for (int j = 0; j < current; ++j) {
                if (hCurrent[i][j].equals(this.nBest[hyp][j])) continue;
                isDifferent = true;
            }
            if (!hCurrent[i][current].equals(tag)) {
                isDifferent = true;
            }
            if (isDifferent) continue;
            return;
        }
        if (p < pCurrent[this.beamSize - 1]) {
            return;
        }
        i = this.beamSize - 2;
        while (true) {
            int j;
            if (i == -1 || p < pCurrent[i]) {
                pCurrent[i + 1] = p;
                hCurrent[i + 1][current] = tag;
                for (j = 0; j < current; ++j) {
                    hCurrent[i + 1][j] = this.nBest[hyp][j];
                }
                return;
            }
            pCurrent[i + 1] = pCurrent[i];
            for (j = 0; j < current + 1; ++j) {
                hCurrent[i + 1][j] = hCurrent[i][j];
            }
            --i;
        }
    }

    public double[] getScores(History h) {
        int j;
        double score = 0.0;
        String cWord = ExtractorFrames.cWord.extract(h);
        String[] tags = this.stringTagsAt(h.current - h.start + this.leftWindow());
        String ctag = ExtractorFrames.cTag.extract(h);
        double[] scores = new double[tags.length];
        double[] histories = this.getHistories(h);
        double sum = 0.0;
        for (int i = 0; i < histories.length; ++i) {
            sum += histories[i];
        }
        double logsum = Math.log(sum);
        for (j = 0; j < tags.length; ++j) {
            String tag = tags[j];
            int tagindex = GlobalHolder.tags.getIndex(tag);
            scores[j] = Math.log(histories[tagindex]);
            sum += histories[tagindex];
        }
        j = 0;
        while (j < tags.length) {
            int n = j++;
            scores[n] = scores[n] - logsum;
        }
        if (VERBOSE) {
            h.print();
            System.out.println("for " + h.current + " " + ctag + " score " + score);
        }
        return scores;
    }

    public void printActivations(History h) {
        String word = ExtractorFrames.cWord.extract(h);
        System.out.print("features for word " + word + "\n");
        for (int j = 0; j < ExtractorFramesRare.eFrames.length; ++j) {
            Extractor e = ExtractorFramesRare.eFrames[j];
            String key = e.extract(h);
            System.out.print(j + "\t" + e.toString() + " value " + key + "\n");
        }
        System.out.println();
    }

    public double[] getHistories(History h) {
        int i;
        double[] arrLocal = new double[GlobalHolder.ySize];
        String word = ExtractorFrames.cWord.extract(h);
        int fAll = GlobalHolder.isRare(ExtractorFrames.cWord.extract(h)) ? GlobalHolder.extractors.getSize() + GlobalHolder.extractorsRare.getSize() : GlobalHolder.extractors.getSize();
        int fMain = GlobalHolder.extractors.getSize();
        FeatureKey s = new FeatureKey();
        for (int i2 = 0; i2 < GlobalHolder.ySize; ++i2) {
            int fNum;
            int kf;
            double lambda = 0.0;
            String tag = GlobalHolder.tags.getTag(i2);
            for (kf = 0; kf < fMain; ++kf) {
                s.set(kf, GlobalHolder.extractors.extract(kf, h), tag);
                fNum = GlobalHolder.getNum(s);
                if (fNum <= -1) continue;
                lambda += TestSentence.prob.lambda[fNum];
                if (kf <= 3) continue;
            }
            for (kf = fMain; kf < fAll; ++kf) {
                s.set(kf, GlobalHolder.extractorsRare.extract(kf - fMain, h), tag);
                fNum = GlobalHolder.getNum(s);
                if (fNum <= -1) continue;
                lambda += TestSentence.prob.lambda[fNum];
                if (kf <= 19) continue;
            }
            arrLocal[i2] = Math.exp(lambda);
        }
        boolean smooth = false;
        for (i = 0; i < arrLocal.length; ++i) {
            if (arrLocal[i] != 0.0) continue;
            smooth = true;
        }
        if (smooth) {
            i = 0;
            while (i < arrLocal.length) {
                int n = i++;
                arrLocal[n] = arrLocal[n] + 1.0E-4;
            }
        }
        return arrLocal;
    }

    public static int[] intersect(int[] arr1, int[] arr2) {
        int i;
        HashSet<Integer> s = new HashSet<Integer>();
        if (arr1 == null) {
            return null;
        }
        if (arr2 == null) {
            return null;
        }
        block0: for (i = 0; i < arr1.length; ++i) {
            for (int j = 0; j < arr2.length; ++j) {
                if (arr1[i] != arr2[j]) continue;
                s.add(new Integer(arr1[i]));
                continue block0;
            }
        }
        if (s.size() == 0) {
            return null;
        }
        int[] result = new int[s.size()];
        for (i = 0; i < s.size(); ++i) {
            result[i] = (Integer)s.toArray()[i];
        }
        return result;
    }

    public static int[] unite(int[] arr1, int[] arr2) {
        int i;
        HashSet<Integer> s = new HashSet<Integer>();
        if (arr1 == null) {
            return arr2;
        }
        if (arr2 == null) {
            return arr1;
        }
        for (i = 0; i < arr1.length; ++i) {
            s.add(new Integer(arr1[i]));
        }
        for (i = 0; i < arr2.length; ++i) {
            s.add(new Integer(arr2[i]));
        }
        if (s.size() == 0) {
            return null;
        }
        int[] result = new int[s.size()];
        for (i = 0; i < s.size(); ++i) {
            result[i] = (Integer)s.toArray()[i];
        }
        return result;
    }

    public double[][][] getProbs() {
        return this.probabilities;
    }

    public void printProbs() {
        for (int tag = 0; tag < GlobalHolder.tags.getSize(); ++tag) {
            System.out.print(GlobalHolder.tags.getTag(tag) + "\t");
        }
        System.out.println();
        for (int current = 0; current < this.size; ++current) {
            for (int hyp = 0; hyp < this.beamSize; ++hyp) {
                System.out.print(this.sent[current] + "\t");
                for (int tag = 0; tag < GlobalHolder.tags.getSize(); ++tag) {
                    System.out.print((float)((int)(1000.0 * this.probabilities[current][hyp][tag])) / 1000.0f + "\t");
                }
                System.out.println();
            }
        }
    }

    public void addUnknown(Dictionary uDict) {
        for (int current = 0; current < this.size; ++current) {
            if (this.known(this.sent[current])) continue;
            for (int i = 0; i < 3; ++i) {
                uDict.add(this.sent[current], this.nBest[i][current]);
            }
        }
    }

    public void printUnknown(int numSent, PrintFile pfu) {
        this.writeProbs();
        for (int current = 0; current < this.size; ++current) {
            if (this.known(this.sent[current])) continue;
            String s1 = this.sent[current] + ":" + numSent;
            double[] probs = new double[3];
            String[] tags = new String[3];
            this.getTop3(current, probs, tags);
            for (int i = 0; i < 3; ++i) {
                s1 = s1 + "\t" + tags[i] + " " + probs[i];
            }
            pfu.println(s1);
            boolean wrong = true;
            String correctTag = TestSentence.toNice(correctTags[current]);
            for (int i = 0; i < 3; ++i) {
                if (!correctTag.equals(tags[i])) continue;
                wrong = false;
                break;
            }
            if (!wrong) continue;
            ++this.numWrongUnknownT3;
        }
    }

    public void printTop(PrintFile pfu) {
        this.writeProbs();
        for (int current = 0; current < this.size; ++current) {
            String s1 = this.sent[current];
            double[] probs = new double[3];
            String[] tags = new String[3];
            this.getTop3(current, probs, tags);
            for (int i = 0; i < 3; ++i) {
                s1 = s1 + "\t" + tags[i] + " " + probs[i];
            }
            pfu.println(s1);
            boolean wrong = true;
            String correctTag = TestSentence.toNice(correctTags[current]);
            for (int i = 0; i < 3; ++i) {
                if (!correctTag.equals(tags[i])) continue;
                wrong = false;
                break;
            }
            if (!wrong) continue;
            ++this.numWrongT3;
        }
    }

    void getTop3(int current, double[] probs, String[] tags) {
        int j;
        int[] topIds = new int[3];
        double maxP = 0.0;
        double[] probTags = this.probabilities[current][0];
        for (int j2 = 0; j2 < 3; ++j2) {
            maxP = 0.0;
            for (int i = 0; i < probTags.length; ++i) {
                if (!(probTags[i] > maxP)) continue;
                maxP = probTags[i];
                topIds[j2] = i;
            }
            probs[j2] = probTags[topIds[j2]];
            probTags[topIds[j2]] = 0.0;
        }
        double total = 0.0;
        for (j = 0; j < 3; ++j) {
            total += probs[j];
        }
        j = 0;
        while (j < 3) {
            int n = j++;
            probs[n] = probs[n] / total;
        }
        for (j = 0; j < 3; ++j) {
            tags[j] = TestSentence.toNice(GlobalHolder.tags.getTag(topIds[j]));
        }
    }

    public int length() {
        return this.size;
    }

    public int leftWindow() {
        return leftContext;
    }

    public int rightWindow() {
        return rightContext;
    }

    public int[] getPossibleValues(int pos) {
        int[] arr = new int[1];
        if (pos < this.leftWindow() || pos >= this.size + this.leftWindow()) {
            arr[0] = GlobalHolder.tags.getIndex("NA");
            return arr;
        }
        int count = GlobalHolder.dict.sum(this.sent[pos - this.leftWindow()]);
        String[] arr1 = count == 0 ? GlobalHolder.tags.getOpenTags() : GlobalHolder.dict.getTags(this.sent[pos - this.leftWindow()]);
        arr1 = this.append(arr1, this.sent[pos - this.leftWindow()]);
        if (VERBOSE) {
            System.out.println("for word " + this.sent[pos - this.leftWindow()] + " count " + count + " tags are ");
            for (int j = 0; j < arr1.length; ++j) {
                System.out.print(arr1[j] + ", ");
            }
            System.out.println();
        }
        arr = new int[arr1.length];
        for (int i = 0; i < arr.length; ++i) {
            arr[i] = GlobalHolder.tags.getIndex(arr1[i]);
        }
        return arr;
    }

    public String[] stringTagsAt(int pos) {
        String[] arr1 = new String[1];
        if (pos < this.leftWindow() || pos >= this.size + this.leftWindow()) {
            arr1[0] = naTag;
            return arr1;
        }
        int count = GlobalHolder.dict.sum(this.sent[pos - this.leftWindow()]);
        arr1 = count == 0 ? GlobalHolder.tags.getOpenTags() : GlobalHolder.dict.getTags(this.sent[pos - this.leftWindow()]);
        arr1 = this.append(arr1, this.sent[pos - this.leftWindow()]);
        if (VERBOSE) {
            System.out.println("for word " + this.sent[pos - this.leftWindow()] + " count " + count + " tags are ");
            for (int j = 0; j < arr1.length; ++j) {
                System.out.print(arr1[j] + "\t");
            }
            System.out.println();
        }
        return arr1;
    }

    public double scoreOf(int[] tags, int pos) {
        double[] scores = this.scoresOf(tags, pos);
        double score = Double.NEGATIVE_INFINITY;
        int[] pv = this.getPossibleValues(pos);
        for (int i = 0; i < scores.length; ++i) {
            if (pv[i] != tags[pos]) continue;
            score = scores[i];
        }
        return score;
    }

    public double scoreOf(int[] sequence) {
        throw new UnsupportedOperationException();
    }

    public double[] scoresOf(int[] tags, int pos) {
        History h = new History();
        h.set(this.endSizePairs - this.size, this.endSizePairs - 1, this.endSizePairs - this.size + pos - this.leftWindow());
        this.setHistory(pos, h, tags);
        return this.getScores(h);
    }

    public static void main(String[] args) {
        GlobalHolder.init();
        TestSentence tS = new TestSentence();
        System.err.println("Type a line to debug, Ctrl-C to exit.");
        BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
        String temp = null;
        try {
            while ((temp = br.readLine()) != null) {
                tS.dumpActivations(temp);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static {
        VERBOSE = false;
        naTag = TestSentence.toSt("NA");
        leftContext = 2;
        rightContext = 2;
        appendTags = true;
    }
}

