/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.parser.lexparser;

import edu.stanford.nlp.parser.lexparser.Extractor;
import edu.stanford.nlp.parser.lexparser.Test;
import edu.stanford.nlp.process.Function;
import edu.stanford.nlp.trees.Tree;
import java.util.Collection;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class AbstractTreeExtractor
implements Extractor {
    double weight = 1.0;

    AbstractTreeExtractor() {
    }

    protected void tallyLeaf(Tree lt) {
    }

    protected void tallyPreTerminal(Tree lt) {
    }

    protected void tallyInternalNode(Tree lt) {
    }

    protected void tallyRoot(Tree lt) {
    }

    protected Object formResult() {
        return null;
    }

    protected void tallyLocalTree(Tree lt) {
        if (lt.isLeaf()) {
            this.tallyLeaf(lt);
        } else if (lt.isPreTerminal()) {
            this.tallyPreTerminal(lt);
        } else {
            this.tallyInternalNode(lt);
        }
    }

    protected void tallyTree(Tree t) {
        this.tallyRoot(t);
        for (Tree localTree : t.subTreeList()) {
            this.tallyLocalTree(localTree);
        }
    }

    protected void tallyTrees(Collection<Tree> trees) {
        for (Tree tree : trees) {
            this.tallyTree(tree);
        }
    }

    protected void tallyTreeIterator(Iterator<Tree> treeIterator, Function<Tree, Tree> f) {
        while (treeIterator.hasNext()) {
            Tree tree = treeIterator.next();
            try {
                tree = f.apply(tree);
            }
            catch (Exception e) {
                if (!Test.verbose) continue;
                e.printStackTrace();
                continue;
            }
            this.tallyTree(tree);
        }
    }

    public Object extract() {
        return this.formResult();
    }

    @Override
    public Object extract(Collection<Tree> treeList) {
        this.tallyTrees(treeList);
        return this.formResult();
    }

    public Object extract(Collection<Tree> trees1, Collection<Tree> trees2, double weight) {
        this.tallyTrees(trees1);
        this.weight = weight;
        this.tallyTrees(trees2);
        return this.formResult();
    }

    @Override
    public Object extract(Iterator<Tree> treeIterator, Function<Tree, Tree> f) {
        this.tallyTreeIterator(treeIterator, f);
        return this.formResult();
    }
}

