/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.databinding.beans;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import org.eclipse.core.databinding.beans.IBeanObservable;
import org.eclipse.core.databinding.observable.Diffs;
import org.eclipse.core.databinding.observable.map.ComputedObservableMap;
import org.eclipse.core.databinding.observable.map.MapDiff;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.core.databinding.util.Policy;
import org.eclipse.core.internal.databinding.beans.ListenerSupport;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class JavaBeanObservableMap
extends ComputedObservableMap
implements IBeanObservable {
    private PropertyDescriptor propertyDescriptor;
    private PropertyChangeListener elementListener = new PropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent event) {
            if (!JavaBeanObservableMap.this.updating) {
                JavaBeanObservableMap.this.getRealm().exec(new Runnable(this, event){
                    final /* synthetic */ 1 this$1;
                    private final /* synthetic */ PropertyChangeEvent val$event;
                    {
                        this.this$1 = var1_1;
                        this.val$event = propertyChangeEvent;
                    }

                    public void run() {
                        JavaBeanObservableMap.access$1(1.access$0(this.this$1), Diffs.createMapDiffSingleChange((Object)this.val$event.getSource(), (Object)this.val$event.getOldValue(), (Object)this.val$event.getNewValue()));
                    }
                });
            }
        }

        static /* synthetic */ JavaBeanObservableMap access$0(1 var0) {
            return var0.JavaBeanObservableMap.this;
        }
    };
    private ListenerSupport listenerSupport;
    private boolean updating = false;
    private boolean attachListeners;

    public JavaBeanObservableMap(IObservableSet domain, PropertyDescriptor propertyDescriptor) {
        this(domain, propertyDescriptor, true);
    }

    public JavaBeanObservableMap(IObservableSet domain, PropertyDescriptor propertyDescriptor, boolean attachListeners) {
        super(domain);
        this.propertyDescriptor = propertyDescriptor;
        this.attachListeners = attachListeners;
        if (attachListeners) {
            this.listenerSupport = new ListenerSupport(this.elementListener, propertyDescriptor.getName());
        }
        this.init();
    }

    protected void hookListener(Object domainElement) {
        if (this.attachListeners && domainElement != null) {
            this.listenerSupport.hookListener(domainElement);
        }
    }

    protected void unhookListener(Object domainElement) {
        if (this.attachListeners && domainElement != null) {
            this.listenerSupport.unhookListener(domainElement);
        }
    }

    protected Object doGet(Object key) {
        if (key == null) {
            return null;
        }
        try {
            Method readMethod = this.propertyDescriptor.getReadMethod();
            if (!readMethod.isAccessible()) {
                readMethod.setAccessible(true);
            }
            return readMethod.invoke(key, new Object[0]);
        }
        catch (Exception e) {
            Policy.getLog().log((IStatus)new Status(4, "org.eclipse.core.databinding", 4, "cannot get value", (Throwable)e));
            throw new RuntimeException(e);
        }
    }

    protected Object doPut(Object key, Object value) {
        try {
            Object oldValue = this.get(key);
            this.propertyDescriptor.getWriteMethod().invoke(key, value);
            this.keySet().add(key);
            return oldValue;
        }
        catch (Exception e) {
            Policy.getLog().log((IStatus)new Status(4, "org.eclipse.core.databinding", 4, "cannot set value", (Throwable)e));
            throw new RuntimeException(e);
        }
    }

    public Object getObserved() {
        return this.keySet();
    }

    public PropertyDescriptor getPropertyDescriptor() {
        return this.propertyDescriptor;
    }

    static /* synthetic */ void access$1(JavaBeanObservableMap javaBeanObservableMap, MapDiff mapDiff) {
        javaBeanObservableMap.fireMapChange(mapDiff);
    }
}

