/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.parsing.ui.hovers;

import edu.mit.parsing.core.rep.pos.IPosTag;
import edu.mit.parsing.core.rep.pos.POSRep;
import edu.mit.parsing.core.rep.stem.IStem;
import edu.mit.parsing.core.rep.stem.StemRep;
import edu.mit.parsing.core.rep.tag.ITagData;
import edu.mit.parsing.core.rep.tag.TagRep;
import edu.mit.parsing.core.rep.tag.tagset.ITag;
import edu.mit.parsing.core.rep.tag.tagset.ITagset;
import edu.mit.parsing.core.rep.token.TokenRep;
import edu.mit.story.core.desc.DescUtils;
import edu.mit.story.core.desc.IDesc;
import edu.mit.story.core.desc.IDescSet;
import edu.mit.story.core.model.IStoryModel;
import edu.mit.story.core.position.IHasPosition;
import edu.mit.story.core.position.SimplePosition;
import edu.mit.story.ui.editor.StoryTextHover;
import java.util.ArrayList;
import java.util.Iterator;

public class TagHover
extends StoryTextHover {
    public TagHover() {
        super(TokenRep.getInstance());
    }

    public String getHoverInfo(IStoryModel model, int hoverOffset, IHasPosition selection) {
        try {
            return this.getHoverInfoUncaught(model, hoverOffset, selection);
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    protected String getHoverInfoUncaught(IStoryModel model, int hoverOffset, IHasPosition selection) {
        if (!model.supports(TagRep.getInstance())) {
            return null;
        }
        ITagset tagset = TagRep.getTagset((IStoryModel)model);
        SimplePosition hp = new SimplePosition(hoverOffset, 0);
        IDescSet tags = DescUtils.getDescriptions((IHasPosition)hp, (IDescSet)model.getData().getDescriptions(TagRep.getInstance()));
        StringBuilder sb = new StringBuilder();
        IDesc word = null;
        Iterator i = tags.iterator();
        while (i.hasNext()) {
            if (word != null) {
                sb.append("\n\n");
            }
            word = (IDesc)i.next();
            sb.append(this.getTextLine(word, tagset));
        }
        return sb.toString();
    }

    protected String getTextLine(IDesc tagD, ITagset tagset) {
        ITagData tag = (ITagData)tagD.getData();
        StringBuilder sb = new StringBuilder();
        sb.append("TAG :");
        if (tagset != null) {
            ITag t = tagset.getTag(tag.getTagID());
            sb.append(' ');
            if (t == null) {
                sb.append("(Unlisted tag)");
            } else {
                sb.append(t.getName());
            }
        }
        sb.append(" [");
        sb.append(tag.getTagID());
        sb.append("] : ");
        sb.append(tag.getDisplayText());
        return sb.toString();
    }

    protected String getPOSLine(IDesc word, IStoryModel model) {
        IDescSet posDescs = model.getData().getDescriptions(POSRep.getInstance());
        IDescSet matches = posDescs.matchSet((IHasPosition)word);
        ArrayList<IDesc> actual = new ArrayList<IDesc>(matches.size());
        for (IDesc pos : matches) {
            IPosTag tag = (IPosTag)pos.getData();
            if (tag.getWord() != word) continue;
            actual.add(pos);
        }
        StringBuilder sb = new StringBuilder();
        sb.append("POS     : ");
        if (actual.isEmpty()) {
            sb.append("none");
        } else {
            Iterator i = actual.iterator();
            while (i.hasNext()) {
                this.appendPOS((IPosTag)((IDesc)i.next()).getData(), sb);
                if (!i.hasNext()) continue;
                sb.append(", or ");
            }
            if (actual.size() > 1) {
                sb.append(" (ambiguous)");
            }
        }
        return sb.toString();
    }

    protected void appendPOS(IPosTag tag, StringBuilder sb) {
        if (tag.isAuxiliary()) {
            sb.append("Auxiliary ");
        }
        sb.append(tag.getTag().getName());
        sb.append(" (");
        sb.append(tag.getTag().getTagString());
        if (tag.isAuxiliary()) {
            sb.append("-AUX");
        }
        sb.append(')');
    }

    protected String getStemLine(IDesc word, IStoryModel model) {
        IStem stem;
        IDescSet stemDescs = model.getData().getDescriptions(StemRep.getInstance());
        IDescSet matches = stemDescs.matchSet((IHasPosition)word);
        ArrayList<IDesc> actual = new ArrayList<IDesc>(matches.size());
        for (IDesc stemDesc : matches) {
            stem = (IStem)stemDesc.getData();
            if (stem.getWord() != word) continue;
            actual.add(stemDesc);
        }
        StringBuilder sb = new StringBuilder();
        sb.append("STEM   : ");
        if (actual.isEmpty()) {
            sb.append("(same as surface form)");
        } else {
            Iterator i = actual.iterator();
            while (i.hasNext()) {
                stem = (IStem)((IDesc)i.next()).getData();
                sb.append(stem.getStem());
                if (!i.hasNext()) continue;
                sb.append(", or ");
            }
            if (actual.size() > 1) {
                sb.append(" (ambiguous)");
            }
        }
        return sb.toString();
    }
}

