/* Filename: RemoveRefexpModelChange.java
 * Creator: markaf
 * Format: Java 2 v1.6.0
 * Date created: Oct 18, 2010
 */
package edu.mit.discourse.core.rep.coref.changes;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

import edu.mit.discourse.core.rep.coref.CorefRep;
import edu.mit.discourse.core.rep.coref.ICoref;
import edu.mit.discourse.core.rep.refexp.RefExpRep;
import edu.mit.story.core.desc.IDesc;
import edu.mit.story.core.model.IMutableStoryModel;
import edu.mit.story.core.model.change.AbstractModelChange;
import edu.mit.story.core.model.change.CompositeModelChange;
import edu.mit.story.core.model.change.IModelChange;
import edu.mit.story.core.model.change.StoryChangeEvent;

/** 
 * TODO: Write comment
 *
 * @author markaf
 * @version $Rev$, $LastChangedDate$
 * @since edu.mit.discourse.core 1.0.0
 */
public class MoveRefexpModelChange extends AbstractModelChange {

	private final long toCorefID;
	private final long refexpID;

	/**
	 * TODO: Write comment
	 *
	 * @param name
	 * @since edu.mit.discourse.core 1.0.0
	 */
	public MoveRefexpModelChange(IDesc toCoref, IDesc refexp) {
		super("Remove Referring Expression");
		if(refexp == null)
			throw new NullPointerException();
		if(toCoref != null && !CorefRep.getInstance().isType(toCoref))
			throw new IllegalArgumentException();
		if(!RefExpRep.getInstance().isType(refexp))
			throw new IllegalArgumentException();
		this.toCorefID = (toCoref == null) ? -1 : toCoref.getID();
		this.refexpID = refexp.getID();
	}

	/* 
	 * (non-Javadoc) @see edu.mit.story.core.model.change.AbstractModelChange#doApply(java.lang.Object, edu.mit.story.core.model.IMutableStoryModel)
	 */
	@Override
	protected StoryChangeEvent doApply(Object source, IMutableStoryModel model) {
		
		IDesc corefDesc = null;
		if(toCorefID != -1)
			corefDesc = model.getData().getDescriptions(CorefRep.getInstance()).getDescription(toCorefID);
		
		IDesc refexpDesc = model.getData().getDescriptions(RefExpRep.getInstance()).getDescription(refexpID);
		if(refexpDesc == null)
			return null;
		
		// find all locations of this refexp
		Set<IDesc> remove = new HashSet<IDesc>();
		ICoref coref;
		for(IDesc cr : model.getData().getDescriptions(CorefRep.getInstance())){
			coref = (ICoref)cr.getData();
			if(coref.getReferentialExpressions().contains(refexpDesc))
				remove.add(cr);
		}
		
		// don't do anything if nothing will change
		if(remove.size() == 1 && remove.contains(corefDesc))
			return null;
		
		// create changes
		List<IModelChange> changes = new ArrayList<IModelChange>(remove.size()+1);
		if(corefDesc != null)
			changes.add(new AddRefexpModelChange(corefDesc, refexpDesc));
		for(IDesc cr : remove)
			changes.add(new RemoveRefexpModelChange(cr, refexpDesc));
		
		IModelChange change;
		switch(changes.size()){
		case 0:
			return null;
		case 1:
			change = changes.get(0);
			break;
		default:
			change = new CompositeModelChange(changes);
		}
		return change.apply(source, model);
	}

}
