/* Filename: RemoveRefexpModelChange.java
 * Creator: markaf
 * Format: Java 2 v1.6.0
 * Date created: Oct 18, 2010
 */
package edu.mit.discourse.core.rep.coref.changes;

import java.util.HashSet;
import java.util.Set;

import edu.mit.discourse.core.rep.coref.Coref;
import edu.mit.discourse.core.rep.coref.CorefRep;
import edu.mit.discourse.core.rep.coref.ICoref;
import edu.mit.discourse.core.rep.refexp.RefExpRep;
import edu.mit.story.core.desc.IDesc;
import edu.mit.story.core.meta.timing.ITiming;
import edu.mit.story.core.meta.timing.Timing;
import edu.mit.story.core.model.IMutableStoryModel;
import edu.mit.story.core.model.change.AbstractModelChange;
import edu.mit.story.core.model.change.ChangeUtils;
import edu.mit.story.core.model.change.IModelChange;
import edu.mit.story.core.model.change.StoryChangeEvent;

/** 
 * TODO: Write comment
 *
 * @author markaf
 * @version $Rev$, $LastChangedDate$
 * @since edu.mit.discourse.core 1.0.0
 */
public class AddRefexpModelChange extends AbstractModelChange {

	private final long corefID;
	private final long refexpID;

	/**
	 * TODO: Write comment
	 *
	 * @param name
	 * @since edu.mit.discourse.core 1.0.0
	 */
	public AddRefexpModelChange(IDesc coref, IDesc refexp) {
		super("Add Referring Expression");
		if(coref == null)
			throw new NullPointerException();
		if(refexp == null)
			throw new NullPointerException();
		if(!CorefRep.getInstance().isType(coref))
			throw new IllegalArgumentException();
		if(!RefExpRep.getInstance().isType(refexp))
			throw new IllegalArgumentException();
		this.corefID = coref.getID();
		this.refexpID = refexp.getID();
	}

	/* 
	 * (non-Javadoc) @see edu.mit.story.core.model.change.AbstractModelChange#doApply(java.lang.Object, edu.mit.story.core.model.IMutableStoryModel)
	 */
	@Override
	protected StoryChangeEvent doApply(Object source, IMutableStoryModel model) {
		
		IDesc oldDesc = model.getData().getDescriptions(CorefRep.getInstance()).getDescription(corefID);
		if(oldDesc == null)
			return null;
		
		ICoref oldCoref = (ICoref)oldDesc.getData();
		IDesc refexpDesc = model.getData().getDescriptions(RefExpRep.getInstance()).getDescription(refexpID);
		if(refexpDesc == null)
			return null;
		
		Set<IDesc> refexps = new HashSet<IDesc>(oldCoref.getReferentialExpressions());
		refexps.add(refexpDesc);
		
		ICoref newCoref = new Coref(oldCoref.getName(), refexps);
		ITiming editTime = new Timing(ITiming.SOURCE_USER, true);
		IModelChange change = ChangeUtils.createModelEdit(this, model, CorefRep.getInstance(), newCoref.calculatePosition(), newCoref, editTime, oldDesc);
		return change.apply(source, model);
	}

}
