/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.views.markers;

import org.eclipse.core.resources.IMarker;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.internal.views.markers.MarkerContentGenerator;
import org.eclipse.ui.internal.views.markers.SeverityAndDescriptionFieldFilter;
import org.eclipse.ui.views.markers.MarkerItem;
import org.eclipse.ui.views.markers.internal.ProblemFilter;

public class ProblemsSeverityAndDescriptionFieldFilter
extends SeverityAndDescriptionFieldFilter {
    public boolean select(MarkerItem item) {
        IMarker marker = item.getMarker();
        if (marker == null) {
            return false;
        }
        int markerSeverity = item.getAttributeValue("severity", -1);
        if (markerSeverity < 0) {
            return false;
        }
        if (this.checkSeverity(markerSeverity)) {
            return super.select(item);
        }
        return false;
    }

    void loadLegacySettings(IMemento memento, MarkerContentGenerator generator) {
        super.loadLegacySettings(memento, generator);
        Integer severitySetting = memento.getInteger("severity");
        if (severitySetting != null) {
            this.selectedSeverities = severitySetting;
        }
    }

    public void initialize(ProblemFilter problemFilter) {
        super.initialize(problemFilter);
        if (problemFilter.getSeverity() > 0) {
            this.selectedSeverities = problemFilter.getSeverity();
        }
    }
}

