/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.ui.dialogs;

import org.eclipse.core.resources.IResource;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.tigris.subversion.subclipse.core.ISVNLocalResource;
import org.tigris.subversion.subclipse.core.SVNException;
import org.tigris.subversion.subclipse.core.history.Alias;
import org.tigris.subversion.subclipse.core.resources.SVNWorkspaceRoot;
import org.tigris.subversion.subclipse.ui.Policy;
import org.tigris.subversion.subclipse.ui.dialogs.SvnDialog;

public class BranchTagPropertyUpdateDialog
extends SvnDialog {
    private IResource resource;
    private Alias newAlias;
    private ISVNLocalResource svnResource;
    private Text revisionText;
    private Text nameText;
    private Text pathText;
    private Button branchButton;
    private Button okButton;

    public BranchTagPropertyUpdateDialog(Shell parentShell, IResource resource, Alias newAlias, String id) {
        super(parentShell, id);
        this.resource = resource;
        this.newAlias = newAlias;
    }

    protected Control createDialogArea(Composite parent) {
        this.getShell().setText(Policy.bind("BranchTagPropertyUpdateDialog.title"));
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(1808));
        Composite urlGroup = new Composite(composite, 0);
        GridLayout urlLayout = new GridLayout();
        urlLayout.numColumns = 2;
        urlGroup.setLayout((Layout)urlLayout);
        urlGroup.setLayoutData((Object)new GridData(768));
        Label urlLabel = new Label(urlGroup, 0);
        urlLabel.setText(Policy.bind("ConfigureTagsDialog.url"));
        Text urlText = new Text(urlGroup, 2048);
        GridData data = new GridData(768);
        urlText.setLayoutData((Object)data);
        urlText.setEditable(false);
        this.svnResource = SVNWorkspaceRoot.getSVNResourceFor((IResource)this.resource);
        try {
            urlText.setText(this.svnResource.getStatus().getUrlString());
        }
        catch (SVNException sVNException) {}
        Label textLabel = this.createWrappingLabel(composite, Policy.bind("BranchTagPropertyUpdateDialog.text"), 0, 1);
        textLabel.setText(Policy.bind("BranchTagPropertyUpdateDialog.text"));
        Group tagGroup = new Group(composite, 0);
        GridLayout tagLayout = new GridLayout();
        tagLayout.numColumns = 2;
        tagGroup.setLayout((Layout)tagLayout);
        tagGroup.setLayoutData((Object)new GridData(1808));
        Label revisionLabel = new Label((Composite)tagGroup, 0);
        revisionLabel.setText(Policy.bind("ConfigureTagsDialog.revision"));
        this.revisionText = new Text((Composite)tagGroup, 2048);
        data = new GridData();
        data.widthHint = 50;
        this.revisionText.setLayoutData((Object)data);
        this.revisionText.setText(Integer.toString(this.newAlias.getRevision()));
        Label nameLabel = new Label((Composite)tagGroup, 0);
        nameLabel.setText(Policy.bind("ConfigureTagsDialog.name"));
        this.nameText = new Text((Composite)tagGroup, 2048);
        data = new GridData(768);
        this.nameText.setLayoutData((Object)data);
        this.nameText.setText(this.newAlias.getName());
        Label pathLabel = new Label((Composite)tagGroup, 0);
        pathLabel.setText(Policy.bind("ConfigureTagsDialog.path"));
        this.pathText = new Text((Composite)tagGroup, 2048);
        data = new GridData(768);
        this.pathText.setLayoutData((Object)data);
        this.pathText.setText(this.newAlias.getRelativePath());
        this.branchButton = new Button((Composite)tagGroup, 32);
        this.branchButton.setText(Policy.bind("ConfigureTagsDialog.branch"));
        data = new GridData();
        data.horizontalSpan = 2;
        this.branchButton.setLayoutData((Object)data);
        this.branchButton.setSelection(this.newAlias.isBranch());
        ModifyListener modifyListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                BranchTagPropertyUpdateDialog.this.okButton.setEnabled(BranchTagPropertyUpdateDialog.this.revisionText.getText().trim().length() > 0 && BranchTagPropertyUpdateDialog.this.nameText.getText().trim().length() > 0 && BranchTagPropertyUpdateDialog.this.pathText.getText().trim().length() > 0);
            }
        };
        this.revisionText.addModifyListener(modifyListener);
        this.nameText.addModifyListener(modifyListener);
        this.pathText.addModifyListener(modifyListener);
        FocusListener focusListener = new FocusListener(){

            public void focusGained(FocusEvent e) {
                ((Text)e.getSource()).selectAll();
            }

            public void focusLost(FocusEvent e) {
                ((Text)e.getSource()).setText(((Text)e.getSource()).getText());
            }
        };
        this.revisionText.addFocusListener(focusListener);
        this.nameText.addFocusListener(focusListener);
        this.pathText.addFocusListener(focusListener);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "org.tigris.subversion.subclipse.ui.branch_tag_property_update_dialog_context");
        return composite;
    }

    protected void okPressed() {
        this.newAlias.setBranch(this.branchButton.getSelection());
        this.newAlias.setName(this.nameText.getText().trim());
        this.newAlias.setRelativePath(this.pathText.getText().trim());
        this.newAlias.setRevision(Integer.parseInt(this.revisionText.getText().trim()));
        super.okPressed();
    }

    protected Button createButton(Composite parent, int id, String label, boolean defaultButton) {
        Button button = super.createButton(parent, id, label, defaultButton);
        if (id == 0) {
            this.okButton = button;
        }
        return button;
    }

    public Alias getNewAlias() {
        return this.newAlias;
    }
}

