/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.ui;

import org.eclipse.swt.widgets.Combo;

public class DepthComboHelper {
    private static String[] comboValues = new String[]{"Working copy", "Fully recursive", "Immediate children, including folders", "Only file children", "Only this item", "Exclude"};
    private static int[] depthValues;

    static {
        int[] nArray = new int[6];
        nArray[0] = -2;
        nArray[1] = 3;
        nArray[2] = 2;
        nArray[3] = 1;
        nArray[5] = -1;
        depthValues = nArray;
    }

    public static void addDepths(Combo combo, boolean includeUnknown, String defaultSelection) {
        if (includeUnknown) {
            combo.add("Working copy");
        }
        combo.add("Fully recursive");
        combo.add("Immediate children, including folders");
        combo.add("Only file children");
        combo.add("Only this item");
        if (defaultSelection != null) {
            combo.select(combo.indexOf(defaultSelection));
        }
    }

    public static void addDepths(Combo combo, boolean includeUnknown, boolean includeExclude, String defaultSelection) {
        if (includeUnknown) {
            combo.add("Working copy");
        }
        combo.add("Fully recursive");
        combo.add("Immediate children, including folders");
        combo.add("Only file children");
        combo.add("Only this item");
        if (includeExclude) {
            combo.add("Exclude");
        }
        if (defaultSelection != null) {
            combo.select(combo.indexOf(defaultSelection));
        }
    }

    public static int getDepth(Combo combo) {
        int i = 0;
        while (i < comboValues.length) {
            if (combo.getText().equals(comboValues[i])) {
                return depthValues[i];
            }
            ++i;
        }
        return -2;
    }
}

