/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.wordnet.core.util.old;

import edu.mit.jwi.IDictionary;
import edu.mit.jwi.item.IIndexWord;
import edu.mit.jwi.item.IWord;
import edu.mit.jwi.item.IWordID;
import edu.mit.jwi.item.POS;
import edu.mit.wordnet.core.rep.sense.ISenseAssignment;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FrequencyComparator
implements Comparator<ISenseAssignment> {
    private final IDictionary dict;
    private final List<IWordID> wordIDs;

    public FrequencyComparator(IDictionary dict, String lemma, POS pos) {
        if (dict == null) {
            throw new NullPointerException();
        }
        this.dict = dict;
        this.wordIDs = lemma == null || pos == null ? Collections.emptyList() : this.getWordIDs(lemma, pos);
    }

    @Override
    public int compare(ISenseAssignment s1, ISenseAssignment s2) {
        if (s1.getSense() == null) {
            if (s2.getSense() == null) {
                return 0;
            }
            return 1;
        }
        if (s2.getSense() == null) {
            return -1;
        }
        int idx1 = this.wordIDs.indexOf(s1.getSense().getID());
        int idx2 = this.wordIDs.indexOf(s2.getSense().getID());
        if (idx1 > -1 && idx2 > -1) {
            return idx1 - idx2;
        }
        if (idx1 > -1 && idx2 == -1) {
            return -1;
        }
        if (idx1 == -1 && idx2 > -1) {
            return 1;
        }
        int cmp = s1.getSense().getLemma().compareTo(s1.getSense().getLemma());
        if (cmp != 0) {
            return cmp;
        }
        cmp = s1.getSense().getPOS().compareTo((Enum)s1.getSense().getPOS());
        if (cmp != 0) {
            return cmp;
        }
        FrequencyComparator c = new FrequencyComparator(this.dict, s1.getSense().getLemma(), s1.getSense().getPOS());
        return c.compare(s1, s2);
    }

    protected List<IWordID> getWordIDs(String lemma, POS pos) {
        IIndexWord indexWord = this.dict.getIndexWord(lemma, pos);
        if (indexWord == null) {
            return Collections.emptyList();
        }
        List ids = indexWord.getWordIDs();
        ArrayList<IWordID> result = new ArrayList<IWordID>(ids.size());
        for (IWordID id : ids) {
            IWord word = this.dict.getWord(id);
            result.add((IWordID)word.getID());
        }
        return result;
    }
}

