/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.jwi.data.parse;

import edu.mit.jwi.data.parse.ILineParser;
import edu.mit.jwi.data.parse.MisformattedLineException;
import edu.mit.jwi.item.ExceptionEntryProxy;
import edu.mit.jwi.item.IExceptionEntryProxy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExceptionLineParser
implements ILineParser<IExceptionEntryProxy> {
    private static ExceptionLineParser fInstance;

    public static ExceptionLineParser getInstance() {
        if (fInstance == null) {
            fInstance = new ExceptionLineParser();
        }
        return fInstance;
    }

    protected ExceptionLineParser() {
    }

    @Override
    public IExceptionEntryProxy parseLine(String line) {
        if (line == null) {
            throw new MisformattedLineException(line);
        }
        String[] forms = line.split(" ");
        if (forms.length < 2) {
            throw new MisformattedLineException(line);
        }
        String surface = forms[0].trim();
        String[] trimmed = new String[forms.length - 1];
        for (int i = 1; i < forms.length; ++i) {
            trimmed[i - 1] = forms[i].trim();
        }
        return new ExceptionEntryProxy(surface, trimmed);
    }
}

