/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.jwi.data;

import edu.mit.jwi.data.DataType;
import edu.mit.jwi.data.IContentType;
import edu.mit.jwi.data.IDataType;
import edu.mit.jwi.data.compare.DataLineComparator;
import edu.mit.jwi.data.compare.ExceptionLineComparator;
import edu.mit.jwi.data.compare.ILineComparator;
import edu.mit.jwi.data.compare.IndexLineComparator;
import edu.mit.jwi.data.compare.SenseKeyLineComparator;
import edu.mit.jwi.item.IExceptionEntryProxy;
import edu.mit.jwi.item.IIndexWord;
import edu.mit.jwi.item.ISenseEntry;
import edu.mit.jwi.item.ISynset;
import edu.mit.jwi.item.POS;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContentType<T>
implements IContentType<T> {
    public static final ContentType<IIndexWord> INDEX_NOUN = new ContentType<IIndexWord>(DataType.INDEX, POS.NOUN, IndexLineComparator.getInstance());
    public static final ContentType<IIndexWord> INDEX_VERB = new ContentType<IIndexWord>(DataType.INDEX, POS.VERB, IndexLineComparator.getInstance());
    public static final ContentType<IIndexWord> INDEX_ADVERB = new ContentType<IIndexWord>(DataType.INDEX, POS.ADVERB, IndexLineComparator.getInstance());
    public static final ContentType<IIndexWord> INDEX_ADJECTIVE = new ContentType<IIndexWord>(DataType.INDEX, POS.ADJECTIVE, IndexLineComparator.getInstance());
    public static final ContentType<ISynset> DATA_NOUN = new ContentType<ISynset>(DataType.DATA, POS.NOUN, DataLineComparator.getInstance());
    public static final ContentType<ISynset> DATA_VERB = new ContentType<ISynset>(DataType.DATA, POS.VERB, DataLineComparator.getInstance());
    public static final ContentType<ISynset> DATA_ADVERB = new ContentType<ISynset>(DataType.DATA, POS.ADVERB, DataLineComparator.getInstance());
    public static final ContentType<ISynset> DATA_ADJECTIVE = new ContentType<ISynset>(DataType.DATA, POS.ADJECTIVE, DataLineComparator.getInstance());
    public static final ContentType<IExceptionEntryProxy> EXCEPTION_NOUN = new ContentType<IExceptionEntryProxy>(DataType.EXCEPTION, POS.NOUN, ExceptionLineComparator.getInstance());
    public static final ContentType<IExceptionEntryProxy> EXCEPTION_VERB = new ContentType<IExceptionEntryProxy>(DataType.EXCEPTION, POS.VERB, ExceptionLineComparator.getInstance());
    public static final ContentType<IExceptionEntryProxy> EXCEPTION_ADVERB = new ContentType<IExceptionEntryProxy>(DataType.EXCEPTION, POS.ADVERB, ExceptionLineComparator.getInstance());
    public static final ContentType<IExceptionEntryProxy> EXCEPTION_ADJECTIVE = new ContentType<IExceptionEntryProxy>(DataType.EXCEPTION, POS.ADJECTIVE, ExceptionLineComparator.getInstance());
    public static final ContentType<ISenseEntry> SENSE = new ContentType<ISenseEntry>(DataType.SENSE, null, SenseKeyLineComparator.getInstance());
    private final IDataType<T> fType;
    private final POS fPOS;
    private final ILineComparator fComparator;
    private final String fString;
    private static final Set<ContentType<?>> contentTypes;

    public ContentType(IDataType<T> type, POS pos, ILineComparator comparator) {
        this.fType = type;
        this.fPOS = pos;
        this.fComparator = comparator;
        this.fString = pos != null ? "[ContentType: " + this.fType.toString() + "/" + this.fPOS.toString() + "]" : "[ContentType: " + this.fType.toString() + "]";
    }

    @Override
    public IDataType<T> getDataType() {
        return this.fType;
    }

    @Override
    public POS getPOS() {
        return this.fPOS;
    }

    @Override
    public ILineComparator getLineComparator() {
        return this.fComparator;
    }

    public String toString() {
        return this.fString;
    }

    public static Collection<ContentType<?>> values() {
        return contentTypes;
    }

    public static IContentType<IIndexWord> getIndexContentType(POS pos) {
        if (pos == POS.NOUN) {
            return INDEX_NOUN;
        }
        if (pos == POS.VERB) {
            return INDEX_VERB;
        }
        if (pos == POS.ADVERB) {
            return INDEX_ADVERB;
        }
        return INDEX_ADJECTIVE;
    }

    public static IContentType<ISynset> getDataContentType(POS pos) {
        if (pos == POS.NOUN) {
            return DATA_NOUN;
        }
        if (pos == POS.VERB) {
            return DATA_VERB;
        }
        if (pos == POS.ADVERB) {
            return DATA_ADVERB;
        }
        return DATA_ADJECTIVE;
    }

    public static IContentType<IExceptionEntryProxy> getExceptionContentType(POS pos) {
        if (pos == POS.NOUN) {
            return EXCEPTION_NOUN;
        }
        if (pos == POS.VERB) {
            return EXCEPTION_VERB;
        }
        if (pos == POS.ADVERB) {
            return EXCEPTION_ADVERB;
        }
        return EXCEPTION_ADJECTIVE;
    }

    static {
        Field[] fields = ContentType.class.getFields();
        ArrayList<Field> instanceFields = new ArrayList<Field>();
        for (Field field : fields) {
            if (!(field.getGenericType() instanceof ParameterizedType) || ((ParameterizedType)field.getGenericType()).getRawType() != ContentType.class) continue;
            instanceFields.add(field);
        }
        LinkedHashSet<ContentType> hidden = new LinkedHashSet<ContentType>(instanceFields.size());
        for (Field field : instanceFields) {
            try {
                ContentType contentType = (ContentType)field.get(null);
                if (contentType == null) continue;
                hidden.add(contentType);
            }
            catch (IllegalAccessException e) {}
        }
        contentTypes = Collections.unmodifiableSet(hidden);
    }
}

