/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.theme;

import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.carbon.CGRect;
import org.eclipse.swt.internal.carbon.HIThemeButtonDrawInfo;
import org.eclipse.swt.internal.carbon.OS;
import org.eclipse.swt.internal.theme.DrawData;
import org.eclipse.swt.internal.theme.Theme;

public class ComboDrawData
extends DrawData {
    public ComboDrawData() {
        this.state = new int[2];
    }

    HIThemeButtonDrawInfo getInfo() {
        int state = this.state[0];
        HIThemeButtonDrawInfo info = new HIThemeButtonDrawInfo();
        info.version = 0;
        info.kind = 16;
        if ((this.style & 8) != 0) {
            info.kind = 5;
        }
        if ((state & 0x20) != 0) {
            info.state = (state & 0x10) != 0 ? 7 : 8;
        } else if ((this.style & 8) != 0 && (state & 8) != 0 || (this.style & 8) == 0 && (this.state[1] & 8) != 0) {
            info.state = 2;
        } else {
            int n = info.state = (state & 0x10) != 0 ? 1 : 0;
        }
        if ((state & 4) != 0) {
            info.adornment |= 4;
        }
        return info;
    }

    void draw(Theme theme, GC gc, Rectangle bounds) {
        HIThemeButtonDrawInfo info = this.getInfo();
        CGRect rect = new CGRect();
        rect.x = bounds.x;
        rect.y = bounds.y;
        rect.width = bounds.width;
        rect.height = bounds.height;
        int inset = 0;
        int arrowWidth = 0;
        if ((this.style & 8) == 0) {
            int[] metric = new int[1];
            OS.GetThemeMetric(7, metric);
            inset = metric[0];
            OS.GetThemeMetric(74, metric);
            arrowWidth = metric[0];
            rect.x += (float)inset;
            rect.y += (float)inset;
            rect.width -= (float)(2 * inset);
            rect.height -= (float)(2 * inset);
        } else {
            CGRect backRect = new CGRect();
            OS.HIThemeGetButtonBackgroundBounds(rect, info, backRect);
            rect.x += rect.x - backRect.x;
            rect.y += rect.y - backRect.y;
            rect.width -= backRect.width - rect.width;
            rect.height -= backRect.height - rect.height;
        }
        CGRect labelRect = this.clientArea != null && (this.style & 8) != 0 ? new CGRect() : null;
        OS.HIThemeDrawButton(rect, info, gc.handle, 0, labelRect);
        if (this.clientArea != null) {
            if ((this.style & 8) != 0) {
                this.clientArea.x = (int)labelRect.x;
                this.clientArea.y = (int)labelRect.y;
                this.clientArea.width = (int)labelRect.width;
                this.clientArea.height = (int)labelRect.height;
            } else {
                this.clientArea.x = bounds.x + inset;
                this.clientArea.y = bounds.y + inset;
                this.clientArea.width = bounds.width - 2 * inset - arrowWidth;
                this.clientArea.height = bounds.height - 2 * inset;
            }
        }
    }

    int hit(Theme theme, Point position, Rectangle bounds) {
        if (!bounds.contains(position)) {
            return -1;
        }
        if ((this.style & 8) == 0) {
            int[] metric = new int[1];
            OS.GetThemeMetric(7, metric);
            int inset = metric[0];
            OS.GetThemeMetric(74, metric);
            int arrowWidth = metric[0];
            Rectangle arrowRect = new Rectangle(bounds.x + bounds.width - inset - arrowWidth, bounds.y - inset, arrowWidth, bounds.height - inset * 2);
            if (arrowRect.contains(position)) {
                return 1;
            }
        }
        return 0;
    }
}

