/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.story.core.position;

import edu.mit.story.core.position.IHasPosition;
import edu.mit.story.core.position.IHasPositionSet;
import edu.mit.story.core.position.IPosition;
import edu.mit.story.core.position.SimplePosition;
import edu.mit.story.core.position.StoryPosition;
import edu.mit.story.core.util.IUtilityClass;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import org.eclipse.jface.text.Position;
import org.eclipse.swt.graphics.Point;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PositionUtils
implements IUtilityClass {
    private PositionUtils() {
    }

    public static IHasPosition makePosition(IHasPosition p) {
        try {
            return new SimplePosition(p);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static Position toDocumentPosition(IHasPosition p) {
        return p == null ? null : new Position(p.getOffset(), p.getLength());
    }

    public static int compareHasPositions(IHasPosition one, IHasPosition two) {
        if (one.getOffset() != two.getOffset()) {
            return one.getOffset() - two.getOffset();
        }
        if (one.getLength() != two.getLength()) {
            return one.getLength() - two.getLength();
        }
        if (one.hashCode() < two.hashCode()) {
            return -1;
        }
        if (one.hashCode() > two.hashCode()) {
            return 1;
        }
        return 0;
    }

    public static int comparePositions(IHasPosition one, IHasPosition two) {
        if (one.getOffset() != two.getOffset()) {
            return one.getOffset() - two.getOffset();
        }
        if (one.getLength() != two.getLength()) {
            return one.getLength() - two.getLength();
        }
        return 0;
    }

    public static IHasPosition max(Comparator<? super IHasPosition> comparator, IHasPosition one, IHasPosition two) {
        int result = comparator.compare(one, two);
        if (result < 0) {
            return two;
        }
        return one;
    }

    public static IHasPosition min(Comparator<? super IHasPosition> comparator, IHasPosition one, IHasPosition two) {
        int result = comparator.compare(one, two);
        if (result <= 0) {
            return one;
        }
        return two;
    }

    public static IHasPosition maxHasPosition(IHasPosition one, IHasPosition two) {
        int result = PositionUtils.compareHasPositions(one, two);
        if (result < 0) {
            return two;
        }
        return one;
    }

    public static IHasPosition maxPosition(IHasPosition one, IHasPosition two) {
        int result = PositionUtils.comparePositions(one, two);
        if (result < 0) {
            return two;
        }
        return one;
    }

    public static IHasPosition minHasPosition(IHasPosition one, IHasPosition two) {
        int result = PositionUtils.compareHasPositions(one, two);
        if (result <= 0) {
            return one;
        }
        return two;
    }

    public static IHasPosition minPosition(IHasPosition one, IHasPosition two) {
        int result = PositionUtils.comparePositions(one, two);
        if (result <= 0) {
            return one;
        }
        return two;
    }

    public static boolean isInside(IHasPosition p, int index, boolean leftClosed, boolean rightClosed) {
        if (p == null) {
            return false;
        }
        if (index < 0) {
            return false;
        }
        if (leftClosed & rightClosed) {
            return p.getOffset() <= index & index <= p.getRightOffset();
        }
        if (leftClosed & !rightClosed) {
            return p.getOffset() <= index & index < p.getRightOffset();
        }
        if (!leftClosed & rightClosed) {
            return p.getOffset() < index & index <= p.getRightOffset();
        }
        return p.getOffset() < index & index < p.getRightOffset();
    }

    public static boolean overlaps(IHasPosition one, IHasPosition two) {
        if (one.getOffset() <= two.getOffset() & two.getOffset() <= one.getRightOffset()) {
            return true;
        }
        return two.getOffset() <= one.getOffset() & one.getOffset() <= two.getRightOffset();
    }

    public static boolean overlapsOpen(IHasPosition one, IHasPosition two) {
        if (one.getOffset() == two.getOffset() & one.getLength() == two.getLength()) {
            return true;
        }
        if (one.getRightOffset() <= two.getOffset()) {
            return false;
        }
        return two.getRightOffset() > one.getOffset();
    }

    public static boolean isBoundary(IHasPosition boundary, IHasPosition position) {
        if (boundary.getLength() != 0) {
            return false;
        }
        return boundary.getOffset() == position.getOffset() || boundary.getRightOffset() == position.getRightOffset();
    }

    public static boolean positionsEqual(IHasPosition one, IHasPosition two) {
        if (one == null & two == null) {
            return true;
        }
        if (one == null ^ two == null) {
            return false;
        }
        return one.getOffset() == two.getOffset() & one.getLength() == two.getLength();
    }

    public static boolean equalAsHasPositions(IHasPosition one, IHasPosition two) {
        return PositionUtils.compareHasPositions(one, two) == 0;
    }

    public static boolean equalAsPositions(IHasPosition one, IHasPosition two) {
        return PositionUtils.comparePositions(one, two) == 0;
    }

    public static IPosition union(IHasPosition one, IHasPosition two) {
        if (one == null | two == null) {
            return null;
        }
        if (PositionUtils.intersection(one, two) == null) {
            return null;
        }
        int left = Math.min(one.getOffset(), one.getOffset());
        int right = Math.max(one.getRightOffset(), two.getRightOffset());
        return new StoryPosition(left, right - left);
    }

    public static boolean intersect(IHasPosition one, IHasPosition two) {
        return two.getOffset() <= one.getRightOffset() && one.getOffset() <= two.getRightOffset();
    }

    public static boolean isIntersectionNonzero(IHasPosition one, IHasPosition two) {
        return two.getOffset() < one.getRightOffset() && one.getOffset() < two.getRightOffset();
    }

    public static IHasPosition intersection(IHasPosition one, IHasPosition two) {
        if (!PositionUtils.intersect(one, two)) {
            return null;
        }
        int left = Math.max(one.getOffset(), two.getOffset());
        int right = Math.min(one.getRightOffset(), two.getRightOffset());
        return new SimplePosition(left, right - left);
    }

    public static boolean isInside(IHasPosition inside, IHasPosition outside) {
        return outside.getOffset() <= inside.getOffset() && inside.getRightOffset() <= outside.getRightOffset();
    }

    public static IHasPosition combine(IHasPosition one, IHasPosition two) {
        if (one == null) {
            return two;
        }
        if (two == null) {
            return one;
        }
        int left = Math.min(one.getOffset(), two.getOffset());
        int right = Math.max(one.getRightOffset(), two.getRightOffset());
        return new SimplePosition(left, right - left);
    }

    public static IHasPosition removeIndicies(IHasPosition patient, IHasPosition excision) {
        if (!PositionUtils.intersect(patient, excision)) {
            return null;
        }
        if (patient.getOffset() < excision.getOffset() & patient.getRightOffset() <= excision.getRightOffset()) {
            return new SimplePosition(patient.getOffset(), excision.getOffset() - patient.getOffset());
        }
        if (excision.getOffset() < patient.getOffset() & excision.getRightOffset() < patient.getRightOffset()) {
            int left = excision.getRightOffset();
            int right = patient.getRightOffset();
            return new SimplePosition(left, right - left);
        }
        return null;
    }

    public static boolean contains(IHasPosition container, IHasPosition contained) {
        return container.getOffset() <= contained.getOffset() && contained.getRightOffset() <= container.getRightOffset();
    }

    public static IHasPosition combineAll(IHasPosition ... c) {
        if (c == null) {
            return null;
        }
        if (c.length == 0) {
            return null;
        }
        IHasPosition result = null;
        IHasPosition[] iHasPositionArray = c;
        int n = c.length;
        int n2 = 0;
        while (n2 < n) {
            IHasPosition p = iHasPositionArray[n2];
            if (p != null) {
                result = result == null ? new SimplePosition(p) : PositionUtils.combine(result, p);
            }
            ++n2;
        }
        return result;
    }

    public static IHasPosition combineAll(Collection<? extends IHasPosition> c) {
        if (c == null) {
            return null;
        }
        if (c.isEmpty()) {
            return null;
        }
        int leftOffset = Integer.MAX_VALUE;
        int rightOffset = 0;
        for (IHasPosition iHasPosition : c) {
            leftOffset = Math.min(leftOffset, iHasPosition.getOffset());
            rightOffset = Math.max(rightOffset, iHasPosition.getRightOffset());
        }
        return new SimplePosition(leftOffset, rightOffset - leftOffset);
    }

    public static void assertValidPosition(int offset, int length) {
        if (offset < 0 || length < 0) {
            throw new IllegalArgumentException();
        }
    }

    public static boolean definesNullSet(IHasPosition fromPos, IHasPosition toPos, int fromOffset, int toOffset) {
        if (fromPos != null & toPos != null) {
            if (toPos.getRightOffset() < fromOffset | toOffset < fromPos.getOffset()) {
                return true;
            }
            if (PositionUtils.equalAsHasPositions(fromPos, toPos)) {
                return true;
            }
        } else {
            if (fromPos != null && toOffset < fromPos.getOffset()) {
                return true;
            }
            if (toPos != null && toPos.getRightOffset() < fromOffset) {
                return true;
            }
        }
        return toOffset < fromOffset;
    }

    public static boolean definesNullSet(IPosition fromPos, IPosition toPos, int fromOffset, int toOffset) {
        if (fromPos != null & toPos != null) {
            if (toPos.getRightOffset() < fromOffset | toOffset < fromPos.getOffset()) {
                return true;
            }
            if (PositionUtils.positionsEqual(fromPos, toPos)) {
                return true;
            }
        } else {
            if (fromPos != null && toOffset < fromPos.getOffset()) {
                return true;
            }
            if (toPos != null && toPos.getRightOffset() < fromOffset) {
                return true;
            }
        }
        return toOffset < fromOffset;
    }

    public static String toUserFriendlyString(IHasPosition p) {
        if (p == null) {
            return "null";
        }
        return String.valueOf(p.getOffset()) + "-" + p.getRightOffset();
    }

    public static String toString(IHasPosition p) {
        if (p == null) {
            return "null";
        }
        return "[off=" + p.getOffset() + ",len=" + p.getLength() + "]";
    }

    public static String toString(IHasPositionSet<? extends IHasPosition> ps) {
        return PositionUtils.toString("", ps);
    }

    public static String toString(String linePrefix, IHasPositionSet<? extends IHasPosition> ps) {
        StringBuffer sb = new StringBuffer();
        if (ps == null) {
            sb.append(linePrefix);
            sb.append("(null)");
            return sb.toString();
        }
        if (ps.isEmpty()) {
            sb.append(linePrefix);
            sb.append("(empty)");
            return sb.toString();
        }
        int currOffset = -1;
        for (IHasPosition iHasPosition : ps) {
            if (iHasPosition.getOffset() != currOffset) {
                currOffset = iHasPosition.getOffset();
                if (sb.length() > 0) {
                    sb.append("\n");
                }
                sb.append(linePrefix);
                sb.append(currOffset);
                sb.append(":");
            }
            sb.append(' ');
            sb.append(PositionUtils.toString(iHasPosition));
        }
        return sb.toString();
    }

    public static IHasPosition toPosition(Point p) {
        return new SimplePosition(p.x, p.y);
    }

    public static int findNextLeftBound(int index, IHasPositionSet<? extends IHasPosition> set) {
        int offset = -1;
        for (IHasPosition iHasPosition : set) {
            if (iHasPosition.getOffset() >= index) break;
            offset = iHasPosition.getOffset();
        }
        return offset;
    }

    public static int findNextRightBound(int index, IHasPositionSet<? extends IHasPosition> set) {
        if (index < 0) {
            throw new IllegalArgumentException();
        }
        int right = set.getRightOffset();
        if (right <= index) {
            return -1;
        }
        set = set.openSet(new SimplePosition(index, right - index));
        for (IHasPosition iHasPosition : set) {
            if (right <= iHasPosition.getOffset()) break;
            if (iHasPosition.getRightOffset() >= right) continue;
            right = iHasPosition.getRightOffset();
        }
        return right;
    }

    public static int findCoverLeftBound(int index, IHasPositionSet<? extends IHasPosition> set) {
        if (index < 0) {
            throw new IllegalArgumentException();
        }
        return (set = set.closedSet(new StoryPosition(index, 0))).isEmpty() ? -1 : set.getOffset();
    }

    public static int findCoverRightBound(int index, IHasPositionSet<? extends IHasPosition> set) {
        if (index < 0) {
            throw new IllegalArgumentException();
        }
        return (set = set.closedSet(new StoryPosition(index, 0))).isEmpty() ? -1 : set.getRightOffset();
    }

    public static <T extends IHasPosition> T getPrevious(T p, IHasPositionSet<T> set) {
        if (p == null || set == null) {
            return null;
        }
        IHasPositionSet<T> headSet = set.headSet(p);
        return (T)(headSet.isEmpty() ? null : (IHasPosition)headSet.last());
    }

    public static <T extends IHasPosition> T getNext(T p, IHasPositionSet<T> set) {
        if (p == null || set == null) {
            return null;
        }
        IHasPositionSet<T> tailSet = set.tailSet(p);
        Iterator i = tailSet.iterator();
        if (!i.hasNext()) {
            return null;
        }
        IHasPosition next = (IHasPosition)i.next();
        return (T)(p == next && i.hasNext() ? (IHasPosition)i.next() : next);
    }
}

