/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.story.core.position;

import edu.mit.story.core.notify.INotifyCollectionCallback;
import edu.mit.story.core.notify.NotifyingIterator;
import edu.mit.story.core.position.HasPositionComparator;
import edu.mit.story.core.position.IHasPosition;
import edu.mit.story.core.position.IHasPositionSet;
import edu.mit.story.core.position.SimplePosition;
import edu.mit.story.core.util.Debug;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Random;
import java.util.SortedSet;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HasPositionSet<P extends IHasPosition>
extends AbstractSet<P>
implements IHasPositionSet<P>,
INotifyCollectionCallback<P> {
    private final int lowerBound;
    private final boolean isOpen;
    private final SortedSet<P> backingSet;

    public HasPositionSet() {
        this.lowerBound = -1;
        this.isOpen = true;
        this.backingSet = new TreeSet<IHasPosition>(HasPositionComparator.getInstance());
    }

    public HasPositionSet(Collection<? extends P> elements) {
        this.lowerBound = -1;
        this.isOpen = true;
        this.backingSet = new TreeSet<IHasPosition>(HasPositionComparator.getInstance());
        this.backingSet.addAll(elements);
    }

    protected HasPositionSet(int lowerBound, boolean isOpen, SortedSet<P> backingSet) {
        if (backingSet == null) {
            throw new NullPointerException();
        }
        if (lowerBound < -1) {
            throw new IllegalArgumentException();
        }
        this.lowerBound = lowerBound;
        this.isOpen = isOpen;
        this.backingSet = backingSet;
    }

    protected boolean insideLowerBound(IHasPosition p) {
        if (this.lowerBound < 0) {
            return true;
        }
        if (p.getRightOffset() < this.lowerBound) {
            return false;
        }
        return !this.isOpen || p.getRightOffset() != this.lowerBound || p.getLength() <= 0;
    }

    @Override
    public boolean add(P e) {
        boolean success = this.internalAdd(e);
        if (success) {
            this.elementAdded(e);
        }
        return success;
    }

    public boolean internalAdd(P e) {
        if (!this.insideLowerBound((IHasPosition)e)) {
            throw new IllegalArgumentException("element out of bounds for range of set");
        }
        return this.backingSet.add(e);
    }

    @Override
    public boolean remove(Object o) {
        boolean success = this.internalRemove(o);
        if (success) {
            this.elementRemoved((P)((IHasPosition)o));
        }
        return success;
    }

    public boolean internalRemove(Object o) {
        if (o instanceof IHasPosition) {
            IHasPosition p = (IHasPosition)o;
            return this.insideLowerBound(p) && this.backingSet.remove(p);
        }
        return false;
    }

    public void internalClear() {
        Iterator<P> i = this.iterator(false);
        while (i.hasNext()) {
            i.next();
            i.remove();
        }
    }

    @Override
    public void elementAdded(P added) {
    }

    @Override
    public void elementRemoved(P removed) {
    }

    @Override
    public boolean contains(Object o) {
        if (o instanceof IHasPosition) {
            IHasPosition p = (IHasPosition)o;
            return this.insideLowerBound(p) && this.backingSet.contains(p);
        }
        return false;
    }

    @Override
    public int size() {
        if (this.lowerBound == -1) {
            return this.backingSet.size();
        }
        int size = 0;
        Iterator<P> iterator = this.iterator();
        while (iterator.hasNext()) {
            IHasPosition cfr_ignored_0 = (IHasPosition)iterator.next();
            ++size;
        }
        return size;
    }

    @Override
    public IHasPositionSet<P> closedSet(IHasPosition range) {
        return this.rangeSet(range, true);
    }

    @Override
    public IHasPositionSet<P> matchSet(IHasPosition position) {
        LimitPosition lower = new LimitPosition(position, false);
        LimitPosition upper = new LimitPosition(position, true);
        return new HasPositionSet<LimitPosition>(this.lowerBound, this.isOpen, this.backingSet.subSet(lower, upper));
    }

    @Override
    public IHasPositionSet<P> openSet(IHasPosition range) {
        return this.rangeSet(range, true);
    }

    protected IHasPositionSet<P> rangeSet(IHasPosition range, boolean isOpen) {
        LimitPosition toElement = new LimitPosition(range.getRightOffset(), isOpen);
        return this.rangeSet(range.getOffset(), isOpen, this.backingSet.headSet(toElement));
    }

    protected IHasPositionSet<P> rangeSet(int lowerBound, boolean isOpen, SortedSet<P> backing) {
        return new HasPositionSet<P>(lowerBound, isOpen, backing);
    }

    @Override
    public IHasPositionSet<P> headSet(P toElement) {
        return this.rangeSet(this.lowerBound, this.isOpen, this.backingSet.headSet(toElement));
    }

    @Override
    public IHasPositionSet<P> subSet(P fromElement, P toElement) {
        return this.rangeSet(this.lowerBound, this.isOpen, this.backingSet.subSet(fromElement, toElement));
    }

    @Override
    public IHasPositionSet<P> tailSet(P fromElement) {
        return this.rangeSet(this.lowerBound, this.isOpen, this.backingSet.tailSet(fromElement));
    }

    @Override
    public Iterator<P> iterator() {
        return this.iterator(true);
    }

    protected Iterator<P> iterator(boolean notify) {
        if (this.lowerBound < 0) {
            Iterator itr = this.backingSet.iterator();
            if (notify) {
                itr = new NotifyingIterator(itr, this);
            }
            return itr;
        }
        return new PositionSetIterator(notify);
    }

    @Override
    public P first() {
        if (this.lowerBound == -1) {
            return (P)((IHasPosition)this.backingSet.first());
        }
        return (P)((IHasPosition)this.iterator().next());
    }

    @Override
    public P last() {
        if (this.lowerBound == -1) {
            return (P)((IHasPosition)this.backingSet.last());
        }
        IHasPosition result2 = null;
        for (IHasPosition result2 : this) {
        }
        if (result2 == null) {
            throw new NoSuchElementException();
        }
        return (P)result2;
    }

    @Override
    public int getOffset() {
        try {
            return this.first().getOffset();
        }
        catch (NoSuchElementException noSuchElementException) {
            return -1;
        }
    }

    @Override
    public int getLength() {
        int offset = this.getOffset();
        return offset == -1 ? -1 : this.getRightOffset() - offset;
    }

    @Override
    public int getRightOffset() {
        try {
            return this.last().getRightOffset();
        }
        catch (NoSuchElementException noSuchElementException) {
            return -1;
        }
    }

    @Override
    public Comparator<? super P> comparator() {
        return this.backingSet.comparator();
    }

    /*
     * WARNING - void declaration
     */
    public static void main(String[] args) {
        Iterator i;
        Iterator iterator;
        IHasPositionSet subSet;
        void var18_13;
        SimplePosition p1 = new SimplePosition(1, 0);
        SimplePosition p2 = new SimplePosition(1, 2);
        SimplePosition p3 = new SimplePosition(1, 4);
        SimplePosition p4 = new SimplePosition(3, 2);
        SimplePosition p5 = new SimplePosition(5, 0);
        HasPositionSet<IHasPosition> newSet = new HasPositionSet<IHasPosition>(Arrays.asList(p1, p2, p3, p4, p5));
        int size = newSet.size();
        Debug.out("Size: " + size);
        if (size != 5) {
            throw new IllegalStateException();
        }
        int num = 1000000;
        System.out.println();
        System.out.print("Creating " + num + " positions...");
        int upper = 100;
        ArrayList<SimplePosition> ps = new ArrayList<SimplePosition>(num);
        Random r = new Random();
        boolean bl = false;
        while (var18_13 < num) {
            int offset = r.nextInt(upper);
            int length = r.nextInt(upper);
            ps.add(new SimplePosition(offset, length));
            ++var18_13;
        }
        System.out.println("done.");
        Debug.out(1, "Adding " + num + " instances to old");
        Debug.Time time = Debug.Time.start();
        HasPositionSet oldSet = new HasPositionSet(ps);
        time.stop();
        time.print();
        Debug.out(1, "Adding " + num + " instances to new");
        time = Debug.Time.start();
        newSet = new HasPositionSet(ps);
        time.stop();
        time.print();
        Debug.out(1, "Iterating over subsets for old");
        oldSet = new HasPositionSet(ps);
        Debug.ProgressBar pb = new Debug.ProgressBar(num);
        size = 0;
        for (IHasPosition iHasPosition : oldSet) {
            subSet = oldSet.openSet(iHasPosition);
            iterator = subSet.iterator();
            while (iterator.hasNext()) {
                IHasPosition cfr_ignored_0 = (IHasPosition)iterator.next();
                ++size;
            }
            pb.increment();
        }
        pb.finish();
        Debug.out("Total elements iterated over for old: " + size);
        if (size < num) {
            throw new IllegalArgumentException();
        }
        Debug.out(1, "Iterating over subsets for new");
        newSet = new HasPositionSet(ps);
        pb = new Debug.ProgressBar(num);
        size = 0;
        for (IHasPosition iHasPosition : newSet) {
            subSet = newSet.openSet(iHasPosition);
            iterator = subSet.iterator();
            while (iterator.hasNext()) {
                IHasPosition cfr_ignored_1 = (IHasPosition)iterator.next();
                ++size;
            }
            pb.increment();
        }
        pb.finish();
        Debug.out("Total elements iterated over for new: " + size);
        if (size < num) {
            throw new IllegalArgumentException();
        }
        Debug.out(1, "Removing over subsets for old");
        pb = new Debug.ProgressBar(num);
        size = 0;
        for (IHasPosition iHasPosition : ps) {
            subSet = oldSet.openSet(iHasPosition);
            i = subSet.iterator();
            while (i.hasNext()) {
                i.next();
                i.remove();
            }
            pb.increment();
        }
        pb.finish();
        size = oldSet.size();
        Debug.out("Old set size after remove " + size);
        if (size != 0) {
            throw new IllegalArgumentException();
        }
        Debug.out(1, "Removing over subsets for new");
        pb = new Debug.ProgressBar(num);
        size = 0;
        for (IHasPosition iHasPosition : ps) {
            subSet = newSet.openSet(iHasPosition);
            i = subSet.iterator();
            while (i.hasNext()) {
                i.next();
                i.remove();
            }
            pb.increment();
        }
        pb.finish();
        size = newSet.size();
        Debug.out("New set size after remove " + size);
        if (size != 0) {
            throw new IllegalArgumentException();
        }
        Debug.out(1, "Removing over subsets for old; odd order");
        oldSet = new HasPositionSet(ps);
        pb = new Debug.ProgressBar(num);
        size = 0;
        subSet = oldSet.openSet(new SimplePosition(0, 3 * upper));
        Iterator iterator2 = subSet.iterator();
        while (iterator2.hasNext()) {
            iterator2.next();
            if (iterator2.hasNext()) {
                iterator2.remove();
            }
            pb.increment();
        }
        pb.finish();
        size = oldSet.size();
        Debug.out("Old set size after remove " + size);
        if (size != 1) {
            throw new IllegalArgumentException();
        }
        Debug.out(1, "Removing over subsets for new; odd order");
        newSet = new HasPositionSet(ps);
        pb = new Debug.ProgressBar(num);
        size = 0;
        subSet = newSet.openSet(new SimplePosition(0, 3 * upper));
        Iterator iterator3 = subSet.iterator();
        while (iterator3.hasNext()) {
            iterator3.next();
            if (iterator3.hasNext()) {
                iterator3.remove();
            }
            pb.increment();
        }
        pb.finish();
        size = oldSet.size();
        Debug.out("New set size after remove " + size);
        if (size != 1) {
            throw new IllegalArgumentException();
        }
    }

    protected class LimitPosition
    implements IHasPosition {
        private final int offset;
        private final int length;
        private final int rightOffset;
        private final int hash;

        public LimitPosition(int limit, boolean open) {
            this.offset = open ? limit : limit + 1;
            this.length = 0;
            this.rightOffset = this.offset;
            this.hash = open ? Integer.MAX_VALUE : Integer.MIN_VALUE;
        }

        public LimitPosition(IHasPosition match, boolean upper) {
            this.offset = match.getOffset();
            this.length = match.getLength();
            this.rightOffset = this.offset + this.length;
            this.hash = upper ? Integer.MAX_VALUE : Integer.MIN_VALUE;
        }

        public int getLength() {
            return this.length;
        }

        public int getOffset() {
            return this.offset;
        }

        public int getRightOffset() {
            return this.rightOffset;
        }

        public int hashCode() {
            return this.hash;
        }

        public boolean equals(Object obj) {
            return this == obj;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class PositionSetIterator
    implements Iterator<P> {
        private final boolean notify;
        protected Iterator<P> itr;
        protected P remove;
        protected P next;

        public PositionSetIterator() {
            this(true);
        }

        public PositionSetIterator(boolean notify) {
            this.itr = HasPositionSet.this.backingSet.iterator();
            this.remove = null;
            this.next = null;
            this.notify = notify;
        }

        @Override
        public P next() {
            if (this.next == this.remove) {
                this.advance();
            }
            if (this.next == null) {
                throw new NoSuchElementException();
            }
            this.remove = this.next;
            return this.next;
        }

        @Override
        public boolean hasNext() {
            if (this.next == this.remove) {
                this.advance();
            }
            return this.next != null;
        }

        protected void advance() {
            this.next = null;
            while (this.itr.hasNext()) {
                IHasPosition p = (IHasPosition)this.itr.next();
                if (!HasPositionSet.this.insideLowerBound(p)) continue;
                this.next = p;
                break;
            }
        }

        @Override
        public void remove() {
            if (this.remove == null) {
                throw new IllegalStateException();
            }
            if (this.next != this.remove) {
                this.itr = HasPositionSet.this.backingSet.tailSet(this.remove).iterator();
                this.itr.next();
            }
            this.itr.remove();
            this.advance();
            Object removed = this.remove;
            this.remove = null;
            if (this.notify) {
                HasPositionSet.this.elementRemoved(removed);
            }
        }
    }
}

