/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.story.core.desc.factory;

import edu.mit.story.core.StoryMessages;
import edu.mit.story.core.StoryPlugin;
import edu.mit.story.core.desc.factory.FactoryManager;
import edu.mit.story.core.desc.factory.IDescFactory;
import edu.mit.story.core.desc.factory.IFactoryDescriptor;
import edu.mit.story.core.descriptor.ConfigurableDescriptor;
import edu.mit.story.core.rep.IRep;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FactoryDescriptor
extends ConfigurableDescriptor<IDescFactory>
implements IFactoryDescriptor {
    public FactoryDescriptor(IConfigurationElement element) {
        super(element);
    }

    public FactoryDescriptor(IRep rep, IConfigurationElement element, boolean isNull) {
        super(FactoryDescriptor.extractID(rep, element, isNull), FactoryDescriptor.extractName(rep, element, isNull), FactoryDescriptor.extractDesc(rep, element, isNull), element, "class");
    }

    public static String extractID(IRep rep, IConfigurationElement element, boolean isNull) {
        String actualID;
        String regID = element.getAttribute("id");
        String string = actualID = isNull ? FactoryManager.makeNullFactoryID(rep) : FactoryManager.makeDefaultFactoryID(rep);
        if (!regID.equals(actualID)) {
            Object[] ids = new String[]{regID, actualID};
            String msg = NLS.bind((String)StoryMessages.MSG_ERR_IdNotSpecifiedCorrectly, (Object[])ids);
            Status status = new Status(2, element.getContributor().getName(), msg);
            StoryPlugin.getDefault().getLog().log((IStatus)status);
        }
        return actualID;
    }

    public static String extractName(IRep rep, IConfigurationElement element, boolean isNull) {
        String name = element.getAttribute("name");
        if (name == null) {
            name = isNull ? FactoryManager.makeNullFactoryName(rep) : FactoryManager.makeDefaultFactoryName(rep);
        }
        return name;
    }

    public static String extractDesc(IRep rep, IConfigurationElement element, boolean isNull) {
        String desc = element.getAttribute("description");
        if (desc == null) {
            desc = isNull ? FactoryManager.makeNullFactoryDesc(rep) : FactoryManager.makeDefaultFactoryDesc(rep);
        }
        return desc;
    }
}

