/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.story.core.desc;

import edu.mit.story.core.desc.DescSet;
import edu.mit.story.core.desc.IDesc;
import edu.mit.story.core.desc.IDescMultiSet;
import edu.mit.story.core.desc.IDescSet;
import edu.mit.story.core.element.IStoryElement;
import edu.mit.story.core.position.IHasPosition;
import edu.mit.story.core.rep.IRep;
import edu.mit.story.core.rep.IRepSet;
import edu.mit.story.core.rep.RepSet;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.SortedMap;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DescMultiSet
extends AbstractSet<IDesc>
implements IDescMultiSet {
    private static final long serialVersionUID = -7370323144649879059L;
    protected final SortedMap<IRep, IDescSet> repMap;

    public Object getAdapter(Class adapter) {
        return null;
    }

    public DescMultiSet() {
        this.repMap = this.createDescriptionMap(null);
    }

    public DescMultiSet(Collection<? extends IDesc> c) {
        if (c == null) {
            throw new NullPointerException();
        }
        this.repMap = this.createDescriptionMap(c);
    }

    protected SortedMap<IRep, IDescSet> createDescriptionMap(Collection<? extends IDesc> c) {
        if (c == null) {
            return new TreeMap<IRep, IDescSet>();
        }
        DescMultiSet hidden = new DescMultiSet();
        hidden.addAll(c);
        return hidden.repMap;
    }

    @Override
    public int size() {
        int result = 0;
        for (IDescSet descSet : this.repMap.values()) {
            result += descSet.size();
        }
        return result;
    }

    @Override
    public boolean contains(Object o) {
        if (!(o instanceof IDesc)) {
            return false;
        }
        IDesc desc = (IDesc)o;
        IDescSet descSet = (IDescSet)this.repMap.get(desc.getRep());
        return descSet == null ? false : descSet.contains(desc);
    }

    @Override
    public Iterator<IDesc> iterator() {
        return new DescriptionIterator();
    }

    protected IRepSet createSupportSet(Collection<? extends IRep> reps) {
        return reps != null ? new RepSet(reps) : new RepSet();
    }

    protected IDescSet createDescriptionSet(IRep rep, IDesc d, Collection<? extends IDesc> descs) {
        DescSet result = new DescSet(rep);
        if (d != null) {
            result.add(d);
        }
        if (descs != null) {
            result.addAll(descs);
        }
        this.repMap.put(rep, result);
        return result;
    }

    @Override
    public boolean add(IDesc d) {
        if (d == null) {
            return false;
        }
        IDescSet descSet = (IDescSet)this.repMap.get(d.getRep());
        if (descSet == null) {
            descSet = this.createDescriptionSet(d.getRep(), d, null);
            return true;
        }
        return descSet.add(d);
    }

    @Override
    public boolean addAll(Collection<? extends IDesc> c) {
        if (c instanceof IDescMultiSet) {
            IDescMultiSet descMap = (IDescMultiSet)c;
            boolean changed = false;
            Iterator repItr = descMap.repIterator();
            while (repItr.hasNext()) {
                IDescSet descSet = descMap.getDescriptions((IRep)repItr.next());
                changed |= this.addUniformRepresentationSet(descSet.getRep(), descSet);
            }
            return changed;
        }
        return super.addAll(c);
    }

    protected boolean addUniformRepresentationSet(IRep rep, Collection<IDesc> descs) {
        IDescSet target = (IDescSet)this.repMap.get(rep);
        if (target == null) {
            this.createDescriptionSet(rep, null, descs);
            return true;
        }
        return target.addAll(descs);
    }

    @Override
    public boolean remove(Object o) {
        if (!(o instanceof IDesc)) {
            return false;
        }
        IDesc desc = (IDesc)o;
        IDescSet descSet = (IDescSet)this.repMap.get(desc.getRep());
        if (descSet == null) {
            return false;
        }
        return descSet.remove(desc);
    }

    @Override
    public boolean containsAll(Collection c) {
        if (c instanceof IDescMultiSet) {
            IDescMultiSet descMap = (IDescMultiSet)c;
            Iterator repItr = descMap.repIterator();
            while (repItr.hasNext()) {
                IRep rep = (IRep)repItr.next();
                IDescSet targetSet = (IDescSet)this.repMap.get(rep);
                if (targetSet == null) {
                    return false;
                }
                IDescSet descSet = descMap.getDescriptions(rep);
                if (descSet == null) {
                    return false;
                }
                if (targetSet.containsAll(descSet)) continue;
                return false;
            }
            return true;
        }
        return super.containsAll(c);
    }

    @Override
    public void clear() {
        for (IDescSet descSet : this.repMap.values()) {
            descSet.clear();
        }
        this.repMap.clear();
    }

    @Override
    public int size(IRep target) {
        IDescSet descSet = (IDescSet)this.repMap.get(target);
        return descSet == null ? 0 : descSet.size();
    }

    @Override
    public Iterator<IDescSet> descSetIterator() {
        return new DescriptionSetIterator();
    }

    @Override
    public IDescSet getDescriptions(IRep target) {
        IDescSet result = (IDescSet)this.repMap.get(target);
        return result != null ? result : this.createDescriptionSet(target, null, null);
    }

    @Override
    public IDesc getDescription(long id) {
        IDesc result = null;
        EntryIterator i = new EntryIterator();
        while (i.hasNext()) {
            result = ((IDescSet)((Map.Entry)i.next()).getValue()).getDescription(id);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public IDesc getDescription(long id, IRep rep) {
        if (rep == null) {
            return this.getDescription(id);
        }
        IDescSet descSet = (IDescSet)this.repMap.get(rep);
        if (descSet == null) {
            return null;
        }
        return descSet.getDescription(id);
    }

    public IDescSet getDescriptions(IHasPosition range, IRep target) {
        IDescSet set = this.getDescriptions(target);
        if (set == null) {
            return null;
        }
        return set.closedSet(range);
    }

    public IDescSet getDescriptionsAt(IHasPosition range, IRep target) {
        IDescSet set = this.getDescriptions(target);
        if (set == null) {
            return null;
        }
        return set.matchSet(range);
    }

    @Override
    public boolean supports(IRep rep) {
        IDescSet descSet = (IDescSet)this.repMap.get(rep);
        return descSet == null ? false : !descSet.isEmpty();
    }

    @Override
    public boolean supportsAll(Collection<? extends IRep> reps) {
        for (IRep iRep : reps) {
            if (this.supports(iRep)) continue;
            return false;
        }
        return true;
    }

    @Override
    public Iterator<IRep> repIterator() {
        return new RepresentationIterator();
    }

    @Override
    public int repSize() {
        int result = 0;
        Iterator<IRep> i = this.repIterator();
        while (i.hasNext()) {
            ++result;
            i.next();
        }
        return result;
    }

    @Override
    public IRepSet getSupported() {
        RepSet result = new RepSet();
        Iterator<IRep> i = this.repIterator();
        while (i.hasNext()) {
            result.add(i.next());
        }
        return result;
    }

    @Override
    public final int getImplementationCode() {
        return 7;
    }

    @Override
    public final String getImplementationName() {
        return IStoryElement.NAME_IDescriptionMultiSet;
    }

    @Override
    public final String getSerializedData() {
        return null;
    }

    @Override
    public int getOffset() {
        int result = Integer.MAX_VALUE;
        Iterator<IDescSet> i = this.descSetIterator();
        while (i.hasNext()) {
            IDescSet descs = i.next();
            if (descs.isEmpty()) continue;
            result = Math.min(result, descs.getOffset());
        }
        return result;
    }

    @Override
    public int getLength() {
        int offset = Integer.MAX_VALUE;
        int rightOffset = -1;
        Iterator<IDescSet> i = this.descSetIterator();
        while (i.hasNext()) {
            IDescSet descs = i.next();
            if (descs.isEmpty()) continue;
            offset = Math.min(offset, descs.getOffset());
            rightOffset = Math.max(rightOffset, descs.getRightOffset());
        }
        if (offset == -1 || rightOffset == -1) {
            return -1;
        }
        return rightOffset - offset;
    }

    @Override
    public int getRightOffset() {
        int result = -1;
        Iterator<IDescSet> i = this.descSetIterator();
        while (i.hasNext()) {
            IDescSet descs = i.next();
            if (descs.isEmpty()) continue;
            result = Math.max(result, descs.getRightOffset());
        }
        return result;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class DescriptionIterator
    implements Iterator<IDesc> {
        int total;
        int delivered = 0;
        protected IDescSet currentSet = null;
        protected Iterator<IDesc> currentItr = null;
        protected Iterator<Map.Entry<IRep, IDescSet>> masterItr;

        protected DescriptionIterator() {
            this.total = DescMultiSet.this.size();
            this.masterItr = DescMultiSet.this.repMap.entrySet().iterator();
        }

        @Override
        public boolean hasNext() {
            return this.delivered < this.total;
        }

        @Override
        public IDesc next() {
            if (this.currentItr == null) {
                this.loadNextIterator();
            } else if (!this.currentItr.hasNext()) {
                this.loadNextIterator();
            }
            if (this.currentItr == null) {
                throw new NoSuchElementException();
            }
            ++this.delivered;
            return this.currentItr.next();
        }

        protected void loadNextIterator() {
            if (this.masterItr.hasNext()) {
                IDescSet nextSet = this.masterItr.next().getValue();
                while (nextSet.isEmpty()) {
                    nextSet = this.masterItr.next().getValue();
                }
                this.currentSet = nextSet;
                this.currentItr = this.currentSet.iterator();
            }
        }

        @Override
        public void remove() {
            if (this.currentItr == null) {
                throw new IllegalStateException("next() not yet called");
            }
            this.currentItr.remove();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class DescriptionSetIterator
    extends MapIterator
    implements Iterator<IDescSet> {
        protected DescriptionSetIterator() {
        }

        @Override
        public IDescSet next() {
            this.last = this.next;
            this.next = this.getNext();
            return (IDescSet)this.last.getValue();
        }

        @Override
        public void remove() {
            if (this.last != null) {
                ((IDescSet)this.last.getValue()).clear();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class EntryIterator
    extends MapIterator
    implements Iterator<Map.Entry<IRep, IDescSet>> {
        protected EntryIterator() {
        }

        @Override
        public Map.Entry<IRep, IDescSet> next() {
            this.last = this.next;
            this.next = this.getNext();
            return this.last;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected abstract class MapIterator {
        Iterator<Map.Entry<IRep, IDescSet>> entryItr;
        Map.Entry<IRep, IDescSet> last = null;
        Map.Entry<IRep, IDescSet> next = null;

        protected MapIterator() {
            this.entryItr = DescMultiSet.this.repMap.entrySet().iterator();
            this.next = this.getNext();
        }

        public boolean hasNext() {
            return this.next != null;
        }

        protected Map.Entry<IRep, IDescSet> getNext() {
            while (this.entryItr.hasNext()) {
                Map.Entry<IRep, IDescSet> entry = this.entryItr.next();
                if (entry.getValue().isEmpty()) continue;
                return entry;
            }
            return null;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class RepresentationIterator
    extends MapIterator
    implements Iterator<IRep> {
        protected RepresentationIterator() {
        }

        @Override
        public IRep next() {
            this.last = this.next;
            this.next = this.getNext();
            return (IRep)this.last.getKey();
        }
    }
}

