/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.story.core.agreement;

import edu.mit.story.core.agreement.FMeasureResult;
import edu.mit.story.core.agreement.IAgreementCalculator;
import edu.mit.story.core.agreement.IAgreementResult;
import edu.mit.story.core.align.IAlignedStoryModel;
import edu.mit.story.core.align.IDescMap;
import edu.mit.story.core.descriptor.Registered;
import edu.mit.story.core.rep.IRep;
import edu.mit.story.core.rep.RepSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FMeasureCalculator
extends Registered
implements IAgreementCalculator {
    @Override
    public Set<IRep> getReps() {
        return Collections.emptySet();
    }

    @Override
    public List<IAgreementResult> calculate(IAlignedStoryModel model, Set<IRep> reps) {
        RepSet rs = new RepSet(reps);
        rs.retainAll(model.getData().getSupported());
        LinkedList<IAgreementResult> result = new LinkedList<IAgreementResult>();
        for (IRep rep : rs) {
            result.add(this.calculate(model, rep));
        }
        return new ArrayList<IAgreementResult>(result);
    }

    protected IAgreementResult calculate(IAlignedStoryModel model, IRep rep) {
        IDescMap descMap = model.get(rep);
        int inBoth = descMap.size();
        int inSourceOnly = descMap.getSource().size() - inBoth;
        int inTargetOnly = descMap.getTarget().size() - inBoth;
        return new FMeasureResult(model.getSourceName(), model.getTargetName(), inSourceOnly, inTargetOnly, inBoth, rep);
    }
}

