/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.story.core.agreement;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import edu.mit.story.core.agreement.IAgreementResult;
import edu.mit.story.core.descriptor.IHasName;
import edu.mit.story.core.rep.IRep;
import edu.mit.story.core.util.StringUtils;
import gnu.trove.map.TIntObjectMap;
import gnu.trove.map.TObjectIntMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import gnu.trove.map.hash.TObjectIntHashMap;
import gnu.trove.procedure.TIntObjectProcedure;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AgreementResult
implements IAgreementResult {
    private final String name;
    private final String value;
    private final IRep rep;
    private final List<IAgreementResult> children;
    protected static final String FILENAME_KEY = "Filename";

    public AgreementResult(String name, String value, IRep rep) {
        this(name, value, rep, (IAgreementResult[])null);
    }

    public AgreementResult(String name, String value, IRep rep, Collection<? extends IAgreementResult> children) {
        this(name, value, rep, children.toArray(new IAgreementResult[children.size()]));
    }

    public AgreementResult(String name, String value, IRep rep, IAgreementResult ... children) {
        List cs;
        if (name == null) {
            throw new NullPointerException();
        }
        if (value == null) {
            throw new NullPointerException();
        }
        if (rep == null) {
            throw new NullPointerException();
        }
        name = name.trim();
        value = value.trim();
        if (children == null) {
            cs = Collections.emptyList();
        } else {
            cs = new ArrayList(children.length);
            IAgreementResult[] iAgreementResultArray = children;
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                IAgreementResult child = iAgreementResultArray[n2];
                if (child == null) {
                    throw new NullPointerException();
                }
                if (child.getRep() != rep) {
                    throw new IllegalArgumentException();
                }
                cs.add(child);
                ++n2;
            }
            cs = Collections.unmodifiableList(cs);
        }
        this.name = name;
        this.value = value;
        this.rep = rep;
        this.children = cs;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public IRep getRep() {
        return this.rep;
    }

    @Override
    public String getValue() {
        return this.value;
    }

    @Override
    public List<IAgreementResult> getChildren() {
        return this.children;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.rep.getName());
        sb.append(' ');
        sb.append(this.name);
        sb.append(" = ");
        sb.append(this.value);
        for (IAgreementResult child : this.children) {
            sb.append('\n');
            sb.append(StringUtils.indent("\t", child.toString()));
        }
        return sb.toString();
    }

    public static String[][] convertToTable(Map<String, List<IAgreementResult>> results, HeaderStyle style) {
        if (style == null) {
            style = HeaderStyle.NONE;
        }
        switch (style) {
            case NONE: {
                return AgreementResult.convertToTableHeadersNone(results);
            }
            case LEFT_TOP: {
                return AgreementResult.convertToTableHeadersLeftTop(results);
            }
            case BOTTOM_RIGHT: {
                return AgreementResult.convertToTableHeadersBottomRight(results);
            }
        }
        throw new IllegalStateException();
    }

    public static String[][] convertToTableHeadersNone(Map<String, List<IAgreementResult>> results) {
        TObjectIntHashMap indexMap = new TObjectIntHashMap(10, 0.5f, -1);
        TIntObjectHashMap headerRepName = new TIntObjectHashMap();
        TIntObjectHashMap headerRepID = new TIntObjectHashMap();
        TIntObjectHashMap headerName = new TIntObjectHashMap();
        LinkedList<Map<String, String>> rows = new LinkedList<Map<String, String>>();
        for (Map.Entry<String, List<IAgreementResult>> e : results.entrySet()) {
            rows.add(AgreementResult.makeRow(e.getKey(), e.getValue(), (TIntObjectMap<String>)headerRepName, (TIntObjectMap<String>)headerRepID, (TIntObjectMap<String>)headerName, (TObjectIntMap<String>)indexMap));
        }
        indexMap.put((Object)FILENAME_KEY, -1);
        String[][] result = new String[rows.size()][indexMap.size() - 1];
        int rowIdx = 0;
        for (Map map : rows) {
            AgreementResult.addRowToTable(result[rowIdx++], map, (TObjectIntMap<String>)indexMap);
        }
        return result;
    }

    public static String[][] convertToTableHeadersLeftTop(Map<String, List<IAgreementResult>> results) {
        TObjectIntHashMap indexMap = new TObjectIntHashMap(10, 0.5f, -1);
        TIntObjectHashMap headerRepName = new TIntObjectHashMap();
        TIntObjectHashMap headerRepID = new TIntObjectHashMap();
        TIntObjectHashMap headerName = new TIntObjectHashMap();
        headerRepName.put(0, (Object)"Representation");
        headerRepID.put(0, (Object)"RepID");
        headerName.put(0, (Object)FILENAME_KEY);
        indexMap.put((Object)FILENAME_KEY, 0);
        LinkedList<Map<String, String>> rows = new LinkedList<Map<String, String>>();
        for (Map.Entry<String, List<IAgreementResult>> e : results.entrySet()) {
            rows.add(AgreementResult.makeRow(e.getKey(), e.getValue(), (TIntObjectMap<String>)headerRepName, (TIntObjectMap<String>)headerRepID, (TIntObjectMap<String>)headerName, (TObjectIntMap<String>)indexMap));
        }
        String[][] result = new String[rows.size() + 3][indexMap.size()];
        int rowIdx = 0;
        AgreementResult.addRowToTable(result[rowIdx++], (TIntObjectMap<String>)headerRepName);
        AgreementResult.addRowToTable(result[rowIdx++], (TIntObjectMap<String>)headerRepID);
        AgreementResult.addRowToTable(result[rowIdx++], (TIntObjectMap<String>)headerName);
        for (Map map : rows) {
            AgreementResult.addRowToTable(result[rowIdx++], map, (TObjectIntMap<String>)indexMap);
        }
        return result;
    }

    public static String[][] convertToTableHeadersBottomRight(Map<String, List<IAgreementResult>> results) {
        TObjectIntHashMap indexMap = new TObjectIntHashMap(10, 0.5f, -1);
        TIntObjectHashMap headerRepName = new TIntObjectHashMap();
        TIntObjectHashMap headerRepID = new TIntObjectHashMap();
        TIntObjectHashMap headerName = new TIntObjectHashMap();
        LinkedList<Map<String, String>> rows = new LinkedList<Map<String, String>>();
        for (Map.Entry<String, List<IAgreementResult>> e : results.entrySet()) {
            rows.add(AgreementResult.makeRow(e.getKey(), e.getValue(), (TIntObjectMap<String>)headerRepName, (TIntObjectMap<String>)headerRepID, (TIntObjectMap<String>)headerName, (TObjectIntMap<String>)indexMap));
        }
        int lastIdx = indexMap.size();
        headerRepName.put(lastIdx, (Object)"Representation");
        headerRepID.put(lastIdx, (Object)"RepID");
        headerName.put(lastIdx, (Object)FILENAME_KEY);
        indexMap.put((Object)FILENAME_KEY, lastIdx);
        String[][] result = new String[rows.size() + 3][indexMap.size()];
        int rowIdx = 0;
        for (Map map : rows) {
            AgreementResult.addRowToTable(result[rowIdx++], map, (TObjectIntMap<String>)indexMap);
        }
        AgreementResult.addRowToTable(result[rowIdx++], (TIntObjectMap<String>)headerName);
        AgreementResult.addRowToTable(result[rowIdx++], (TIntObjectMap<String>)headerRepID);
        AgreementResult.addRowToTable(result[rowIdx++], (TIntObjectMap<String>)headerRepName);
        return result;
    }

    protected static Map<String, String> makeRow(String filename, List<IAgreementResult> results, TIntObjectMap<String> headerRepName, TIntObjectMap<String> headerRepID, TIntObjectMap<String> headerName, TObjectIntMap<String> indexMap) {
        HashMap<String, String> row = new HashMap<String, String>();
        row.put(FILENAME_KEY, filename);
        HashSet<String> keys = new HashSet<String>();
        for (IAgreementResult result : results) {
            AgreementResult.addRepToRow(result, row, headerRepName, headerRepID, headerName, indexMap, keys);
        }
        return row;
    }

    protected static void addRepToRow(IAgreementResult result, Map<String, String> row, TIntObjectMap<String> headerRepName, TIntObjectMap<String> headerRepID, TIntObjectMap<String> headerName, TObjectIntMap<String> indexMap, Set<String> keys) {
        LinkedList<IAgreementResult> path = new LinkedList<IAgreementResult>();
        path.add(result);
        int maybeStartNewColumn = indexMap.size();
        headerRepName.put(maybeStartNewColumn, (Object)result.getRep().getName());
        for (IAgreementResult child : result.getChildren()) {
            AgreementResult.addMeasureToRow(child, row, headerRepID, headerName, indexMap, path, keys);
        }
        if (indexMap.size() == maybeStartNewColumn) {
            headerRepName.remove(maybeStartNewColumn);
        }
    }

    protected static void addMeasureToRow(IAgreementResult result, Map<String, String> row, TIntObjectMap<String> headerRepID, TIntObjectMap<String> headerName, TObjectIntMap<String> indexMap, LinkedList<IAgreementResult> path, Set<String> keys) {
        path.add(result);
        String key = AgreementResult.makeKey(path, keys);
        int idx = indexMap.get((Object)key);
        if (idx == -1) {
            idx = indexMap.size();
            indexMap.put((Object)key, idx);
        }
        String currValue = (String)headerRepID.get(idx);
        String assumedValue = result.getRep().getID();
        if (currValue == null) {
            headerRepID.put(idx, (Object)assumedValue);
        } else if (!currValue.equals(assumedValue)) {
            throw new IllegalArgumentException("entries disagree in agreement result table repID header at index " + idx + ": current=" + currValue + ", assumed=" + assumedValue);
        }
        currValue = (String)headerName.get(idx);
        assumedValue = AgreementResult.makeName(key, path.get(0));
        if (currValue == null) {
            headerName.put(idx, (Object)assumedValue);
        } else if (!currValue.equals(assumedValue)) {
            throw new IllegalArgumentException("entries disagree in agreement result table name header at index " + idx + ": current=" + currValue + ", assumed=" + assumedValue);
        }
        if (row.put(key, result.getValue()) != null) {
            throw new IllegalArgumentException("entry replaced in agreement result table at index " + idx);
        }
        for (IAgreementResult child : result.getChildren()) {
            AgreementResult.addMeasureToRow(child, row, headerRepID, headerName, indexMap, path, keys);
        }
        path.removeLast();
    }

    protected static void addRowToTable(final String[] rowArray, TIntObjectMap<String> row) {
        Arrays.fill(rowArray, "");
        row.forEachEntry((TIntObjectProcedure)new TIntObjectProcedure<String>(){

            public boolean execute(int idx, String val) {
                rowArray[idx] = val;
                return true;
            }
        });
    }

    protected static void addRowToTable(String[] rowArray, Map<String, String> row, TObjectIntMap<String> indexMap) {
        Arrays.fill(rowArray, "");
        for (Map.Entry<String, String> e : row.entrySet()) {
            int idx = indexMap.get((Object)e.getKey());
            if (idx <= -1) continue;
            rowArray[idx] = e.getValue();
        }
    }

    protected static String makeKey(List<IAgreementResult> path, Set<String> keys) {
        String newKey;
        List names = Lists.transform(path, (Function)new Function<IAgreementResult, String>(){

            public String apply(IAgreementResult input) {
                return input.getName();
            }
        });
        String key = Joiner.on((char)':').join((Iterable)names);
        if (keys.add(key)) {
            return key;
        }
        int i = 1;
        while (!keys.add(newKey = String.valueOf(key) + Integer.toString(++i))) {
        }
        return newKey;
    }

    protected static String makeName(String key, IAgreementResult result) {
        int start = result.getName().length() + 1;
        return key.substring(start, key.length());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum HeaderStyle implements IHasName
    {
        LEFT_TOP("Left/Top"),
        BOTTOM_RIGHT("Bottom/Right"),
        NONE("No Header");

        private final String name;

        private HeaderStyle(String name) {
            if (name.trim().length() == 0) {
                throw new IllegalArgumentException();
            }
            this.name = name;
        }

        @Override
        public String getName() {
            return this.name;
        }
    }
}

