/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.semantics.ui.dialogs;

import edu.mit.jpropbank.frames.IExample;
import edu.mit.jpropbank.frames.IExampleArg;
import edu.mit.jpropbank.frames.IRole;
import edu.mit.jpropbank.frames.IRoleset;
import edu.mit.semantics.core.SemanticsPlugin;
import edu.mit.semantics.ui.SemanticsUIPlugin;
import edu.mit.semantics.ui.content.RoleSetContentProvider;
import edu.mit.semantics.ui.label.RoleSetLabelProvider;
import edu.mit.semantics.ui.label.RolesetDisplayLabelProvider;
import edu.mit.semantics.ui.label.RolesetExampleLabelProvider;
import edu.mit.story.ui.StoryUIPlugin;
import edu.mit.story.ui.actions.SelectionUtils;
import edu.mit.story.ui.viewers.StyledTextViewer;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.FilteredItemsSelectionDialog;

public class RolesetSelectionDialog
extends FilteredItemsSelectionDialog {
    private static final String DIALOG_SETTINGS = RolesetSelectionDialog.class.getCanonicalName();
    private Comparator itemComparator;
    private final boolean chooseRoleset;
    protected IRole initialRole = null;
    protected StyledTextViewer exampleViewer;
    protected ListViewer roleViewer;

    protected void computeResult() {
        if (this.chooseRoleset) {
            super.computeResult();
            return;
        }
        IStructuredSelection ssel = SelectionUtils.castAsStructuredSelection((ISelection)this.roleViewer.getSelection());
        this.setResult(ssel.toList());
    }

    public RolesetSelectionDialog(Shell parent, boolean chooseRoleset) {
        super(parent);
        this.setTitle(chooseRoleset ? "Select Roleset" : "Select Role");
        this.setMessage("Enter a string by which to filter (? = any character, * = any string):");
        this.chooseRoleset = chooseRoleset;
        this.setListLabelProvider((ILabelProvider)RoleSetLabelProvider.getInstance());
        this.setDetailsLabelProvider((ILabelProvider)RoleSetLabelProvider.getInstance());
    }

    protected void setInitialSelection(IRoleset roleset) {
        this.setInitialElementSelections(Collections.singletonList(roleset));
    }

    protected void setInitialSelection(IRole role) {
        this.setInitialElementSelections(Collections.singletonList(role.getRoleset()));
        this.initialRole = role;
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        SashForm horzSash = new SashForm(dialogArea, 256);
        horzSash.setLayoutData((Object)new GridData(4, 4, true, true));
        Composite control = (Composite)dialogArea.getChildren()[0];
        control.setParent((Composite)horzSash);
        SashForm vertSash = new SashForm((Composite)horzSash, 512);
        Composite roles = new Composite((Composite)vertSash, 0);
        roles.setLayout((Layout)new GridLayout());
        Label label = new Label(roles, 0);
        label.setText(" ");
        label = new Label(roles, 0);
        label.setText("Roles:");
        this.roleViewer = new ListViewer(roles, 2816);
        this.roleViewer.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
        this.roleViewer.getControl().setBackground(StoryUIPlugin.getDefault().getColorManager().get((Object)"WHITE"));
        this.roleViewer.setContentProvider((IContentProvider)RoleSetContentProvider.getInstance());
        this.roleViewer.setLabelProvider((IBaseLabelProvider)new RolesetDisplayLabelProvider());
        Composite examples = new Composite((Composite)vertSash, 0);
        examples.setLayout((Layout)new GridLayout());
        label = new Label(examples, 0);
        label.setText("Examples:");
        this.exampleViewer = new StyledTextViewer(examples, 2816);
        this.exampleViewer.getControl().setEditable(false);
        this.exampleViewer.getControl().setWordWrap(true);
        this.exampleViewer.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
        this.exampleViewer.getControl().setBackground(StoryUIPlugin.getDefault().getColorManager().get((Object)"WHITE"));
        this.exampleViewer.setLabelProvider((DelegatingStyledCellLabelProvider.IStyledLabelProvider)new RolesetExampleLabelProvider());
        vertSash.setWeights(new int[]{1, 2});
        return dialogArea;
    }

    protected void handleSelected(StructuredSelection selection) {
        super.handleSelected(selection);
        IRoleset roleset = (IRoleset)SelectionUtils.extractSingle((ISelection)selection, IRoleset.class);
        if (roleset != null) {
            this.roleViewer.setInput((Object)roleset);
            IRole selRole = null;
            if (!roleset.getRoles().isEmpty()) {
                selRole = (IRole)roleset.getRoles().get(0);
            }
            if (this.initialRole != null) {
                selRole = this.initialRole;
                this.initialRole = null;
            }
            StructuredSelection roleSel = selRole == null ? StructuredSelection.EMPTY : new StructuredSelection((Object)selRole);
            this.roleViewer.setSelection((ISelection)roleSel);
            this.exampleViewer.setInput((Object)roleset);
        }
    }

    protected Control createExtendedContentArea(Composite parent) {
        return null;
    }

    protected void fillContentProvider(FilteredItemsSelectionDialog.AbstractContentProvider cp, FilteredItemsSelectionDialog.ItemsFilter itemsFilter, IProgressMonitor pm) throws CoreException {
        Collection rolesets = SemanticsPlugin.getDefault().getFrameManager().getRoleSets().values();
        pm.beginTask("Searching...", rolesets.size());
        for (IRoleset roleset : rolesets) {
            cp.add((Object)roleset, itemsFilter);
            pm.worked(1);
        }
        pm.done();
    }

    public String getElementName(Object item) {
        if (item instanceof IRoleset) {
            IRoleset roles = (IRoleset)item;
            StringBuilder sb = new StringBuilder();
            sb.append(roles.getLemma());
            sb.append(" - ");
            sb.append(roles.getName());
            sb.append(" (");
            sb.append(roles.getID());
            sb.append(')');
            return sb.toString();
        }
        throw new IllegalArgumentException();
    }

    protected IStatus validateItem(Object item) {
        return Status.OK_STATUS;
    }

    protected FilteredItemsSelectionDialog.ItemsFilter createFilter() {
        return new RolesetFilter();
    }

    protected Comparator getItemsComparator() {
        if (this.itemComparator == null) {
            this.itemComparator = new RolesetComparator();
        }
        return this.itemComparator;
    }

    protected IDialogSettings getDialogSettings() {
        IDialogSettings settings = SemanticsUIPlugin.getDefault().getDialogSettings().getSection(DIALOG_SETTINGS);
        if (settings == null) {
            settings = SemanticsUIPlugin.getDefault().getDialogSettings().addNewSection(DIALOG_SETTINGS);
        }
        return settings;
    }

    public static IRoleset selectRoleset(Shell shell, IRoleset initial, String pattern) {
        int code;
        RolesetSelectionDialog dialog = new RolesetSelectionDialog(shell, true);
        dialog.setBlockOnOpen(true);
        if (initial != null) {
            dialog.setInitialSelection(initial);
        }
        if (pattern != null) {
            dialog.setInitialPattern(pattern, 2);
        }
        if ((code = dialog.open()) == 1) {
            return null;
        }
        Object[] result = dialog.getResult();
        if (result == null || result.length == 0) {
            return null;
        }
        return (IRoleset)result[0];
    }

    public static IRoleset selectRoleset(Shell shell, IRoleset initial) {
        return RolesetSelectionDialog.selectRoleset(shell, initial, null);
    }

    public static IRole selectRole(Shell shell, IRole initial) {
        return RolesetSelectionDialog.selectRole(shell, initial, null);
    }

    public static IRole selectRole(Shell shell, IRole initial, String pattern) {
        int code;
        RolesetSelectionDialog dialog = new RolesetSelectionDialog(shell, false);
        dialog.setBlockOnOpen(true);
        if (initial != null) {
            dialog.setInitialSelection(initial);
        }
        if (pattern != null) {
            dialog.setInitialPattern(pattern, 2);
        }
        if ((code = dialog.open()) == 1) {
            return null;
        }
        Object[] result = dialog.getResult();
        if (result == null || result.length == 0) {
            return null;
        }
        return (IRole)result[0];
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class RolesetComparator
    implements Comparator<IRoleset> {
        protected RolesetComparator() {
        }

        @Override
        public int compare(IRoleset o1, IRoleset o2) {
            return o1.getID().compareTo(o2.getID());
        }
    }

    protected class RolesetFilter
    extends FilteredItemsSelectionDialog.ItemsFilter {
        public RolesetFilter() {
            super((FilteredItemsSelectionDialog)RolesetSelectionDialog.this);
            String pattern = this.patternMatcher.getPattern();
            if (!pattern.startsWith("*")) {
                this.patternMatcher.setPattern("*" + pattern);
            }
        }

        public boolean matchItem(Object item) {
            if (item instanceof IRoleset) {
                IRoleset roles = (IRoleset)item;
                if (this.patternMatcher.matches(roles.getLemma())) {
                    return true;
                }
                if (this.patternMatcher.matches(roles.getName())) {
                    return true;
                }
                if (this.patternMatcher.matches(roles.getID())) {
                    return true;
                }
                for (IRole role : roles.getRoles()) {
                    if (!this.patternMatcher.matches(role.getDescription())) continue;
                    return true;
                }
                for (IExample ex : roles.getExamples()) {
                    for (IExampleArg arg : ex.getArguments()) {
                        if (this.patternMatcher.matches(arg.getLabel())) {
                            return true;
                        }
                        if (!this.patternMatcher.matches(arg.getFeature())) continue;
                        return true;
                    }
                }
            }
            return false;
        }

        public boolean isConsistentItem(Object item) {
            return false;
        }
    }
}

