/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.discourse.ui.relation;

import edu.mit.discourse.core.rep.relation.IAdjunct;
import edu.mit.story.core.align.IAlignedStoryModel;
import edu.mit.story.core.desc.IData;
import edu.mit.story.core.desc.IDesc;
import edu.mit.story.core.desc.ISegment;
import edu.mit.story.core.desc.IStructuredData;
import edu.mit.story.core.desc.Segment;
import edu.mit.story.core.model.IStoryData;
import edu.mit.story.core.model.IStoryModel;
import edu.mit.story.core.position.HasPositionSet;
import edu.mit.story.core.position.IHasPosition;
import edu.mit.story.core.position.IHasPositionSet;
import edu.mit.story.core.util.IClearable;
import java.util.ArrayList;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AdjunctProxy
implements IAdjunct,
IClearable {
    public static final String unsetText = "?";
    boolean makeReferent = false;
    String displayText;
    final IHasPositionSet<ISegment> tokenSegments = new HasPositionSet();

    public AdjunctProxy(Collection<ISegment> tokenSegments, boolean makeReferent, IStoryData data) {
        for (ISegment segment : tokenSegments) {
            this.tokenSegments.add((Object)new Segment((IHasPosition)segment, segment.getRep(), data));
        }
        this.displayText = this.generateText(data);
        this.makeReferent = makeReferent;
    }

    public void load(AdjunctProxy proxy, IStoryData data) {
        this.clear();
        this.displayText = unsetText;
        if (proxy != null) {
            this.tokenSegments.addAll(proxy.tokenSegments);
            this.displayText = this.generateText(data);
        }
    }

    public IHasPositionSet<ISegment> getTokenSegments() {
        return this.tokenSegments;
    }

    public String getDisplayText() {
        return this.displayText;
    }

    protected String generateText(IStoryData data) {
        if (this.tokenSegments.isEmpty()) {
            return unsetText;
        }
        return Segment.generateText(this.tokenSegments);
    }

    public IHasPositionSet<ISegment> getSegments() {
        throw new UnsupportedOperationException();
    }

    public IAdjunct clone() {
        throw new UnsupportedOperationException();
    }

    public int getLength() {
        throw new UnsupportedOperationException();
    }

    public int getOffset() {
        throw new UnsupportedOperationException();
    }

    public int getRightOffset() {
        throw new UnsupportedOperationException();
    }

    public IHasPosition calculatePosition() {
        throw new UnsupportedOperationException();
    }

    public void setMakeReferent(boolean value) {
        this.makeReferent = value;
    }

    public boolean shouldMakeReferent() {
        return this.makeReferent;
    }

    public IHasPosition getDisplayPosition() {
        return this.calculatePosition();
    }

    public IStructuredData recalculate(IDesc container, IStoryModel provider) {
        throw new UnsupportedOperationException();
    }

    public boolean equals(IData tgtData, IAlignedStoryModel model) {
        throw new UnsupportedOperationException();
    }

    public void clear() {
        this.displayText = unsetText;
        this.makeReferent = false;
        this.tokenSegments.clear();
    }

    public boolean isCleared() {
        return !this.makeReferent && this.displayText == unsetText && this.tokenSegments.isEmpty();
    }

    public static AdjunctProxy convert(IAdjunct adj, IStoryData data) {
        ArrayList<ISegment> segments = new ArrayList<ISegment>(adj.getSegments().size());
        for (ISegment segment : adj.getSegments()) {
            segments.add(segment);
        }
        return new AdjunctProxy(segments, false, data);
    }
}

