/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.util;

import java.util.AbstractMap;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ArrayMap<K, V>
extends AbstractMap<K, V> {
    Map.Entry[] entryArray;
    int capacity;
    int size;
    protected int hashCodeCache = 0;

    public ArrayMap() {
        this.size = 0;
        this.capacity = 2;
        this.entryArray = new Map.Entry[2];
    }

    public ArrayMap(int capacity) {
        this.size = 0;
        this.capacity = capacity;
        this.entryArray = new Map.Entry[capacity];
    }

    public ArrayMap(Map<? extends K, ? extends V> m) {
        this.size = 0;
        this.capacity = m.size();
        this.entryArray = new Map.Entry[m.size()];
        this.putAll(m);
    }

    public ArrayMap(K[] keys, V[] values) {
        if (keys.length != values.length) {
            throw new IllegalArgumentException("different number of keys and values.");
        }
        this.capacity = this.size = keys.length;
        this.entryArray = new Map.Entry[this.size];
        for (int i = 0; i < keys.length; ++i) {
            this.entryArray[i] = new Entry<K, V>(keys[i], values[i]);
        }
    }

    @Override
    public Set entrySet() {
        return new HashSet<Map.Entry>(Arrays.asList(this.entryArray).subList(0, this.size));
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    private void resize() {
        Map.Entry[] oldEntryArray = this.entryArray;
        int newCapacity = 2 * this.size;
        if (newCapacity == 0) {
            newCapacity = 1;
        }
        this.entryArray = new Map.Entry[newCapacity];
        System.arraycopy(oldEntryArray, 0, this.entryArray, 0, this.size);
        this.capacity = newCapacity;
    }

    @Override
    public V put(K key, V val) {
        for (int i = 0; i < this.size; ++i) {
            if (!key.equals(this.entryArray[i].getKey())) continue;
            return this.entryArray[i].setValue(val);
        }
        if (this.capacity <= this.size) {
            this.resize();
        }
        this.entryArray[this.size] = new Entry<K, V>(key, val);
        ++this.size;
        return null;
    }

    @Override
    public V get(Object key) {
        for (int i = 0; i < this.size; ++i) {
            if (!(key == null ? this.entryArray[i].getKey() == null : key.equals(this.entryArray[i].getKey()))) continue;
            return this.entryArray[i].getValue();
        }
        return null;
    }

    @Override
    public V remove(Object key) {
        for (int i = 0; i < this.size; ++i) {
            if (!(key == null ? this.entryArray[i].getKey() == null : key.equals(this.entryArray[i].getKey()))) continue;
            Object value = this.entryArray[i].getValue();
            if (this.size > 1) {
                this.entryArray[i] = this.entryArray[this.size - 1];
            }
            --this.size;
            return value;
        }
        return null;
    }

    @Override
    public int hashCode() {
        if (this.hashCodeCache == 0) {
            int hashCode = 0;
            for (int i = 0; i < this.size; ++i) {
                hashCode += ((Object)this.entryArray[i]).hashCode();
            }
            this.hashCodeCache = hashCode;
        }
        return this.hashCodeCache;
    }

    @Override
    public boolean equals(Object o) {
        Map m = (Map)o;
        for (int i = 0; i < this.size; ++i) {
            Object mVal = m.get(this.entryArray[i].getKey());
            if (!(mVal == null ? this.entryArray[i] != null : !m.get(this.entryArray[i].getKey()).equals(this.entryArray[i].getValue()))) continue;
            return false;
        }
        return true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class Entry<K, V>
    implements Map.Entry<K, V> {
        K key;
        V value;

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public V setValue(V o) {
            V old = this.value;
            this.value = o;
            return old;
        }

        @Override
        public int hashCode() {
            return (this.getKey() == null ? 0 : this.getKey().hashCode()) ^ (this.getValue() == null ? 0 : this.getValue().hashCode());
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Entry)) {
                return false;
            }
            return (this.getKey() == null ? ((Entry)o).getKey() == null : this.getKey().equals(((Entry)o).getKey())) && (this.getValue() == null ? ((Entry)o).getValue() == null : this.getValue().equals(((Entry)o).getValue()));
        }

        Entry(K key, V value) {
            this.key = key;
            this.value = value;
        }
    }
}

