/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.trees.international.negra;

import edu.stanford.nlp.ling.Label;
import edu.stanford.nlp.ling.LabelFactory;
import edu.stanford.nlp.ling.StringLabel;
import java.util.HashMap;
import java.util.Map;

public class NegraLabel
extends StringLabel {
    public static final String FEATURE_SEP = "#";
    private String edge;
    private Map features;

    public LabelFactory labelFactory() {
        return new NegraLabelFactory();
    }

    public void setEdge(String edge) {
        this.edge = edge;
    }

    public String getEdge() {
        return this.edge;
    }

    private NegraLabel() {
    }

    public NegraLabel(String str) {
        this(str, new HashMap());
    }

    public NegraLabel(String str, Map features) {
        this(str, null, features);
    }

    public NegraLabel(String str, String edge, Map features) {
        super(str);
        this.edge = edge;
        this.features = features;
    }

    public void setFeatureValue(String feature, String value) {
        this.features.put(feature, value);
    }

    public String featureValue(String feature) {
        return (String)this.features.get(feature);
    }

    public String toString() {
        String str = this.value();
        if (this.edge != null) {
            str = str + "->" + this.getEdge();
        }
        str = str + "." + this.features.toString();
        return str;
    }

    private static class NegraLabelFactory
    implements LabelFactory {
        private NegraLabelFactory() {
        }

        public Label newLabel(String labelStr) {
            return new NegraLabel(labelStr);
        }

        public Label newLabel(String labelStr, int options) {
            return this.newLabel(labelStr);
        }

        public Label newLabelFromString(String encodedLabelStr) {
            return this.newLabel(encodedLabelStr);
        }

        public Label newLabel(Label oldLabel) {
            NegraLabel result;
            if (oldLabel instanceof NegraLabel) {
                NegraLabel l = (NegraLabel)oldLabel;
                result = new NegraLabel(l.value(), l.getEdge(), new HashMap());
                for (Map.Entry e : l.features.entrySet()) {
                    result.features.put(e.getKey(), e.getValue());
                }
            } else {
                result = new NegraLabel(oldLabel.value());
            }
            return result;
        }
    }
}

