/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.trees;

import edu.stanford.nlp.ling.Label;
import edu.stanford.nlp.ling.LabelFactory;
import edu.stanford.nlp.ling.Sentence;
import edu.stanford.nlp.ling.StringLabel;
import edu.stanford.nlp.ling.TaggedWord;
import edu.stanford.nlp.ling.Word;
import edu.stanford.nlp.trees.LabeledScoredTreeFactory;
import edu.stanford.nlp.trees.LabeledScoredTreeLeaf;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.TreeFactory;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class LabeledScoredTreeNode
extends Tree {
    private Label label;
    private double score = Double.NaN;
    private Tree[] daughterTrees;
    private static NumberFormat nf = new DecimalFormat("0.000");

    public LabeledScoredTreeNode() {
    }

    public LabeledScoredTreeNode(Label label, List daughterTreesList) {
        this.label = label;
        this.setChildren(daughterTreesList);
    }

    public Tree[] children() {
        return this.daughterTrees;
    }

    public void setChildren(Tree[] children) {
        if (children == null) {
            System.err.println("Warning -- you tried to set the children of a LabeledScoredTreeNode to null.\nYou really should be using a zero-length array instead.\nConsider building a LabeledScoredTreeLeaf instead.");
            this.daughterTrees = ZEROCHILDREN;
        } else {
            this.daughterTrees = children;
        }
    }

    public Label label() {
        return this.label;
    }

    public void setLabel(Label label) {
        this.label = label;
    }

    public double score() {
        return this.score;
    }

    public void setScore(double score) {
        this.score = score;
    }

    public StringBuffer toStringBuffer(StringBuffer sb) {
        sb.append("(");
        sb.append(this.nodeString());
        for (int i = 0; i < this.daughterTrees.length; ++i) {
            sb.append(" ");
            this.daughterTrees[i].toStringBuffer(sb);
        }
        return sb.append(")");
    }

    public static Tree flatTree(Sentence s) {
        ArrayList<LabeledScoredTreeLeaf> daughters = new ArrayList<LabeledScoredTreeLeaf>(s.length());
        for (Word word : s) {
            Tree wordNode = new LabeledScoredTreeLeaf(new StringLabel(word.word()));
            if (word instanceof TaggedWord) {
                TaggedWord taggedWord = (TaggedWord)word;
                wordNode = new LabeledScoredTreeNode(new StringLabel(taggedWord.tag()), Collections.singletonList(wordNode));
            } else {
                wordNode = new LabeledScoredTreeNode(new StringLabel("WD"), Collections.singletonList(wordNode));
            }
            daughters.add((LabeledScoredTreeLeaf)wordNode);
        }
        return new LabeledScoredTreeNode(new StringLabel("S"), daughters);
    }

    public TreeFactory treeFactory() {
        LabelFactory lf = this.label() != null ? this.label().labelFactory() : StringLabel.factory();
        return new LabeledScoredTreeFactory(lf);
    }

    public static TreeFactory factory() {
        return TreeFactoryHolder.tf;
    }

    public static TreeFactory factory(LabelFactory lf) {
        return new LabeledScoredTreeFactory(lf);
    }

    public String nodeString() {
        StringBuffer buff = new StringBuffer();
        buff.append(super.nodeString());
        if (!Double.isNaN(this.score)) {
            buff.append(" [" + nf.format(-this.score) + "]");
        }
        return buff.toString();
    }

    private static class TreeFactoryHolder {
        static final TreeFactory tf = new LabeledScoredTreeFactory();

        private TreeFactoryHolder() {
        }
    }
}

