/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.trees;

import edu.stanford.nlp.trees.PennTreebankLanguagePack;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.TreeTransformer;
import edu.stanford.nlp.trees.TreebankLanguagePack;
import edu.stanford.nlp.trees.tregex.TregexPattern;
import edu.stanford.nlp.trees.tregex.tsurgeon.Tsurgeon;
import edu.stanford.nlp.trees.tregex.tsurgeon.TsurgeonPattern;
import edu.stanford.nlp.util.Pair;
import java.util.ArrayList;
import java.util.regex.Pattern;

public class DependencyTreeTransformer
implements TreeTransformer {
    private Pattern NPTmpPattern = Pattern.compile("NP.*-TMP.*");
    private static final Pattern NPAdvPattern = Pattern.compile("NP.*-ADV.*");
    protected final TreebankLanguagePack tlp = new PennTreebankLanguagePack();

    public Tree transformTree(Tree t) {
        t.setValue(this.cleanUpRoot(t.value()));
        this.stripTag(t, t);
        Tree tt = this.stripEmptyNode(t);
        return tt;
    }

    protected String cleanUpRoot(String label) {
        if (label == null || label == "TOP") {
            return "ROOT";
        }
        return label;
    }

    protected String cleanUpLabel(String label) {
        boolean nptemp = this.NPTmpPattern.matcher(label).matches();
        boolean npadv = NPAdvPattern.matcher(label).matches();
        label = this.tlp.basicCategory(label);
        if (nptemp) {
            label = label + "-TMP";
        } else if (npadv) {
            label = label + "-ADV";
        }
        return label;
    }

    protected void stripTag(Tree t, Tree root) {
        String label = this.cleanUpLabel(t.value());
        t.setValue(label);
        for (Tree child : t.getChildrenAsList()) {
            this.stripTag(child, root);
        }
    }

    protected Tree stripEmptyNode(Tree t) {
        ArrayList<Pair<TregexPattern, TsurgeonPattern>> ops = new ArrayList<Pair<TregexPattern, TsurgeonPattern>>();
        String patternMatch = "-NONE-=none";
        String operation = "prune none";
        TregexPattern matchPattern = null;
        try {
            matchPattern = TregexPattern.compile(patternMatch);
        }
        catch (Exception e) {
            System.err.println("Error compiling match pattern");
        }
        TsurgeonPattern p = Tsurgeon.parseOperation(operation);
        ops.add(new Pair<TregexPattern, TsurgeonPattern>(matchPattern, p));
        Tree result = Tsurgeon.processPatternsOnTree(ops, t);
        return result;
    }
}

