/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.trees;

import edu.stanford.nlp.ling.Label;
import edu.stanford.nlp.trees.PennTreebankLanguagePack;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.TreeFactory;
import edu.stanford.nlp.trees.TreeNormalizer;
import edu.stanford.nlp.trees.TreebankLanguagePack;
import edu.stanford.nlp.util.Filter;

public class BobChrisTreeNormalizer
extends TreeNormalizer {
    protected final TreebankLanguagePack tlp;

    public BobChrisTreeNormalizer() {
        this(new PennTreebankLanguagePack());
    }

    public BobChrisTreeNormalizer(TreebankLanguagePack tlp) {
        this.tlp = tlp;
    }

    public String normalizeTerminal(String leaf) {
        return leaf.intern();
    }

    public String normalizeNonterminal(String category) {
        return this.cleanUpLabel(category).intern();
    }

    public Tree normalizeWholeTree(Tree tree, TreeFactory tf) {
        return tree.prune(new Filter(){

            public boolean accept(Object obj) {
                Tree t = (Tree)obj;
                Tree[] kids = t.children();
                Label l = t.label();
                return l == null || l.value() == null || !l.value().equals("-NONE-") || t.isLeaf() || kids.length != 1 || !kids[0].isLeaf();
            }
        }, tf).spliceOut(new Filter(){

            public boolean accept(Object obj) {
                Tree t = (Tree)obj;
                if (t.isLeaf() || t.isPreTerminal() || t.children().length != 1) {
                    return true;
                }
                if ("EDITED".equals(t.label().value())) {
                    return false;
                }
                return t.label() == null || !t.label().equals(t.children()[0].label());
            }
        }, tf);
    }

    protected String cleanUpLabel(String label) {
        label = label == null ? "ROOT" : this.tlp.basicCategory(label);
        return label;
    }
}

