/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.parser.lexparser;

import java.util.regex.Pattern;

class ArabicUnknownWordSignatures {
    private static Pattern adjectivalSuffixPattern = Pattern.compile("yy[n]?$");
    private static Pattern singularPastTenseSuffixPattern = Pattern.compile("t$");
    private static Pattern pluralFirstPersonPastTenseSuffixPattern = Pattern.compile("nA$");
    private static Pattern pluralThirdPersonMasculinePastTenseSuffixPattern = Pattern.compile("w$");
    private static Pattern pluralThirdPersonMasculinePresentTenseSuffixPattern = Pattern.compile("wn$");
    private static Pattern taaMarbuuTaSuffixPattern = Pattern.compile("p$");
    private static Pattern abstractionNounSuffixPattern = Pattern.compile("yp$");

    ArabicUnknownWordSignatures() {
    }

    static boolean allDigitPlus(String word) {
        boolean allDigitPlus = true;
        boolean seenDigit = false;
        int wlen = word.length();
        for (int i = 0; i < wlen; ++i) {
            char ch = word.charAt(i);
            if (Character.isDigit(ch)) {
                seenDigit = true;
                continue;
            }
            if (ch == '-' || ch == '.' || ch == ',') continue;
            allDigitPlus = false;
        }
        return allDigitPlus && seenDigit;
    }

    static String likelyAdjectivalSuffix(String word) {
        if (adjectivalSuffixPattern.matcher(word).find()) {
            return "-AdjSuffix";
        }
        return "";
    }

    static String pastTenseVerbNumberSuffix(String word) {
        if (singularPastTenseSuffixPattern.matcher(word).find()) {
            return "-PV.sg";
        }
        if (pluralFirstPersonPastTenseSuffixPattern.matcher(word).find()) {
            return "-PV.pl1";
        }
        if (pluralThirdPersonMasculinePastTenseSuffixPattern.matcher(word).find()) {
            return "-PV.pl3m";
        }
        return "";
    }

    static String presentTenseVerbNumberSuffix(String word) {
        return pluralThirdPersonMasculinePresentTenseSuffixPattern.matcher(word).find() ? "-IV.pl3m" : "";
    }

    static String taaMarbuuTaSuffix(String word) {
        return taaMarbuuTaSuffixPattern.matcher(word).find() ? "-taaMarbuuTa" : "";
    }

    static String abstractionNounSuffix(String word) {
        return taaMarbuuTaSuffixPattern.matcher(word).find() ? "-AbstractionSuffix" : "";
    }
}

