/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.ling;

import edu.stanford.nlp.ling.HasWord;
import edu.stanford.nlp.ling.Label;
import edu.stanford.nlp.ling.TaggedWord;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Sentence
extends ArrayList<HasWord> {
    public Sentence() {
    }

    public Sentence(Collection<? extends HasWord> w) {
        super(w);
    }

    public Sentence(List lex, List tags) {
        int n = lex.size();
        for (int i = 0; i < n; ++i) {
            this.add(new TaggedWord((String)lex.get(i), (String)tags.get(i)));
        }
    }

    public void setWords(Collection<HasWord> wordList) {
        this.clear();
        this.addAll(wordList);
    }

    public HasWord getHasWord(int index) {
        return (HasWord)this.get(index);
    }

    public int length() {
        return this.size();
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean justValue) {
        StringBuffer s = new StringBuffer();
        Iterator wordIterator = this.iterator();
        while (wordIterator.hasNext()) {
            Object o = wordIterator.next();
            if (justValue && o instanceof Label) {
                s.append(((Label)o).value());
            } else {
                s.append(o.toString());
            }
            if (!wordIterator.hasNext()) continue;
            s.append(" ");
        }
        return s.toString();
    }
}

