/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.story.ui.resolutions;

import edu.mit.story.core.build.IStoryProblem;
import edu.mit.story.core.desc.IDesc;
import edu.mit.story.ui.StoryUIPlugin;
import edu.mit.story.ui.WorkbenchUtils;
import edu.mit.story.ui.editor.IStoryEditor;
import edu.mit.story.ui.helpers.ICreatorDescriptor;
import edu.mit.story.ui.helpers.ICreatorPage;
import edu.mit.story.ui.helpers.IEditorPage;
import edu.mit.story.ui.resolutions.AbstractProblemResolution;
import edu.mit.story.ui.views.CreatorView;
import edu.mit.story.ui.views.HelperView;
import edu.mit.story.ui.widgets.HelperPageBookWidget;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.part.IPage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EditInCreatorResolution
extends AbstractProblemResolution {
    private static Image img;
    private final long id;
    private final ICreatorDescriptor<ICreatorPage> creator;

    public EditInCreatorResolution(long id, ICreatorDescriptor<ICreatorPage> creator) {
        super("Edit description " + Long.toString(id) + " in the " + creator.getName() + " creator", null, EditInCreatorResolution.getResolutionImage());
        if (creator == null) {
            throw new NullPointerException();
        }
        if (id < 0L) {
            throw new IllegalArgumentException();
        }
        this.id = id;
        this.creator = creator;
    }

    @Override
    protected void doRun(IStoryProblem problem, IStoryEditor editor) {
        IEditorPage widget;
        CreatorView.CreatorPageBookWidget bookWidget;
        CreatorView view;
        IDesc desc = editor.getStoryModel().getData().getDescription(this.id);
        if (desc == null) {
            throw new IllegalStateException("could not find description");
        }
        if (desc.getRep() != this.creator.getRep()) {
            MessageDialog.openError((Shell)editor.getSite().getShell(), (String)"Cannot edit", (String)"The selected description is not of the appropriate type to edit in the selected creator");
            return;
        }
        IWorkbenchWindow window = editor.getEditorSite().getWorkbenchWindow();
        IViewPart part = WorkbenchUtils.openView(window, "edu.mit.story.ui.views.CreatorView");
        CreatorView creatorView = view = part instanceof HelperView ? (CreatorView)part : null;
        if (view == null) {
            return;
        }
        IPage page = view.getCurrentPage();
        Control control = page.getControl();
        CreatorView.CreatorPageBookWidget creatorPageBookWidget = bookWidget = control instanceof CreatorView.CreatorPageBookWidget ? (CreatorView.CreatorPageBookWidget)control : null;
        if (bookWidget == null) {
            return;
        }
        HelperPageBookWidget.HelperPageDesc cPage = bookWidget.showPage(this.creator.getID());
        if (cPage == null) {
            return;
        }
        ICreatorPage creator = (ICreatorPage)cPage.getHelper();
        IEditorPage iEditorPage = widget = creator instanceof IEditorPage ? (IEditorPage)creator : null;
        if (widget == null) {
            throw new IllegalStateException("creator not appropriate type");
        }
        widget.edit(desc);
    }

    protected static Image getResolutionImage() {
        if (img == null) {
            ImageDescriptor d = StoryUIPlugin.getDefault().getImageRegistry().getDescriptor("etool16/edit_description.gif");
            img = d.createImage();
        }
        return img;
    }
}

