/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.story.ui.controllers;

import edu.mit.story.core.desc.IDesc;
import edu.mit.story.core.desc.IDescSet;
import edu.mit.story.core.position.IHasPosition;
import edu.mit.story.core.rep.IRep;
import edu.mit.story.ui.controllers.ICaptureStrategy;
import edu.mit.story.ui.editor.IStoryEditor;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SelectSingleStrategy
implements ICaptureStrategy {
    private final Set<IRep> reps;
    private final IStoryEditor editor;

    public SelectSingleStrategy(Collection<IRep> reps, IStoryEditor editor) {
        if (editor == null) {
            throw new NullPointerException();
        }
        this.reps = new HashSet<IRep>(reps);
        this.reps.remove(null);
        if (this.reps.isEmpty()) {
            throw new IllegalArgumentException();
        }
        this.editor = editor;
    }

    @Override
    public IDesc capture() {
        IHasPosition selection = this.editor.getSelectedRange();
        if (selection == null) {
            return null;
        }
        IDesc result = null;
        for (IRep rep : this.reps) {
            IDescSet descs = this.editor.getStoryModel().getData().getDescriptions(rep);
            IDescSet iDescSet = descs = selection.getLength() == 0 ? descs.closedSet(selection) : descs.openSet(selection);
            if (descs.size() == 0) continue;
            if (descs.size() >= 2) {
                return null;
            }
            if (result != null) {
                return null;
            }
            result = (IDesc)descs.first();
        }
        return result;
    }
}

