/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.core.resourcesListeners;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ISaveContext;
import org.eclipse.core.resources.ISaveParticipant;
import org.eclipse.core.resources.ISavedState;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Plugin;
import org.tigris.subversion.subclipse.core.Policy;
import org.tigris.subversion.subclipse.core.SVNException;
import org.tigris.subversion.subclipse.core.SVNProviderPlugin;
import org.tigris.subversion.subclipse.core.resources.SVNWorkspaceRoot;
import org.tigris.subversion.subclipse.core.util.JobUtility;

public class TeamPrivateListener
implements IResourceChangeListener,
ISaveParticipant {
    private SVNProviderPlugin provider = SVNProviderPlugin.getPlugin();

    public void resourceChanged(final IResourceChangeEvent event) {
        JobUtility.scheduleJob("TeamPrivateOperation", new Runnable(){

            public void run() {
                try {
                    event.getDelta().accept(new IResourceDeltaVisitor(this){
                        final /* synthetic */ 1 this$1;
                        {
                            this.this$1 = var1_1;
                        }

                        public boolean visit(IResourceDelta delta) throws CoreException {
                            IResource resource = delta.getResource();
                            int type = resource.getType();
                            if (type == 2) {
                                if (delta.getKind() != 1) {
                                    return true;
                                }
                                return !TeamPrivateListener.access$0(1.access$0(this.this$1)).isAdminDirectory(resource.getName()) || !1.access$0(this.this$1).handleSVNDir((IContainer)resource);
                            }
                            if (type == 4) {
                                IProject project = (IProject)resource;
                                if (!project.isAccessible()) {
                                    return false;
                                }
                                if (!SVNWorkspaceRoot.isManagedBySubclipse(project)) {
                                    return false;
                                }
                            }
                            return true;
                        }
                    });
                }
                catch (CoreException e) {
                    SVNProviderPlugin.log(e.getStatus());
                }
            }

            static /* synthetic */ TeamPrivateListener access$0(1 var0) {
                return var0.TeamPrivateListener.this;
            }
        }, null, true);
    }

    public void registerSaveParticipant() throws CoreException {
        IWorkspace ws = ResourcesPlugin.getWorkspace();
        ISavedState ss = ws.addSaveParticipant((Plugin)SVNProviderPlugin.getPlugin(), (ISaveParticipant)this);
        if (ss != null) {
            ss.processResourceChangeEvents((IResourceChangeListener)this);
        }
        ws.removeSaveParticipant((Plugin)SVNProviderPlugin.getPlugin());
    }

    public void doneSaving(ISaveContext context) {
    }

    public void prepareToSave(ISaveContext context) {
    }

    public void rollback(ISaveContext context) {
    }

    public void saving(ISaveContext context) {
    }

    public boolean handleSVNDir(IContainer svnDir) {
        IFile entriesFile;
        if (!svnDir.isTeamPrivateMember() && (entriesFile = svnDir.getFile((IPath)new Path("entries"))).exists() && !svnDir.isTeamPrivateMember()) {
            try {
                svnDir.setTeamPrivateMember(true);
                if (Policy.DEBUG_METAFILE_CHANGES) {
                    System.out.println("[svn] found a new SVN meta folder, marking as team-private: " + svnDir.getFullPath());
                }
            }
            catch (CoreException e) {
                SVNProviderPlugin.log(SVNException.wrapException((IResource)svnDir, Policy.bind("SyncFileChangeListener.errorSettingTeamPrivateFlag"), e));
            }
        }
        return svnDir.isTeamPrivateMember();
    }

    static /* synthetic */ SVNProviderPlugin access$0(TeamPrivateListener teamPrivateListener) {
        return teamPrivateListener.provider;
    }
}

