/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.synchronize;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.team.internal.ui.TeamUIMessages;
import org.eclipse.team.internal.ui.Utils;
import org.eclipse.team.internal.ui.synchronize.IPageValidator;
import org.eclipse.team.internal.ui.synchronize.SubscriberRefreshSchedule;
import org.eclipse.team.ui.synchronize.ISynchronizeParticipant;

public class ConfigureSynchronizeScheduleComposite
extends Composite {
    private SubscriberRefreshSchedule schedule;
    private Button userRefreshOnly;
    private Button enableBackgroundRefresh;
    private Text time;
    private Combo hoursOrSeconds;
    private IPageValidator validator;

    public ConfigureSynchronizeScheduleComposite(Composite parent, SubscriberRefreshSchedule schedule, IPageValidator validator) {
        super(parent, 0);
        this.schedule = schedule;
        this.validator = validator;
        this.createMainDialogArea(parent);
    }

    private void initializeValues() {
        long minutes;
        boolean enableBackground = this.schedule.isEnabled();
        boolean hours = false;
        this.userRefreshOnly.setSelection(!enableBackground);
        this.enableBackgroundRefresh.setSelection(enableBackground);
        long seconds = this.schedule.getRefreshInterval();
        if (seconds <= 60L) {
            seconds = 60L;
        }
        if ((minutes = seconds / 60L) >= 60L) {
            minutes /= 60L;
            hours = true;
        }
        this.hoursOrSeconds.select(hours ? 0 : 1);
        this.time.setText(Long.toString(minutes));
    }

    protected void createMainDialogArea(Composite parent) {
        GC gc = new GC((Drawable)parent);
        gc.setFont(JFaceResources.getDialogFont());
        FontMetrics fontMetrics = gc.getFontMetrics();
        gc.dispose();
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.horizontalSpacing = Dialog.convertHorizontalDLUsToPixels((FontMetrics)fontMetrics, (int)4);
        gridLayout.verticalSpacing = Dialog.convertVerticalDLUsToPixels((FontMetrics)fontMetrics, (int)4);
        this.setLayout((Layout)gridLayout);
        this.setLayoutData(new GridData(4, 4, true, true));
        ConfigureSynchronizeScheduleComposite area = this;
        this.createWrappingLabel(area, NLS.bind((String)TeamUIMessages.ConfigureRefreshScheduleDialog_1, (Object[])new String[]{Utils.shortenText(100, this.schedule.getParticipant().getName())}), 0, 2);
        Label label = new Label((Composite)area, 64);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        label.setLayoutData((Object)gridData);
        label.setText(NLS.bind((String)TeamUIMessages.ConfigureRefreshScheduleDialog_1a, (Object[])new String[]{SubscriberRefreshSchedule.refreshEventAsString(this.schedule.getLastRefreshEvent())}));
        this.userRefreshOnly = new Button((Composite)area, 16);
        GridData gridData2 = new GridData();
        gridData2.horizontalSpan = 2;
        this.userRefreshOnly.setLayoutData((Object)gridData2);
        this.userRefreshOnly.setText(TeamUIMessages.ConfigureRefreshScheduleDialog_2);
        this.userRefreshOnly.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ConfigureSynchronizeScheduleComposite.this.updateEnablements();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.enableBackgroundRefresh = new Button((Composite)area, 16);
        gridData2 = new GridData();
        gridData2.horizontalSpan = 2;
        this.enableBackgroundRefresh.setLayoutData((Object)gridData2);
        this.enableBackgroundRefresh.setText(TeamUIMessages.ConfigureRefreshScheduleDialog_3);
        this.enableBackgroundRefresh.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ConfigureSynchronizeScheduleComposite.this.updateEnablements();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Composite composite = new Composite((Composite)area, 0);
        gridData = new GridData(1794);
        gridData.horizontalSpan = 2;
        composite.setLayoutData((Object)gridData);
        GridLayout gridLayout_1 = new GridLayout();
        gridLayout_1.numColumns = 3;
        gridLayout_1.marginWidth = 0;
        gridLayout_1.marginHeight = 0;
        gridLayout_1.horizontalSpacing = Dialog.convertHorizontalDLUsToPixels((FontMetrics)fontMetrics, (int)4);
        gridLayout_1.verticalSpacing = Dialog.convertVerticalDLUsToPixels((FontMetrics)fontMetrics, (int)4);
        composite.setLayout((Layout)gridLayout_1);
        Label label2 = new Label(composite, 0);
        label2.setText(TeamUIMessages.ConfigureRefreshScheduleDialog_4);
        this.time = new Text(composite, 133120);
        GridData gridData_1 = new GridData();
        gridData_1.widthHint = 35;
        this.time.setLayoutData((Object)gridData_1);
        this.time.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ConfigureSynchronizeScheduleComposite.this.updateEnablements();
            }
        });
        this.time.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                String string = e.text;
                char[] chars = new char[string.length()];
                string.getChars(0, chars.length, chars, 0);
                int i = 0;
                while (i < chars.length) {
                    if ('0' > chars[i] || chars[i] > '9') {
                        e.doit = false;
                        return;
                    }
                    ++i;
                }
            }
        });
        this.hoursOrSeconds = new Combo(composite, 8);
        this.hoursOrSeconds.setItems(new String[]{TeamUIMessages.ConfigureRefreshScheduleDialog_5, TeamUIMessages.ConfigureRefreshScheduleDialog_6});
        this.hoursOrSeconds.setLayoutData((Object)new GridData());
        this.initializeValues();
    }

    public void saveValues() {
        ISynchronizeParticipant participant;
        int hours = this.hoursOrSeconds.getSelectionIndex();
        try {
            long seconds = Long.parseLong(this.time.getText());
            seconds = hours == 0 ? (seconds *= 3600L) : (seconds *= 60L);
            this.schedule.setRefreshInterval(seconds);
        }
        catch (NumberFormatException numberFormatException) {}
        if (this.schedule.isEnabled() != this.enableBackgroundRefresh.getSelection()) {
            this.schedule.setEnabled(this.enableBackgroundRefresh.getSelection(), true);
        }
        if (!(participant = this.schedule.getParticipant()).isPinned() && this.schedule.isEnabled()) {
            participant.setPinned(MessageDialog.openQuestion((Shell)this.getShell(), (String)NLS.bind((String)TeamUIMessages.ConfigureSynchronizeScheduleComposite_0, (Object[])new String[]{Utils.getTypeName(participant)}), (String)NLS.bind((String)TeamUIMessages.ConfigureSynchronizeScheduleComposite_1, (Object[])new String[]{Utils.getTypeName(participant)})));
        }
        this.schedule.getRefreshable().setRefreshSchedule(this.schedule);
    }

    public void updateEnablements() {
        if (this.userRefreshOnly.getSelection()) {
            this.validator.setComplete(null);
        } else {
            try {
                long number = Long.parseLong(this.time.getText());
                if (number <= 0L) {
                    this.validator.setComplete(TeamUIMessages.ConfigureRefreshScheduleDialog_7);
                } else {
                    this.validator.setComplete(null);
                }
            }
            catch (NumberFormatException numberFormatException) {
                this.validator.setComplete(TeamUIMessages.ConfigureRefreshScheduleDialog_8);
            }
        }
        this.time.setEnabled(this.enableBackgroundRefresh.getSelection());
        this.hoursOrSeconds.setEnabled(this.enableBackgroundRefresh.getSelection());
    }

    private Label createWrappingLabel(Composite parent, String text, int indent, int horizontalSpan) {
        Label label = new Label(parent, 16448);
        label.setText(text);
        GridData data = new GridData();
        data.horizontalSpan = horizontalSpan;
        data.horizontalAlignment = 4;
        data.horizontalIndent = indent;
        data.grabExcessHorizontalSpace = true;
        data.widthHint = 400;
        label.setLayoutData((Object)data);
        return label;
    }
}

