/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.semantics.core.rep.semrole.model;

import edu.mit.jpropbank.IArg;
import edu.mit.jpropbank.Label;
import edu.mit.jpropbank.frames.IRole;
import edu.mit.jpropbank.frames.IRoleset;
import edu.mit.parsing.core.model.SegmentSetModel;
import edu.mit.parsing.core.rep.parse.ITree;
import edu.mit.parsing.core.rep.parse.ParseRep;
import edu.mit.parsing.core.rep.sentence.SentenceRep;
import edu.mit.parsing.core.rep.token.TokenRep;
import edu.mit.semantics.core.propbank.GenericRoleSet;
import edu.mit.semantics.core.rep.semrole.ITreeNode;
import edu.mit.semantics.core.rep.semrole.TreeNode;
import edu.mit.semantics.core.rep.semrole.model.ISemArgModel;
import edu.mit.story.core.desc.IDesc;
import edu.mit.story.core.desc.IDescSet;
import edu.mit.story.core.desc.ISegment;
import edu.mit.story.core.desc.Segment;
import edu.mit.story.core.model.IStoryData;
import edu.mit.story.core.model.IStoryModel;
import edu.mit.story.core.position.HasPositionSet;
import edu.mit.story.core.position.IHasPosition;
import edu.mit.story.core.position.IHasPositionSet;
import edu.mit.story.core.validation.Message;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.dialogs.IMessageProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SemArgModel
extends SegmentSetModel
implements ISemArgModel {
    public static final IMessageProvider noLabel = new Message("Label may not be null", 3);
    public static final IMessageProvider noLocation = new Message("Arguments may not come from sentences other than that of the verb", 3);
    private IArg<? extends ITreeNode> loaded = null;
    private String label = this.getDefaultLabel();
    private String feature = this.getDefaultFeature();
    private IRoleset roleset = this.getDefaultRoleset();
    private List<List<ITreeNode>> loc = null;
    private IDesc sentence = null;

    public SemArgModel(IStoryModel storyModel) {
        super(TokenRep.getInstance(), storyModel);
    }

    public String getLabel() {
        return this.label;
    }

    public String getFeature() {
        return this.feature;
    }

    public List<List<ITreeNode>> getLocation() {
        if (this.loc == null) {
            List<Object> split;
            IHasPositionSet ranges = this.getSegments();
            if (ranges.isEmpty()) {
                return Collections.emptyList();
            }
            IDesc treeDesc = null;
            HashSet<IDesc> nodes = new HashSet<IDesc>();
            for (ISegment seg : ranges) {
                for (IDesc desc : seg.getDescs()) {
                    nodes.add(desc);
                    if (treeDesc != null) continue;
                    IDescSet parses = this.storyModel.getData().getDescriptions(ParseRep.getInstance()).closedSet((IHasPosition)desc);
                    IDesc iDesc = treeDesc = parses.size() == 1 ? (IDesc)parses.first() : null;
                }
            }
            if (treeDesc == null) {
                return Collections.emptyList();
            }
            Map leafMap = ((ITree)treeDesc.getData()).getRoot().getLeafMap();
            Set<ITree> cover = new HashSet<ITree>(nodes.size());
            for (IDesc node : nodes) {
                ITree leaf = (ITree)leafMap.get(node);
                if (leaf == null) {
                    return null;
                }
                cover.add(leaf);
            }
            if ((cover = SemArgModel.compact(cover)) == null) {
                return null;
            }
            if (cover.size() == 1) {
                split = Collections.singletonList(new TreeNode(cover.iterator().next()));
            } else {
                split = new ArrayList(cover.size());
                for (ITree node : cover) {
                    split.add(new TreeNode(node));
                }
                split = Collections.unmodifiableList(split);
            }
            this.loc = Collections.singletonList(split);
        }
        return this.loc;
    }

    @Override
    public IRole getRole() {
        if (this.roleset == null) {
            return null;
        }
        return this.roleset.getRole(this.label, this.feature);
    }

    @Override
    public IRoleset getRoleset() {
        return this.roleset;
    }

    @Override
    public void setLabel(String newLabel) {
        if (newLabel == null) {
            newLabel = this.getDefaultLabel();
        }
        if (this.label.equals(newLabel)) {
            return;
        }
        this.label = newLabel;
        this.fireChanged();
    }

    @Override
    public void setFeature(String newFeature) {
        if (newFeature == null) {
            newFeature = this.getDefaultFeature();
        }
        if (this.feature.equals(newFeature)) {
            return;
        }
        this.feature = newFeature;
        this.fireChanged();
    }

    @Override
    public void setRoleset(IRoleset newRoleset) {
        if (newRoleset == null) {
            newRoleset = this.getDefaultRoleset();
        }
        if (this.roleset.equals(newRoleset)) {
            return;
        }
        this.roleset = newRoleset;
        this.fireChanged();
    }

    public boolean isCleared() {
        if (this.loaded != null) {
            return false;
        }
        if (!this.label.equals(this.getDefaultLabel())) {
            return false;
        }
        if (!this.feature.equals(this.getDefaultFeature())) {
            return false;
        }
        return super.isCleared();
    }

    protected void internalClear() {
        this.loaded = null;
        this.label = this.getDefaultLabel();
        this.feature = this.getDefaultFeature();
        super.internalClear();
    }

    protected String getDefaultLabel() {
        return Label.ARG0.name();
    }

    protected String getDefaultFeature() {
        return "";
    }

    protected IRoleset getDefaultRoleset() {
        return GenericRoleSet.getInstance();
    }

    protected IMessageProvider calculateMessage() {
        if (this.label == null) {
            return noLabel;
        }
        if (this.sentence == null) {
            return noLocation;
        }
        return super.calculateMessage();
    }

    protected void setOutOfSync() {
        this.loc = null;
        super.setOutOfSync();
    }

    public SemArgModel clone() {
        SemArgModel clone = new SemArgModel(this.getStoryModel());
        clone.setLabel(this.getLabel());
        clone.setFeature(this.getFeature());
        clone.setSegments((Collection<? extends ISegment>)this.getSegments());
        clone.setRoleSet(this.getRoleSet());
        return clone;
    }

    @Override
    public void load(IArg<? extends ITreeNode> arg) {
        this.internalClear();
        this.loaded = arg;
        HasPositionSet descs = new HasPositionSet();
        for (List split : arg.getLocation()) {
            for (ITreeNode node : split) {
                descs.addAll((Collection)node.getTree().getTokens());
            }
        }
        HasPositionSet result = new HasPositionSet();
        IStoryData data = this.getStoryModel().getData();
        IDescSet allDescs = data.getDescriptions(this.getRep()).closedSet((IHasPosition)descs);
        Iterator i = allDescs.iterator();
        IDesc actual = null;
        HasPositionSet segment = new HasPositionSet();
        while (!descs.isEmpty()) {
            IDesc curr = (IDesc)descs.first();
            descs.remove((Object)curr);
            actual = (IDesc)i.next();
            boolean skipped = false;
            while (actual != curr) {
                actual = (IDesc)i.next();
                skipped = true;
            }
            if (skipped && !segment.isEmpty()) {
                result.add((Object)new Segment((IHasPosition)segment, this.getRep(), data));
                segment.clear();
            }
            segment.add((Object)curr);
            if (!descs.isEmpty()) continue;
            result.add((Object)new Segment((IHasPosition)segment, this.getRep(), data));
        }
        this.label = arg.getLabel();
        this.feature = arg.getFeature();
        this.setSegments((Collection<? extends ISegment>)result);
    }

    @Override
    public IArg<? extends ITreeNode> getLoaded() {
        return this.loaded;
    }

    public void setRoleSet(IRoleset newRoleset) {
        if (this.roleset == newRoleset) {
            return;
        }
        this.roleset = newRoleset;
        this.fireChanged();
    }

    public IRoleset getRoleSet() {
        return this.roleset;
    }

    public static Set<ITree> compact(Set<ITree> nodes) {
        HashSet<ITree> result = new HashSet<ITree>(nodes);
        boolean madeProgress = true;
        while (madeProgress && !result.isEmpty()) {
            madeProgress = false;
            ITree parent = null;
            for (ITree tree : result) {
                if (tree.getParent() == null || !result.containsAll(tree.getParent().getChildren())) continue;
                parent = tree.getParent();
                break;
            }
            if (parent == null) continue;
            result.removeAll(parent.getChildren());
            result.add(parent);
            madeProgress = true;
        }
        return result;
    }

    @Override
    public IDescSet getTokens() {
        return this.getDescs();
    }

    public void setSegments(Collection<? extends ISegment> segs) {
        super.setSegments(segs);
        this.sentence = this.findSentence();
        this.fireChanged();
    }

    protected IDesc findSentence() {
        IHasPositionSet segments = this.getSegments();
        if (segments.isEmpty()) {
            return null;
        }
        IDescSet sents = this.getStoryModel().getData().getDescriptions(SentenceRep.getInstance()).closedSet((IHasPosition)segments);
        if (sents.size() != 1) {
            return null;
        }
        return (IDesc)sents.first();
    }

    @Override
    public IDesc getSentence() {
        return this.sentence;
    }
}

