/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.parsing.core.rep.tag.tagset;

import edu.mit.parsing.core.rep.tag.tagset.ITag;
import edu.mit.parsing.core.rep.tag.tagset.ITagset;
import edu.mit.parsing.core.rep.tag.tagset.models.ITagModel;
import edu.mit.story.core.StoryPlugin;
import edu.mit.story.core.descriptor.IRegistered;
import edu.mit.story.core.descriptor.Registered;
import edu.mit.story.core.rep.IRep;
import java.util.AbstractSet;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TagSet
extends AbstractSet<ITag>
implements ITagset {
    private final IRegistered metadata;
    private final ITagset.Scope scope;
    private final String repID;
    private final Map<String, ITag> tagMap;

    public TagSet(String id, String name, String description, String repID, ITagset.Scope scope, List<ITagModel> tagBuilders) {
        if (repID == null) {
            throw new NullPointerException();
        }
        if (scope == null) {
            throw new NullPointerException();
        }
        Registered metadata = new Registered(id, name, description){};
        LinkedHashMap<String, ITag> tagMap = new LinkedHashMap<String, ITag>();
        for (ITagModel b : tagBuilders) {
            ITag t = b.create(this);
            tagMap.put(t.getID().toLowerCase(), t);
        }
        this.metadata = metadata;
        this.repID = repID;
        this.scope = scope;
        this.tagMap = Collections.unmodifiableMap(tagMap);
    }

    public String getID() {
        return this.metadata.getID();
    }

    public String getName() {
        return this.metadata.getName();
    }

    public String getDescription() {
        return this.metadata.getDescription();
    }

    @Override
    public IRep getTarget() {
        return StoryPlugin.getDefault().getRepManager().getRep(this.repID);
    }

    public String getTargetRepID() {
        return this.repID;
    }

    @Override
    public ITagset.Scope getScope() {
        return this.scope;
    }

    @Override
    public ITag getTag(String id) {
        return this.tagMap.get(id.toLowerCase());
    }

    @Override
    public int size() {
        return this.tagMap.size();
    }

    @Override
    public Iterator<ITag> iterator() {
        return this.tagMap.values().iterator();
    }

    public void setID(String id) {
        this.metadata.setID(id);
    }

    public void setName(String name) {
        this.metadata.setName(name);
    }

    public void setDescription(String description) {
        this.metadata.setDescription(description);
    }

    @Override
    public ITag getDefault() {
        return this.tagMap.values().iterator().next();
    }
}

