/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.parsing.core.rep.pos.problems;

import edu.mit.parsing.core.rep.pos.IPosTag;
import edu.mit.parsing.core.rep.pos.POSRep;
import edu.mit.parsing.core.rep.token.IBaseToken;
import edu.mit.story.core.build.StoryProblem;
import edu.mit.story.core.desc.IDesc;
import edu.mit.story.core.desc.IDescSet;
import edu.mit.story.core.position.IHasPosition;
import java.util.Collection;
import java.util.Collections;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnknownPOSProblem
extends StoryProblem {
    public static final String ID = "edu.mit.parsing.core.problem.unknownPOS";

    public UnknownPOSProblem(IDesc tag, String buildRuleID) {
        this(Collections.singleton(tag), buildRuleID);
    }

    public UnknownPOSProblem(Collection<? extends IDesc> descs, String buildRuleID) {
        super(POSRep.getInstance(), buildRuleID);
        this.setID(ID);
        this.setName("Unknown Part of Speech");
        this.setDescs(descs);
        this.setCheck(ID);
        this.setSeverity(1);
        IDescSet tags = this.getDescs().getDescriptions(POSRep.getInstance());
        if (tags.isEmpty()) {
            throw new IllegalArgumentException();
        }
        if (tags.size() > 1) {
            this.setDescription("There are " + tags.size() + " UNKNOWN part of speech tags (only first shown)");
            this.setPosition((IHasPosition)tags.first());
        } else {
            IDesc d = (IDesc)tags.first();
            IPosTag tag = (IPosTag)d.getData();
            IBaseToken tok = (IBaseToken)tag.getWord().getData();
            this.setPosition((IHasPosition)d);
            this.setDescription("The word '" + tok.getSurface() + "' is marked with an UNKNOWN part of speech");
        }
    }
}

