/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.parsing.core.model;

import edu.mit.parsing.core.model.ISegmentModel;
import edu.mit.story.core.datamodel.AbstractViewModel;
import edu.mit.story.core.desc.DescSet;
import edu.mit.story.core.desc.IDesc;
import edu.mit.story.core.desc.IDescSet;
import edu.mit.story.core.desc.ISegment;
import edu.mit.story.core.desc.ImmutableDescSet;
import edu.mit.story.core.desc.Segment;
import edu.mit.story.core.model.IStoryModel;
import edu.mit.story.core.model.change.IModelListener;
import edu.mit.story.core.model.change.StoryChangeEvent;
import edu.mit.story.core.position.IHasPosition;
import edu.mit.story.core.position.SimplePosition;
import edu.mit.story.core.rep.IRep;
import edu.mit.story.core.util.IDescDisplayText;
import edu.mit.story.core.validation.Message;
import java.util.Collection;
import org.eclipse.jface.dialogs.IMessageProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SegmentModel
extends AbstractViewModel
implements ISegmentModel,
IModelListener {
    public static final IMessageProvider defaultSegmentEmptyMessage = new Message("You must select a segment", 3);
    private IMessageProvider segmentEmptyMessage = defaultSegmentEmptyMessage;
    private final IRep rep;
    private final IDescDisplayText display;
    private final IStoryModel storyModel;
    private final IDescSet segment;
    private final IDescSet segmentExt;

    public SegmentModel(IRep rep, IStoryModel storyModel, IDescDisplayText display) {
        this(rep, storyModel, display, true);
    }

    public SegmentModel(IRep rep, IStoryModel storyModel, IDescDisplayText display, boolean listen) {
        if (rep == null) {
            throw new NullPointerException();
        }
        if (display == null) {
            throw new NullPointerException();
        }
        if (storyModel == null) {
            throw new NullPointerException();
        }
        this.rep = rep;
        this.display = display;
        this.segment = new DescSet(rep);
        this.segmentExt = new ImmutableDescSet(this.segment);
        this.storyModel = storyModel;
        if (listen) {
            this.storyModel.addModelListener((IModelListener)this);
        }
    }

    public IRep getRep() {
        return this.rep;
    }

    @Override
    public IDescSet getSegment() {
        return this.segmentExt;
    }

    @Override
    public IStoryModel getStoryModel() {
        return this.storyModel;
    }

    @Override
    public void setSegment(Collection<? extends IDesc> descs) {
        this.segment.clear();
        if (descs != null) {
            this.segment.addAll(descs);
        }
        this.setOutOfSync();
        this.notifyChangeListeners();
    }

    @Override
    public String getLeftText() {
        return this.segment.isEmpty() ? "" : this.display.getDisplayText((IDesc)this.segment.first());
    }

    @Override
    public String getRightText() {
        return this.segment.isEmpty() ? "" : this.display.getDisplayText((IDesc)this.segment.last());
    }

    public void modelChanged(StoryChangeEvent e) {
        if (this.segment.isEmpty()) {
            return;
        }
        if (e.getChange(this.rep) == null) {
            return;
        }
        IDescSet newDescs = this.storyModel.getData().getDescriptions(this.segment.getRep());
        boolean changed = false;
        int offset = Integer.MAX_VALUE;
        int rightOffset = -1;
        for (IDesc oldDesc : this.segment) {
            IDesc newDesc = newDescs.getDescription(oldDesc.getID());
            if (newDesc != oldDesc) {
                changed = true;
            }
            if (newDesc == null) continue;
            offset = Math.min(offset, newDesc.getOffset());
            rightOffset = Math.max(rightOffset, newDesc.getRightOffset());
        }
        Object object = newDescs = rightOffset == -1 ? new DescSet(this.segment.getRep()) : newDescs.closedSet((IHasPosition)new SimplePosition(offset, rightOffset - offset));
        if (this.segment.size() != newDescs.size()) {
            changed = true;
        }
        if (!changed) {
            return;
        }
        this.segment.clear();
        this.segment.addAll((Collection)newDescs);
        this.setOutOfSync();
        this.notifyChangeListeners();
    }

    @Override
    public void setSegmentEmptyMessage(IMessageProvider message) {
        this.segmentEmptyMessage = message == null ? Message.NO_MESSAGE : message;
        this.setOutOfSync();
        this.notifyChangeListeners();
    }

    @Override
    public IMessageProvider getSegmentEmptyMessage() {
        return this.segmentEmptyMessage;
    }

    protected void internalClear() {
        this.segment.clear();
    }

    public boolean isCleared() {
        return this.segment.isEmpty();
    }

    public void dispose() {
        this.storyModel.removeModelListener((IModelListener)this);
    }

    protected IMessageProvider calculateMessage() {
        return this.segment.isEmpty() ? this.segmentEmptyMessage : Message.NO_MESSAGE;
    }

    @Override
    public String getText() {
        return this.segment.isEmpty() ? "" : this.display.getDisplayText(this.segment, this.storyModel);
    }

    @Override
    public ISegment asSegment() {
        return new Segment((IHasPosition)this.segment, this.segment.getRep(), this.storyModel.getData());
    }
}

