/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.graphics.TextStyle;
import org.eclipse.swt.internal.carbon.OS;
import org.eclipse.swt.internal.carbon.Point;
import org.eclipse.swt.internal.carbon.TextRange;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Caret;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Widget;

public class IME
extends Widget {
    Canvas parent;
    int caretOffset;
    int startOffset;
    int commitCount;
    String text;
    int[] ranges;
    TextStyle[] styles;
    static final int UNDERLINE_IME_INPUT = 65536;
    static final int UNDERLINE_IME_TARGET_CONVERTED = 131072;
    static final int UNDERLINE_IME_CONVERTED = 196608;

    IME() {
    }

    public IME(Canvas parent, int style) {
        super(parent, style);
        this.parent = parent;
        this.createWidget();
    }

    void createWidget() {
        this.text = "";
        this.startOffset = -1;
        if (this.parent.getIME() == null) {
            this.parent.setIME(this);
        }
    }

    public int getCaretOffset() {
        this.checkWidget();
        return this.startOffset + this.caretOffset;
    }

    public int getCommitCount() {
        this.checkWidget();
        return this.commitCount;
    }

    public int getCompositionOffset() {
        this.checkWidget();
        return this.startOffset;
    }

    public int[] getRanges() {
        this.checkWidget();
        if (this.ranges == null) {
            return new int[0];
        }
        int[] result = new int[this.ranges.length];
        int i = 0;
        while (i < result.length) {
            result[i] = this.ranges[i] + this.startOffset;
            ++i;
        }
        return result;
    }

    public TextStyle[] getStyles() {
        this.checkWidget();
        if (this.styles == null) {
            return new TextStyle[0];
        }
        TextStyle[] result = new TextStyle[this.styles.length];
        System.arraycopy(this.styles, 0, result, 0, this.styles.length);
        return result;
    }

    public String getText() {
        this.checkWidget();
        return this.text;
    }

    public boolean getWideCaret() {
        this.checkWidget();
        return false;
    }

    boolean isInlineEnabled() {
        return this.hooks(43);
    }

    int kEventTextInputOffsetToPos(int nextHandler, int theEvent, int userData) {
        if (!this.isInlineEnabled()) {
            return -9874;
        }
        Caret caret = this.parent.caret;
        if (caret == null) {
            return -9874;
        }
        Point pt = new Point();
        int sizeof = 4;
        org.eclipse.swt.graphics.Point point = this.parent.toDisplay(caret.x, caret.y + caret.height);
        pt.h = (short)point.x;
        pt.v = (short)point.y;
        OS.SetEventParameter(theEvent, 1953656948, 1363439732, sizeof, pt);
        return 0;
    }

    int kEventTextInputPosToOffset(int nextHandler, int theEvent, int userData) {
        int hitTest;
        if (!this.isInlineEnabled()) {
            return -9874;
        }
        if (this.startOffset == -1) {
            return -9874;
        }
        Point pt = new Point();
        int sizeof = 4;
        OS.GetEventParameter(theEvent, 1953719152, 1363439732, null, sizeof, null, pt);
        org.eclipse.swt.graphics.Point point = this.parent.toControl(pt.h, pt.v);
        Event event = new Event();
        event.detail = 2;
        event.x = point.x;
        event.y = point.y;
        this.sendEvent(43, event);
        int offset = event.index + event.count;
        if (offset == -1) {
            hitTest = 1;
        } else if (this.startOffset <= offset && offset < this.startOffset + this.text.length()) {
            hitTest = 3;
            offset -= this.startOffset;
        } else {
            hitTest = 2;
        }
        OS.SetEventParameter(theEvent, 1953657967, 1819242087, 4, new int[]{offset * 2});
        OS.SetEventParameter(theEvent, 1953657447, 1819242087, 4, new int[]{hitTest});
        OS.SetEventParameter(theEvent, 1953655909, 1651470188, 4, new boolean[]{event.count == 0});
        return 0;
    }

    int kEventTextInputGetSelectedText(int nextHandler, int theEvent, int userData) {
        Event event = new Event();
        event.detail = 3;
        this.sendEvent(43, event);
        String text = event.text;
        if (text.length() > 0) {
            char[] buffer = new char[text.length()];
            text.getChars(0, buffer.length, buffer, 0);
            OS.SetEventParameter(theEvent, 1953657976, 1970567284, buffer.length * 2, buffer);
            return 0;
        }
        return -9874;
    }

    int kEventTextInputUpdateActiveInputArea(int nextHandler, int theEvent, int userData) {
        if (!this.isInlineEnabled()) {
            return -9874;
        }
        this.ranges = null;
        this.styles = null;
        this.commitCount = 0;
        this.caretOffset = 0;
        int[] length = new int[1];
        OS.GetEventParameter(theEvent, 1953723512, 1970567284, null, 0, length, null);
        char[] chars = new char[length[0]];
        OS.GetEventParameter(theEvent, 1953723512, 1970567284, null, length[0], null, chars);
        int[] fixed_length = new int[1];
        OS.GetEventParameter(theEvent, 1953719928, 1819242087, null, 4, null, fixed_length);
        int[] rangeSize = new int[1];
        int rc = OS.GetEventParameter(theEvent, 1953720425, 1953653113, null, 0, rangeSize, null);
        if (rc == 0) {
            int firstSelectedConverted = -1;
            boolean hasConvertedText = false;
            int textRanges = OS.NewPtr(rangeSize[0]);
            OS.GetEventParameter(theEvent, 1953720425, 1953653113, null, rangeSize[0], null, textRanges);
            short[] nRanges = new short[1];
            OS.memmove(nRanges, textRanges, 2);
            int count = nRanges[0];
            if (count > 0) {
                TextRange range = new TextRange();
                this.ranges = new int[(count - 1) * 2];
                this.styles = new TextStyle[count - 1];
                int i = 0;
                int j = 0;
                while (i < count) {
                    OS.memmove(range, textRanges + 2 + i * 10, 10);
                    switch (range.fHiliteStyle) {
                        case 1: {
                            this.caretOffset = range.fStart / 2;
                            break;
                        }
                        case 2: 
                        case 3: 
                        case 4: 
                        case 5: {
                            this.ranges[j * 2] = range.fStart / 2;
                            this.ranges[j * 2 + 1] = range.fEnd / 2 - 1;
                            this.styles[j] = new TextStyle();
                            this.styles[j].underline = true;
                            this.styles[j].underlineStyle = 65536;
                            if (range.fHiliteStyle == 4) {
                                this.styles[j].underlineStyle = 196608;
                                hasConvertedText = true;
                            }
                            if (range.fHiliteStyle == 5) {
                                this.styles[j].underlineStyle = 131072;
                                if (firstSelectedConverted == -1) {
                                    firstSelectedConverted = range.fStart;
                                }
                            }
                            ++j;
                        }
                    }
                    ++i;
                }
            }
            OS.DisposePtr(textRanges);
            if (hasConvertedText && firstSelectedConverted != -1) {
                this.caretOffset = firstSelectedConverted / 2;
            }
        }
        int end = this.startOffset + this.text.length();
        if (this.startOffset == -1) {
            Event event = new Event();
            event.detail = 3;
            this.sendEvent(43, event);
            this.startOffset = event.start;
            end = event.end;
        }
        Event event = new Event();
        event.detail = 1;
        event.start = this.startOffset;
        event.end = end;
        event.text = this.text = new String(chars, 0, length[0] / 2);
        this.commitCount = fixed_length[0] != -1 ? fixed_length[0] / 2 : length[0] / 2;
        this.sendEvent(43, event);
        if (this.commitCount == this.text.length()) {
            this.text = "";
            this.commitCount = 0;
            this.caretOffset = 0;
            this.startOffset = -1;
            this.ranges = null;
            this.styles = null;
        }
        if (event.doit && (fixed_length[0] == -1 || fixed_length[0] == length[0])) {
            int i = 0;
            while (i < chars.length) {
                if (chars[i] == '\u0000') break;
                event = new Event();
                event.character = chars[i];
                this.parent.sendKeyEvent(1, event);
                ++i;
            }
        }
        return 0;
    }

    void releaseParent() {
        super.releaseParent();
        if (this == this.parent.getIME()) {
            this.parent.setIME(null);
        }
    }

    void releaseWidget() {
        super.releaseWidget();
        this.parent = null;
        this.text = null;
        this.styles = null;
        this.ranges = null;
    }

    public void setCompositionOffset(int offset) {
        this.checkWidget();
        if (offset < 0) {
            return;
        }
        if (this.startOffset != -1) {
            this.startOffset = offset;
        }
    }
}

