/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.dnd;

import org.eclipse.swt.SWT;
import org.eclipse.swt.dnd.DND;
import org.eclipse.swt.dnd.DNDEvent;
import org.eclipse.swt.dnd.DNDListener;
import org.eclipse.swt.dnd.DropTargetEffect;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.TableDropTargetEffect;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.dnd.TreeDropTargetEffect;
import org.eclipse.swt.internal.Callback;
import org.eclipse.swt.internal.carbon.CGPoint;
import org.eclipse.swt.internal.carbon.OS;
import org.eclipse.swt.internal.carbon.Point;
import org.eclipse.swt.internal.carbon.Rect;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.Widget;

public class DropTarget
extends Widget {
    Control control;
    Listener controlListener;
    Transfer[] transferAgents = new Transfer[0];
    DropTargetEffect dropEffect;
    int feedback = 0;
    TransferData selectedDataType;
    int selectedOperation;
    int keyOperation = -1;
    long dragOverStart;
    Runnable dragOverHeartbeat;
    DNDEvent dragOverEvent;
    static DropTarget CurrentDropTarget;
    static final String DEFAULT_DROP_TARGET_EFFECT = "DEFAULT_DROP_TARGET_EFFECT";
    static final int DRAGOVER_HYSTERESIS = 50;
    static Callback DragTrackingHandler;
    static Callback DragReceiveHandler;
    static /* synthetic */ Class class$0;

    static {
        int dragReceiveHandlerAddress;
        Class<?> clazz;
        int dragTrackingHandlerAddress;
        CurrentDropTarget = null;
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("org.eclipse.swt.dnd.DropTarget");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((dragTrackingHandlerAddress = (DragTrackingHandler = new Callback(clazz2, "DragTrackingHandler", 4)).getAddress()) == 0) {
            SWT.error(3);
        }
        if ((clazz = class$0) == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.swt.dnd.DropTarget");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((dragReceiveHandlerAddress = (DragReceiveHandler = new Callback(clazz, "DragReceiveHandler", 3)).getAddress()) == 0) {
            SWT.error(3);
        }
        OS.InstallTrackingHandler(dragTrackingHandlerAddress, 0, null);
        OS.InstallReceiveHandler(dragReceiveHandlerAddress, 0, null);
    }

    public DropTarget(Control control, int style) {
        super(control, DropTarget.checkStyle(style));
        this.control = control;
        if (DragTrackingHandler == null || DragTrackingHandler == null) {
            DND.error(2001);
        }
        if (control.getData("DropTarget") != null) {
            DND.error(2001);
        }
        control.setData("DropTarget", this);
        this.controlListener = new Listener(){

            public void handleEvent(Event event) {
                if (!DropTarget.this.isDisposed()) {
                    DropTarget.this.dispose();
                }
            }
        };
        control.addListener(12, this.controlListener);
        this.addListener(12, new Listener(){

            public void handleEvent(Event event) {
                DropTarget.this.onDispose();
            }
        });
        Object effect = control.getData(DEFAULT_DROP_TARGET_EFFECT);
        if (effect instanceof DropTargetEffect) {
            this.dropEffect = (DropTargetEffect)effect;
        } else if (control instanceof Table) {
            this.dropEffect = new TableDropTargetEffect((Table)control);
        } else if (control instanceof Tree) {
            this.dropEffect = new TreeDropTargetEffect((Tree)control);
        }
        this.dragOverHeartbeat = new Runnable(){

            public void run() {
                Control control = DropTarget.this.control;
                if (control == null || control.isDisposed() || DropTarget.this.dragOverStart == 0L) {
                    return;
                }
                long time = System.currentTimeMillis();
                int delay = 50;
                if (time < DropTarget.this.dragOverStart) {
                    delay = (int)(DropTarget.this.dragOverStart - time);
                } else {
                    int allowedOperations = DropTarget.this.dragOverEvent.operations;
                    TransferData[] allowedTypes = DropTarget.this.dragOverEvent.dataTypes;
                    TransferData[] dataTypes = new TransferData[allowedTypes.length];
                    System.arraycopy(allowedTypes, 0, dataTypes, 0, dataTypes.length);
                    DNDEvent event = new DNDEvent();
                    event.widget = DropTarget.this.dragOverEvent.widget;
                    event.x = DropTarget.this.dragOverEvent.x;
                    event.y = DropTarget.this.dragOverEvent.y;
                    event.time = (int)time;
                    event.feedback = 1;
                    event.dataTypes = dataTypes;
                    event.dataType = DropTarget.this.selectedDataType;
                    event.operations = DropTarget.this.dragOverEvent.operations;
                    event.detail = DropTarget.this.selectedOperation;
                    if (DropTarget.this.dropEffect != null) {
                        event.item = DropTarget.this.dropEffect.getItem(event.x, event.y);
                    }
                    DropTarget.this.selectedDataType = null;
                    DropTarget.this.selectedOperation = 0;
                    DropTarget.this.notifyListeners(2004, event);
                    if (event.dataType != null) {
                        int i = 0;
                        while (i < allowedTypes.length) {
                            if (allowedTypes[i].type == event.dataType.type) {
                                DropTarget.this.selectedDataType = event.dataType;
                                break;
                            }
                            ++i;
                        }
                    }
                    if (DropTarget.this.selectedDataType != null && (event.detail & allowedOperations) != 0) {
                        DropTarget.this.selectedOperation = event.detail;
                    }
                }
                control = DropTarget.this.control;
                if (control == null || control.isDisposed()) {
                    return;
                }
                control.getDisplay().timerExec(delay, DropTarget.this.dragOverHeartbeat);
            }
        };
    }

    static int checkStyle(int style) {
        if (style == 0) {
            return 2;
        }
        return style;
    }

    static int DragReceiveHandler(int theWindow, int handlerRefCon, int theDrag) {
        DropTarget target = DropTarget.FindDropTarget(theWindow, theDrag);
        if (target == null) {
            return 0;
        }
        return target.dragReceiveHandler(theWindow, handlerRefCon, theDrag);
    }

    static int DragTrackingHandler(int message, int theWindow, int handlerRefCon, int theDrag) {
        if (message == 5 || message == 1) {
            CurrentDropTarget = null;
            return 0;
        }
        DropTarget target = DropTarget.FindDropTarget(theWindow, theDrag);
        if (CurrentDropTarget != null) {
            if (target == null || DropTarget.CurrentDropTarget.control.handle != target.control.handle) {
                CurrentDropTarget.dragTrackingHandler(4, theWindow, handlerRefCon, theDrag);
                CurrentDropTarget = target;
                message = 2;
            }
        } else {
            CurrentDropTarget = target;
            message = 2;
        }
        if (target == null) {
            return 0;
        }
        return target.dragTrackingHandler(message, theWindow, handlerRefCon, theDrag);
    }

    static DropTarget FindDropTarget(int theWindow, int theDrag) {
        Display display = Display.findDisplay(Thread.currentThread());
        if (display == null || display.isDisposed()) {
            return null;
        }
        Point mouse = new Point();
        OS.GetDragMouse(theDrag, mouse, null);
        int[] theRoot = new int[1];
        OS.GetRootControl(theWindow, theRoot);
        int[] theControl = new int[1];
        Rect rect = new Rect();
        OS.GetWindowBounds(theWindow, (short)32, rect);
        CGPoint inPoint = new CGPoint();
        inPoint.x = mouse.h - rect.left;
        inPoint.y = mouse.v - rect.top;
        int[] event = new int[1];
        OS.CreateEvent(0, 1836021107, 1, 0.0, 0, event);
        OS.SetEventParameter(event[0], 2003660661, 1751740532, 8, inPoint);
        OS.HIViewGetViewForMouseEvent(theRoot[0], event[0], theControl);
        OS.ReleaseEvent(event[0]);
        if (!OS.IsControlEnabled(theControl[0])) {
            return null;
        }
        Widget widget = display.findWidget(theControl[0]);
        if (widget == null) {
            return null;
        }
        return (DropTarget)widget.getData("DropTarget");
    }

    public void addDropListener(DropTargetListener listener) {
        if (listener == null) {
            DND.error(4);
        }
        DNDListener typedListener = new DNDListener(listener);
        typedListener.dndWidget = this;
        this.addListener(2002, typedListener);
        this.addListener(2003, typedListener);
        this.addListener(2004, typedListener);
        this.addListener(2005, typedListener);
        this.addListener(2006, typedListener);
        this.addListener(2007, typedListener);
    }

    protected void checkSubclass() {
        String validName;
        String name = this.getClass().getName();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.swt.dnd.DropTarget");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (!(validName = clazz.getName()).equals(name)) {
            DND.error(43);
        }
    }

    int dragReceiveHandler(int theWindow, int handlerRefCon, int theDrag) {
        this.updateDragOverHover(0L, null);
        if (this.keyOperation == -1) {
            return -1857;
        }
        DNDEvent event = new DNDEvent();
        event.widget = this;
        event.time = (int)System.currentTimeMillis();
        event.detail = 0;
        this.notifyListeners(2003, event);
        event = new DNDEvent();
        if (!this.setEventData(theDrag, event)) {
            return -1857;
        }
        this.keyOperation = -1;
        int allowedOperations = event.operations;
        TransferData[] allowedDataTypes = new TransferData[event.dataTypes.length];
        System.arraycopy(event.dataTypes, 0, allowedDataTypes, 0, event.dataTypes.length);
        event.dataType = this.selectedDataType;
        event.detail = this.selectedOperation;
        this.selectedDataType = null;
        this.selectedOperation = 0;
        this.notifyListeners(2007, event);
        if (event.dataType != null) {
            int i = 0;
            while (i < allowedDataTypes.length) {
                if (allowedDataTypes[i].type == event.dataType.type) {
                    this.selectedDataType = allowedDataTypes[i];
                    break;
                }
                ++i;
            }
        }
        if (this.selectedDataType != null && (event.detail & allowedOperations) != 0) {
            this.selectedOperation = event.detail;
        }
        if (this.selectedOperation == 0) {
            return -1857;
        }
        byte[][] data = new byte[][]{};
        short[] numItems = new short[1];
        OS.CountDragItems(theDrag, numItems);
        short i = 0;
        while (i < numItems[0]) {
            int[] theItemRef = new int[1];
            OS.GetDragItemReferenceNumber(theDrag, (short)(i + 1), theItemRef);
            int[] size = new int[1];
            OS.GetFlavorDataSize(theDrag, theItemRef[0], this.selectedDataType.type, size);
            if (size[0] > 0) {
                byte[] buffer = new byte[size[0]];
                OS.GetFlavorData(theDrag, theItemRef[0], this.selectedDataType.type, buffer, size, 0);
                byte[][] newData = new byte[data.length + 1][];
                System.arraycopy(data, 0, newData, 0, data.length);
                newData[data.length] = buffer;
                data = newData;
            }
            i = (short)(i + 1);
        }
        Object object = null;
        int i2 = 0;
        while (i2 < this.transferAgents.length) {
            Transfer transfer = this.transferAgents[i2];
            if (transfer != null && transfer.isSupportedType(this.selectedDataType)) {
                this.selectedDataType.data = data;
                object = transfer.nativeToJava(this.selectedDataType);
                break;
            }
            ++i2;
        }
        if (object == null) {
            this.selectedOperation = 0;
        }
        event.dataType = this.selectedDataType;
        event.detail = this.selectedOperation;
        event.data = object;
        this.notifyListeners(2006, event);
        this.selectedOperation = 0;
        if ((allowedOperations & event.detail) == event.detail) {
            this.selectedOperation = event.detail;
        }
        int action = this.opToOsOp(this.selectedOperation);
        OS.SetDragDropAction(theDrag, action);
        return this.selectedOperation == 0 ? -1857 : 0;
    }

    int dragTrackingHandler(int message, int theWindow, int handlerRefCon, int theDrag) {
        DNDEvent event;
        if (message == 4) {
            this.updateDragOverHover(0L, null);
            OS.SetThemeCursor(0);
            if (this.keyOperation == -1) {
                return -1857;
            }
            this.keyOperation = -1;
            DNDEvent event2 = new DNDEvent();
            event2.widget = this;
            event2.time = (int)System.currentTimeMillis();
            event2.detail = 0;
            this.notifyListeners(2003, event2);
            return 0;
        }
        int oldKeyOperation = this.keyOperation;
        if (message == 2) {
            this.selectedDataType = null;
            this.selectedOperation = 0;
        }
        if (!this.setEventData(theDrag, event = new DNDEvent())) {
            this.keyOperation = -1;
            OS.SetThemeCursor(18);
            return -1857;
        }
        int allowedOperations = event.operations;
        TransferData[] allowedDataTypes = new TransferData[event.dataTypes.length];
        System.arraycopy(event.dataTypes, 0, allowedDataTypes, 0, allowedDataTypes.length);
        switch (message) {
            case 2: {
                event.type = 2002;
                break;
            }
            case 3: {
                if (this.keyOperation == oldKeyOperation) {
                    event.type = 2004;
                    event.dataType = this.selectedDataType;
                    event.detail = this.selectedOperation;
                    break;
                }
                event.type = 2005;
                event.dataType = this.selectedDataType;
            }
        }
        this.updateDragOverHover(50L, event);
        this.selectedDataType = null;
        this.selectedOperation = 0;
        this.notifyListeners(event.type, event);
        if (event.detail == 16) {
            int n = event.detail = (allowedOperations & 2) != 0 ? 2 : 0;
        }
        if (event.dataType != null) {
            int i = 0;
            while (i < allowedDataTypes.length) {
                if (allowedDataTypes[i].type == event.dataType.type) {
                    this.selectedDataType = allowedDataTypes[i];
                    break;
                }
                ++i;
            }
        }
        if (this.selectedDataType != null && (allowedOperations & event.detail) != 0) {
            this.selectedOperation = event.detail;
        }
        OS.SetDragDropAction(theDrag, this.opToOsOp(this.selectedOperation));
        switch (this.selectedOperation) {
            case 1: {
                OS.SetThemeCursor(1);
                break;
            }
            case 4: {
                OS.SetThemeCursor(2);
                break;
            }
            case 2: {
                OS.SetThemeCursor(0);
                break;
            }
            default: {
                OS.SetThemeCursor(18);
            }
        }
        if (message == 2) {
            this.dragOverHeartbeat.run();
        }
        return 0;
    }

    public Control getControl() {
        return this.control;
    }

    public DropTargetListener[] getDropListeners() {
        Listener[] listeners = this.getListeners(2002);
        int length = listeners.length;
        DropTargetListener[] dropListeners = new DropTargetListener[length];
        int count = 0;
        int i = 0;
        while (i < length) {
            Listener listener = listeners[i];
            if (listener instanceof DNDListener) {
                dropListeners[count] = (DropTargetListener)((DNDListener)listener).getEventListener();
                ++count;
            }
            ++i;
        }
        if (count == length) {
            return dropListeners;
        }
        DropTargetListener[] result = new DropTargetListener[count];
        System.arraycopy(dropListeners, 0, result, 0, count);
        return result;
    }

    public DropTargetEffect getDropTargetEffect() {
        return this.dropEffect;
    }

    int getOperationFromKeyState(int theDrag) {
        boolean command;
        short[] modifiers = new short[1];
        OS.GetDragModifiers(theDrag, modifiers, null, null);
        boolean option = (modifiers[0] & 0x800) == 2048;
        boolean bl = command = (modifiers[0] & 0x100) == 256;
        if (option && command) {
            return 4;
        }
        if (option) {
            return 1;
        }
        if (command) {
            return 2;
        }
        return 16;
    }

    public Transfer[] getTransfer() {
        return this.transferAgents;
    }

    void onDispose() {
        if (this.control == null) {
            return;
        }
        if (this.controlListener != null) {
            this.control.removeListener(12, this.controlListener);
        }
        this.controlListener = null;
        this.control.setData("DropTarget", null);
        this.transferAgents = null;
        this.control = null;
    }

    int opToOsOp(int operation) {
        int osOperation = 0;
        if ((operation & 1) != 0) {
            osOperation |= 1;
        }
        if ((operation & 4) != 0) {
            osOperation |= 2;
        }
        if ((operation & 2) != 0) {
            osOperation |= 0x10;
        }
        return osOperation;
    }

    int osOpToOp(int osOperation) {
        int operation = 0;
        if ((osOperation & 1) != 0) {
            operation |= 1;
        }
        if ((osOperation & 2) != 0) {
            operation |= 4;
        }
        if ((osOperation & 0x10) != 0) {
            operation |= 2;
        }
        if (osOperation == -1) {
            operation = 7;
        }
        return operation;
    }

    public void removeDropListener(DropTargetListener listener) {
        if (listener == null) {
            DND.error(4);
        }
        this.removeListener(2002, listener);
        this.removeListener(2003, listener);
        this.removeListener(2004, listener);
        this.removeListener(2005, listener);
        this.removeListener(2006, listener);
        this.removeListener(2007, listener);
    }

    public void setDropTargetEffect(DropTargetEffect effect) {
        this.dropEffect = effect;
    }

    boolean setEventData(int theDrag, DNDEvent event) {
        int operation;
        if (theDrag == 0) {
            return false;
        }
        int style = this.getStyle();
        int[] outActions = new int[1];
        OS.GetDragAllowableActions(theDrag, outActions);
        int operations = this.osOpToOp(outActions[0]) & style;
        if (operations == 0) {
            return false;
        }
        this.keyOperation = operation = this.getOperationFromKeyState(theDrag);
        if (operation == 16) {
            if ((style & 0x10) == 0) {
                operation = (operations & 2) != 0 ? 2 : 0;
            }
        } else if ((operation & operations) == 0) {
            operation = 0;
        }
        short[] numItems = new short[1];
        OS.CountDragItems(theDrag, numItems);
        int[] flavors = new int[10];
        int index = -1;
        short i = 0;
        while (i < numItems[0]) {
            int[] theItemRef = new int[1];
            OS.GetDragItemReferenceNumber(theDrag, (short)(i + 1), theItemRef);
            short[] numFlavors = new short[1];
            OS.CountDragItemFlavors(theDrag, theItemRef[0], numFlavors);
            int[] theType = new int[1];
            int j = 0;
            while (j < numFlavors[0]) {
                theType[0] = 0;
                if (OS.GetFlavorType(theDrag, theItemRef[0], (short)(j + 1), theType) == 0) {
                    boolean unique = true;
                    int k = 0;
                    while (k < flavors.length) {
                        if (flavors[k] == theType[0]) {
                            unique = false;
                            break;
                        }
                        ++k;
                    }
                    if (unique) {
                        if (index == flavors.length - 1) {
                            int[] temp = new int[flavors.length + 10];
                            System.arraycopy(flavors, 0, temp, 0, flavors.length);
                            flavors = temp;
                        }
                        flavors[++index] = theType[0];
                    }
                }
                ++j;
            }
            i = (short)(i + 1);
        }
        if (index == -1) {
            return false;
        }
        TransferData[] dataTypes = new TransferData[index + 1];
        index = -1;
        int i2 = 0;
        while (i2 < dataTypes.length) {
            if (flavors[i2] != 0) {
                TransferData data = new TransferData();
                data.type = flavors[i2];
                int j = 0;
                while (j < this.transferAgents.length) {
                    Transfer transfer = this.transferAgents[j];
                    if (transfer != null && transfer.isSupportedType(data)) {
                        dataTypes[++index] = data;
                        break;
                    }
                    ++j;
                }
            }
            ++i2;
        }
        if (index == -1) {
            return false;
        }
        if (index < dataTypes.length - 1) {
            TransferData[] temp = new TransferData[index + 1];
            System.arraycopy(dataTypes, 0, temp, 0, index + 1);
            dataTypes = temp;
        }
        Point mouse = new Point();
        OS.GetDragMouse(theDrag, mouse, null);
        event.widget = this;
        event.x = mouse.h;
        event.y = mouse.v;
        event.time = (int)System.currentTimeMillis();
        event.feedback = 1;
        event.dataTypes = dataTypes;
        event.dataType = dataTypes[0];
        event.operations = operations;
        event.detail = operation;
        if (this.dropEffect != null) {
            event.item = this.dropEffect.getItem(event.x, event.y);
        }
        return true;
    }

    public void setTransfer(Transfer[] transferAgents) {
        if (transferAgents == null) {
            DND.error(4);
        }
        this.transferAgents = transferAgents;
    }

    void updateDragOverHover(long delay, DNDEvent event) {
        if (delay == 0L) {
            this.dragOverStart = 0L;
            this.dragOverEvent = null;
            return;
        }
        this.dragOverStart = System.currentTimeMillis() + delay;
        if (this.dragOverEvent == null) {
            this.dragOverEvent = new DNDEvent();
        }
        this.dragOverEvent.x = event.x;
        this.dragOverEvent.y = event.y;
        this.dragOverEvent.dataTypes = event.dataTypes;
        this.dragOverEvent.operations = event.operations;
        this.dragOverEvent.dataType = event.dataType;
        this.dragOverEvent.detail = event.detail;
    }
}

