/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.story.core.model.change;

import edu.mit.story.core.StoryMessages;
import edu.mit.story.core.desc.Desc;
import edu.mit.story.core.desc.IDesc;
import edu.mit.story.core.model.IMutableStoryModel;
import edu.mit.story.core.model.IStoryData;
import edu.mit.story.core.model.change.AbstractModelChange;
import edu.mit.story.core.model.change.Change;
import edu.mit.story.core.model.change.ChangeMapConstructor;
import edu.mit.story.core.model.change.Flag;
import edu.mit.story.core.model.change.StoryChangeEvent;
import edu.mit.story.core.position.IHasPosition;
import edu.mit.story.core.position.SimplePosition;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DescPositionChange
extends AbstractModelChange {
    protected final long[] ids;
    protected final int[] offsets;
    protected final int[] lengths;

    public DescPositionChange(long id, int offset, int length) {
        super(StoryMessages.CHANGE_NAME_SetDescriptionPosition);
        if (offset < 0 || length < 0) {
            throw new NullPointerException();
        }
        this.ids = new long[]{id};
        this.offsets = new int[]{offset};
        this.lengths = new int[]{length};
    }

    public DescPositionChange(long[] ids, int[] offsets, int[] lengths) {
        super(StoryMessages.CHANGE_NAME_SetDescriptionPosition);
        int i = 0;
        while (i < ids.length) {
            if (offsets[i] < 0 || lengths[i] < 0) {
                throw new IllegalArgumentException();
            }
            ++i;
        }
        this.ids = new long[ids.length];
        System.arraycopy(ids, 0, this.ids, 0, ids.length);
        this.offsets = new int[offsets.length];
        System.arraycopy(offsets, 0, this.offsets, 0, offsets.length);
        this.lengths = new int[lengths.length];
        System.arraycopy(lengths, 0, this.lengths, 0, lengths.length);
    }

    public DescPositionChange(List<Long> ids, List<Integer> offsets, List<Integer> lengths) {
        super(StoryMessages.CHANGE_NAME_SetDescriptionPosition);
        int i = 0;
        while (i < ids.size()) {
            if (offsets.get(i) < 0 || lengths.get(i) < 0) {
                throw new NullPointerException();
            }
            ++i;
        }
        this.ids = new long[ids.size()];
        i = 0;
        while (i < ids.size()) {
            this.ids[i] = ids.get(i);
            ++i;
        }
        this.offsets = new int[offsets.size()];
        i = 0;
        while (i < offsets.size()) {
            this.offsets[i] = offsets.get(i);
            ++i;
        }
        this.lengths = new int[lengths.size()];
        i = 0;
        while (i < lengths.size()) {
            this.lengths[i] = lengths.get(i);
            ++i;
        }
    }

    @Override
    protected StoryChangeEvent doApply(Object source, IMutableStoryModel provider) {
        IStoryData descs = provider.getData();
        LinkedList<Long> oldIDs = new LinkedList<Long>();
        LinkedList<Integer> oldOffsets = new LinkedList<Integer>();
        LinkedList<Integer> oldLengths = new LinkedList<Integer>();
        ChangeMapConstructor cache = new ChangeMapConstructor();
        int i = 0;
        while (i < this.ids.length) {
            IDesc desc = descs.getDescription(this.ids[i]);
            if (desc != null && (desc.getOffset() != this.offsets[i] || desc.getLength() != this.lengths[i])) {
                descs.remove(desc);
                oldIDs.add(desc.getID());
                oldOffsets.add(desc.getOffset());
                oldLengths.add(desc.getLength());
                cache.add(desc.getRep(), new Change(Flag.DESC_REMOVED, (IHasPosition[])new IDesc[]{desc}));
                desc = new Desc(desc.getID(), desc.getRep(), new SimplePosition(this.offsets[i], this.lengths[i]), desc.getData(), desc.getMetaData());
                descs.add(desc);
                cache.add(desc.getRep(), new Change(Flag.DESC_ADDED, (IHasPosition[])new IDesc[]{desc}));
            }
            ++i;
        }
        if (oldIDs.isEmpty()) {
            return null;
        }
        DescPositionChange undo = new DescPositionChange(oldIDs, oldOffsets, oldLengths);
        return new StoryChangeEvent(source, provider, cache.getChangeMap(), this, undo);
    }
}

