/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.story.core.model.change;

import edu.mit.story.core.model.IMutableStoryModel;
import edu.mit.story.core.model.change.AbstractModelChange;
import edu.mit.story.core.model.change.IModelChange;
import edu.mit.story.core.model.change.StoryChangeEvent;
import edu.mit.story.core.model.change.StoryChangeEventIntegrator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompositeModelChange
extends AbstractModelChange {
    public final List<IModelChange> changeList;

    public CompositeModelChange(IModelChange ... changes) {
        this(Arrays.asList(changes));
    }

    public CompositeModelChange(Collection<? extends IModelChange> changes) {
        this("", changes);
    }

    public CompositeModelChange(String name, Collection<? extends IModelChange> changes) {
        super(name);
        this.changeList = changes == null || changes.isEmpty() ? Collections.emptyList() : Collections.unmodifiableList(new ArrayList<IModelChange>(changes));
    }

    @Override
    protected StoryChangeEvent doApply(Object source, IMutableStoryModel model) {
        StoryChangeEventIntegrator integrator = new StoryChangeEventIntegrator(source, model);
        for (IModelChange change : this.changeList) {
            integrator.addEvent(change.apply(source, model));
        }
        return integrator.asEvent();
    }

    public IModelChange[] getChildren() {
        return this.changeList.toArray(new IModelChange[this.changeList.size()]);
    }
}

