/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.story.core.desc;

import edu.mit.story.core.align.IAlignedStoryModel;
import edu.mit.story.core.align.IDescMap;
import edu.mit.story.core.desc.DescUtils;
import edu.mit.story.core.desc.IData;
import edu.mit.story.core.desc.IDesc;
import edu.mit.story.core.meta.IMetaDataMap;
import edu.mit.story.core.meta.IMetaDataSet;
import edu.mit.story.core.meta.IMetaDesc;
import edu.mit.story.core.meta.MetaDataMap;
import edu.mit.story.core.meta.MetaDataSet;
import edu.mit.story.core.position.IHasPosition;
import edu.mit.story.core.position.SimplePosition;
import edu.mit.story.core.rep.IRep;
import edu.mit.story.core.rep.RepUtils;
import java.util.Collection;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Desc
implements IDesc {
    private final IRep rep;
    private final long id;
    private final int offset;
    private final int length;
    private final int rightOffset;
    private final IData data;
    private final String dataStr;
    private final IMetaDataMap metadata;

    public Desc(long id, IRep rep, int offset, int length, IData data, Iterable<? extends IMetaDesc<?>> metadata) {
        this(id, rep, new SimplePosition(offset, length), data, metadata);
    }

    public Desc(long id, IRep rep, IHasPosition p, IData data, Iterable<? extends IMetaDesc<?>> metadata) {
        if (rep == null) {
            throw new NullPointerException();
        }
        if (id < 0L) {
            throw new IllegalArgumentException();
        }
        if (p == null) {
            throw new NullPointerException();
        }
        if (data == null) {
            throw new NullPointerException();
        }
        if (!RepUtils.isLegalDataType(rep, data)) {
            throw new IllegalArgumentException();
        }
        this.rep = rep;
        this.id = id;
        this.offset = p.getOffset();
        this.length = p.getLength();
        this.rightOffset = this.offset + this.length;
        this.data = data;
        this.dataStr = rep.serialize(data);
        this.metadata = Desc.processMetadata(metadata);
    }

    public Desc(String dataStr, IRep rep, long id, IHasPosition p, Iterable<? extends IMetaDesc<?>> metadata) {
        if (rep == null) {
            throw new NullPointerException();
        }
        if (p == null) {
            throw new NullPointerException();
        }
        if (id < 0L) {
            throw new IllegalArgumentException();
        }
        this.rep = rep;
        this.id = id;
        this.offset = p.getOffset();
        this.length = p.getLength();
        this.rightOffset = this.offset + this.length;
        this.data = null;
        this.dataStr = dataStr;
        this.metadata = Desc.processMetadata(metadata);
    }

    @Override
    public IRep getRep() {
        return this.rep;
    }

    @Override
    public long getID() {
        return this.id;
    }

    @Override
    public int getOffset() {
        return this.offset;
    }

    @Override
    public int getLength() {
        return this.length;
    }

    @Override
    public int getRightOffset() {
        return this.rightOffset;
    }

    @Override
    public IData getData() {
        return this.data;
    }

    @Override
    public String getDataString() {
        return this.dataStr;
    }

    @Override
    public int compareTo(IDesc that) {
        return DescUtils.compareAsDescriptions(this, that);
    }

    public String toString() {
        String p = "[off=" + this.offset + ",len=" + this.length + "](" + this.id + ")";
        return "[" + this.rep.getID() + "@" + p + ": " + this.dataStr + "]";
    }

    @Override
    public IMetaDataMap getMetaData() {
        return this.metadata;
    }

    protected static IMetaDataMap processMetadata(Iterable<? extends IMetaDesc<?>> c) {
        MetaDataMap result = new MetaDataMap();
        if (c != null) {
            for (IMetaDesc<?> d : c) {
                IMetaDataSet ds = result.get(d.getMetaRep());
                if (ds == null) {
                    ds = new MetaDataSet(d.getMetaRep());
                    result.put(ds.getMetaRep(), ds);
                }
                ds.add(d);
            }
        }
        return result;
    }

    @Override
    public boolean equals(IDesc desc, IAlignedStoryModel model) {
        IDesc matched;
        IDescMap map;
        if (this == desc) {
            return true;
        }
        if (model != null && (map = model.get(this.rep)) != null && (matched = model.get(this.rep).getDescription(this.id)) == desc) {
            return true;
        }
        if (!this.equals(desc.getOffset(), desc.getLength(), model)) {
            return false;
        }
        return this.data.equals(desc.getData(), model);
    }

    @Override
    public boolean equals(int tgtOff, int tgtLen, IAlignedStoryModel model) {
        int srcRoff;
        int srcOff;
        if (model == null) {
            srcOff = this.offset;
            srcRoff = this.rightOffset;
        } else {
            srcOff = model.getAlignedText().getOffset(this.offset);
            srcRoff = model.getAlignedText().getRightOffset(this.rightOffset);
        }
        if (srcOff != tgtOff) {
            return false;
        }
        return srcRoff == tgtOff + tgtLen;
    }

    public static final boolean equals(Collection<? extends IDesc> srcDescs, Collection<? extends IDesc> tgtDescs, IAlignedStoryModel model) {
        if (srcDescs == tgtDescs) {
            return true;
        }
        if (srcDescs.size() != tgtDescs.size()) {
            return false;
        }
        Iterator<? extends IDesc> srcItr = srcDescs.iterator();
        Iterator<? extends IDesc> tgtItr = tgtDescs.iterator();
        while (srcItr.hasNext() && tgtItr.hasNext()) {
            if (Desc.equals(srcItr.next(), tgtItr.next(), model)) continue;
            return false;
        }
        return true;
    }

    public static final boolean equals(IDesc srcDesc, IDesc tgtDesc, IAlignedStoryModel model) {
        if (srcDesc == tgtDesc) {
            return true;
        }
        if (srcDesc == null || tgtDesc == null) {
            return false;
        }
        return srcDesc.equals(tgtDesc, model);
    }
}

